'Intel LAN Driver install Script
'Version ITL.17.01

'---------------------------------
'C
'---------------------------------
'Version ITL.17.01 (2018/12/11)
'  EIntel R23.5PV
'  EWS2019
'  EX550-BT2(GreenPick LOM, N8104-157)/X710(N8104-158)/I350(N8104-168)

'---------------------------------
'---------------------------------
Option Explicit

'---------------------------------
'ScriptShellp̐ݒ
'---------------------------------
Dim objShell, objFS, ExePath

Set objShell    = WScript.CreateObject("Wscript.Shell")
Set objFS       = WScript.CreateObject("Scripting.FileSystemObject")
ExePath         = WScript.ScriptFullName 
ExePath         = left(ExePath,len(ExePath)-len(WScript.ScriptName)-1) 

'---------------------------------
'START
'---------------------------------
Dim WINDIR, LOGDIR, SYSPATH, DrvCmd, objexec, Msg, Err_Flag, LogFile, strArgPlat, sParentKey, oReg, aKeys, I, J, DevFound, DRLOGFILENAME, SCLOGFILENAME, Pci_Ids, RegSet
Dim InsOpt, InsOpt2, INTELInstalled, INTELDriver

WINDIR          = objShell.ExpandEnvironmentStrings("%windir%")
LOGDIR          = WINDIR & "\$SYSUP$\LOG\LAN"
SYSPATH         = WINDIR & "\system32"
DRLOGFILENAME   = "INTLDRV.LOG"
SCLOGFILENAME   = "INTL_INSTSCRP.LOG"
Err_Flag        = 0
DevFound        = False
INTELInstalled  = False
DevFound        = False
INTELDriver     = "Intel(R) Network Connections"
Pci_Ids         = Array("VEN_8086&DEV_1521", "VEN_8086&DEV_1528", "VEN_8086&DEV_1563", "VEN_8086&DEV_1572")
'                        /* I350 */           /* X540-AT2 */       /* X550-BT2 */       /* X710 */

'--------------------
'sIvV
'--------------------
InsOpt   = "/qn /norestart BD=1 ANS=0 DMIX=0 SNMP=0 /liew " & LOGDIR & "\" & DRLOGFILENAME

Msg = Now & vbCrLf
Msg = Msg & "Starting the Installation. (ScriptVersion ITL.17.01)" & vbCrLf

'-------------------
'Log̃tH_쐬
'-------------------
If objFS.FolderExists(LOGDIR) = False Then
    objFS.Createfolder(LOGDIR)
End If

'-----------------------
'IntelA_v^̑݊mF
'-----------------------
Const HKEY_LOCAL_MACHINE = &H80000002

sParentKey = "SYSTEM\CurrentControlSet\Enum\PCI"

Set oReg = GetObject("winmgmts:{impersonationLevel=impersonate}" & _
"!root/default:StdRegProv")

oReg.enumkey HKEY_LOCAL_MACHINE,sParentKey,aKeys

For I=0 to UBound(aKeys)
  For J=0 to UBound(Pci_Ids)
    If InStr(aKeys(I), Pci_Ids(J)) <> 0 Then
      ' ΏۃfoCXB
      DevFound = True
    End If
  Next
Next

'--------------
'̃`FbN
'--------------
If WScript.Arguments.Count = 0 Then
    Msg = Msg & "No Options specified." & vbCrLf
    Err_Flag = 1
End If

If Err_Flag = 0 Then
    '----------------------
    'Plat.擾
    '----------------------
    strArgPlat = WScript.Arguments.Named("Plat")

    '-----------
    '̏
    '-----------
    If (strArgPlat="2019") Then

        DrvCmd = ExePath & "\intel\R235\APPS\PROSETDX\Winx64\DxSetup.exe " & InsOpt

    Else

        Msg = Msg & "Installation Aborted. UnKnown Install Option:" & strArgPlat
        Err_Flag = 1

    End If

End If

If Err_Flag = 0 Then

    '-----------------------------------
    'UninstallWXg݂邩mF
    '-----------------------------------
    On Error Resume Next
    If IsNull(objShell.regread("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\")) Then

        Msg = Msg & "Uninstall registry not found." & vbCrLf

    Else

        '-----------------------------------
        'IntelDriverCXg[ς݂mF
        '-----------------------------------
        Dim SubKeySet, SubKey, stdRegProv
        Set stdRegProv = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")

        stdRegProv.EnumKey HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall", SubKeySet
        
        For Each SubKey In SubKeySet

            Dim Value : Value = ""
            Dim Result : Result = stdRegProv.GetStringValue(HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\" & SubKey, "DisplayName", Value)

            If Result = 0 Then

                If UCase(INTELDriver) = UCase(Left(Value, Len(INTELDriver))) Then
                    INTELInstalled = True
                End If

            End If

        Next

    End If
    On Error Goto 0

    If (strArgPlat="2019") Then

        '-------------------------
        'NIC(Intel) Driver Install
        '-------------------------
        If INTELInstalled <> True Then

            If DevFound = True Then

                Set objexec = objShell.exec(DrvCmd) 
                Do While objexec.Status = 0
                    WScript.Sleep 1000
                Loop

                WScript.Sleep 5000

                If objexec.ExitCode <> 0 Then

                    Msg = Msg & "Intel Driver Installation Failed. ret=" & objexec.ExitCode & vbCrLf
                    Err_Flag = 1

                Else

                    Msg = Msg & "Intel Driver Installation Completed." & vbCrLf

                End If

            Else

                Msg = Msg & "Intel LAN adapters are not existed." & vbCrLf

            End If

        Else

            Msg = Msg & "INTEL Driver is already installed." & vbCrLf

        End If

    End If

End If

If Err_Flag = 0 Then

    '--------------
    'bZ[W
    '--------------
    Msg = Msg & Now & vbCrLf
    Msg = Msg & "Installation Executed on Windows. " & strArgPlat & " Platform."
    WScript.Echo "Intel Driver Installation Completed!"

Else

    '----------------
    'G[bZ[W
    '----------------
    Msg = Msg & Now & vbCrLf
    Msg = Msg & "Installation Failed. " & strArgPlat & " Platform."
    WScript.Echo "Intel Driver Installation Failed!"

End If

'--------
'Message
'--------
If objFS.FileExists(LOGDIR & "\" & SCLOGFILENAME) = False Then
    objFS.CreateTextFile(LOGDIR & "\" & SCLOGFILENAME)
End If

Set LogFile = objFS.OpenTextFile(LOGDIR & "\" & SCLOGFILENAME, 8, True)
LogFile.WriteLine(Msg)
LogFile.WriteLine()
LogFile.Close()

'--------------
'Close Object
'--------------
Set objShell = nothing
Set objFS    = nothing
Set objexec  = nothing
Set LogFile  = nothing
Set oReg     = nothing

'--------------
'Exit Script
'--------------
WScript.Quit(Err_Flag)
