'Broadcom LAN Driver install Script
'Version BCM.09.01

'---------------------------------
'C
'---------------------------------
'Version BCM.09.01 (2016/08/25)
'  EBroadcom v20.4.4.1
'  EWS2016
'  EBCM5718(N8104-150/151)/BCM5719(N8104-152/154)/BCM5720(LOM)

'---------------------------------
'---------------------------------
Option Explicit

'---------------------------------
'ScriptShellp̐ݒ
'---------------------------------
Dim objShell, objFS, ExePath

Set objShell    = WScript.CreateObject("Wscript.Shell")
Set objFS       = WScript.CreateObject("Scripting.FileSystemObject")
ExePath         = WScript.ScriptFullName 
ExePath         = left(ExePath,len(ExePath)-len(WScript.ScriptName)-1) 

'---------------------------------
'START
'---------------------------------
Dim WINDIR, LOGDIR, SYSPATH, DrvCmd, objexec, Msg, Err_Flag, LogFile, strArgPlat, sParentKey, oReg, aKeys, I, J, DevFound, DRLOGFILENAME, SCLOGFILENAME, UTLOGFILENAME, Pci_Ids, RegSet
Dim InsOpt, InsOpt2, BCOMInstalled, BCOMDriver

WINDIR          = objShell.ExpandEnvironmentStrings("%windir%")
LOGDIR          = WINDIR & "\$SYSUP$\LOG\LAN"
SYSPATH         = WINDIR & "\system32"
DRLOGFILENAME   = "BCOMDRV.LOG"
UTLOGFILENAME   = "BCOMBACS.LOG"
SCLOGFILENAME   = "BCOM_INSTSCRP.LOG"
Err_Flag        = 0
DevFound        = False
BCOMInstalled   = False
BCOMDriver      = "Broadcom Gigabit Integrated Controller"
Pci_Ids         = Array("VEN_14E4&DEV_1656", "VEN_14E4&DEV_1657", "VEN_14E4&DEV_165F")
'                        /* BCM5718 */        /* BCM5719 */        /* BCM5720 */

'--------------------
'sIvV
'--------------------
InsOpt   = "/s /v" & chr(&H22) & "/qn REBOOT=ReallySuppress" & " " & "/L" & " " & LOGDIR & "\" 
InsOpt2  = "-s" & " " & LOGDIR & "\"

Msg = Now & vbCrLf
Msg = Msg & "Starting the Installation. (ScriptVersion BCM.09.01)" & vbCrLf

'-------------------
'Log̃tH_쐬
'-------------------
If objFS.FolderExists(LOGDIR) = False Then
    objFS.Createfolder(LOGDIR)
End If

'----------------------
'BcomA_v^̑݊mF
'----------------------
Const HKEY_LOCAL_MACHINE = &H80000002

sParentKey = "SYSTEM\CurrentControlSet\Enum\PCI"

Set oReg = GetObject("winmgmts:{impersonationLevel=impersonate}" & _
"!root/default:StdRegProv")

oReg.enumkey HKEY_LOCAL_MACHINE,sParentKey,aKeys

For I=0 to UBound(aKeys)
  For J=0 to UBound(Pci_Ids)
    If InStr(aKeys(I), Pci_Ids(J)) <> 0 Then
      ' ΏۃfoCXB
      DevFound = True
    End If
  Next
Next

'--------------
'̃`FbN
'--------------
If WScript.Arguments.Count = 0 Then
    Msg = Msg & "No Options specified." & vbCrLf
    Err_Flag = 1
End If

If Err_Flag = 0 Then
    '----------------------
    'Plat.擾
    '----------------------
    strArgPlat = WScript.Arguments.Named("Plat")

    '-----------
    '̏
    '-----------
    If (strArgPlat="2016") Then

        DrvCmd  = ExePath & "\bcom\DrvInst\20040401\x64\setup.exe " & InsOpt & DRLOGFILENAME & chr(&H22)
        RegSet  = ExePath & "\pgdyavd.exe " & InsOpt2

    Else

        Msg = Msg & "Installation Aborted. UnKnown Install Option:" & strArgPlat
        Err_Flag = 1

    End If

End If

If Err_Flag = 0 Then

    '-----------------------------------
    'UninstallWXg݂邩mF
    '-----------------------------------
    On Error Resume Next
    If IsNull(objShell.regread("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\")) Then

        Msg = Msg & "Uninstall registry not found." & vbCrLf

    Else

        '----------------------------------
        'BcomDriverCXg[ς݂mF
        '----------------------------------
        Dim SubKeySet, SubKey, stdRegProv
        Set stdRegProv = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")

        stdRegProv.EnumKey HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall", SubKeySet
        
        For Each SubKey In SubKeySet

            Dim Value : Value = ""
            Dim Result : Result = stdRegProv.GetStringValue(HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\" & SubKey, "DisplayName", Value)

            If Result = 0 Then

                If UCase(BCOMDriver) = UCase(Left(Value, Len(BCOMDriver))) Then
                    BCOMInstalled = True
                End If

            End If

        Next

    End If
    On Error Goto 0

    If BCOMInstalled <> True Then

        If DevFound = True Then

            '-------------------
            'Bcom Driver Install
            '-------------------
            Set objexec = objShell.exec(DrvCmd) 
            Do While objexec.Status = 0
                WScript.Sleep 1000
            Loop

            WScript.Sleep 5000

            Msg = Msg & "BCOM Driver Installation Completed." & vbCrLf

            '---------------------
            'Add RxMaxCoalesced=0
            '---------------------
            Set objexec = objShell.exec(RegSet) 
            Do While objexec.Status = 0
                WScript.Sleep 1000
            Loop

            WScript.Sleep 5000

            Msg = Msg & "Add RxMaxCoalesced Completed." & vbCrLf

        Else

            Msg = Msg & "BCOM LAN adapters are not existed." & vbCrLf

        End If

    Else

        Msg = Msg & "BCOM Driver is already installed." & vbCrLf

    End If

End If

If Err_Flag = 0 Then

    '--------------
    'bZ[W
    '--------------
    Msg = Msg & Now & vbCrLf
    Msg = Msg & "Installation Executed on Windows. " & strArgPlat & " Platform."
    WScript.Echo "BCOM Driver Installation Completed!"

Else

    '----------------
    'G[bZ[W
    '----------------
    Msg = Msg & Now & vbCrLf
    Msg = Msg & "Installation Failed. " & strArgPlat & " Platform."
    WScript.Echo "BCOM Driver Installation Failed!"

End If

'--------
'Message
'--------
If objFS.FileExists(LOGDIR & "\" & SCLOGFILENAME) = False Then
    objFS.CreateTextFile(LOGDIR & "\" & SCLOGFILENAME)
End If

Set LogFile = objFS.OpenTextFile(LOGDIR & "\" & SCLOGFILENAME, 8, True)
LogFile.WriteLine(Msg)
LogFile.WriteLine()
LogFile.Close()

'--------------
'Close Object
'--------------
Set objShell = nothing
Set objFS    = nothing
Set objexec  = nothing
Set LogFile  = nothing
Set oReg     = nothing

'--------------
'Exit Script
'--------------
WScript.Quit(Err_Flag)
