' for lsi_sas2.sys
' Version 2.1.0.0(2013.03.01)
' Version 2.2.0.0(2013.05.31)

'-------------------------------------------------
' `̕ϐgpȂ
'-------------------------------------------------
Option Explicit

'-------------------------------------------------
' t@C/WXgpObject쐬
'-------------------------------------------------
Dim objShell
Set objShell = CreateObject("Wscript.Shell")

Dim objFS
Set objFS = WScript.CreateObject("Scripting.FileSystemObject")

Dim objReg
Set objReg = CreateObject("Wscript.Shell")

'-------------------------------------------------
' ArchType̎擾(Function)
'-------------------------------------------------
Function GetArchType()
  Dim ArchString
  ArchString = objShell.RegRead("HKLM\System\CurrentControlSet\Control\Session Manager\Environment\PROCESSOR_ARCHITECTURE")
  Select Case ArchString
    Case "AMD64"
      GetArchType = "x64"
    Case "x86"
      GetArchType = "x86"
    Case Else
      GetArchType = "UnKnown"
  End Select
End Function

'-------------------------------------------------
' OS Type̎擾(Function)
'-------------------------------------------------
Function GetOSType()
  ' Windows XP/2003Check
  Dim BuildNumber, ProductName, InstallationType

  BuildNumber      = objShell.RegRead("HKLM\Software\Microsoft\Windows NT\CurrentVersion\CurrentBuildNumber")
  ProductName      = objShell.RegRead("HKLM\Software\Microsoft\Windows NT\CurrentVersion\ProductName")
  GetOSType = "Unknown"

  ' BuildNumber < 2195(XPȑOOS)̏ꍇ́AUnKnownŕԋp
  If BuildNumber < 2195 Then
     Exit Function
  End If

  Select Case BuildNumber
    Case 2195
      GetOSType = "W2K"
    Case 2600
      GetOSType = "XP"
    Case 3790
      GetOSType = "W2K3"
  End Select
  
  If GetOSType <> "Unknown" Then
    Exit Function
  End If
  
  ' Windows Vista/Windows Server 2008check

  If BuildNumber > 3790 Then
    If BuildNumber < 7000 Then
      If InStr(ProductName, "Vista") <> 0 Then
        GetOSType = "Vista"
      Else
        GetOSType = "WS2008"
      End If
      Exit Function
    End If
  End If

  ' Windows7/Windows Server 2008 R2check

  If BuildNumber > 6999 Then
    If BuildNumber < 9200 Then
      ' Windows 7 /Windows Server 2008 R2ȍ~݂ȂWXĝ߁AœǂݍށB
      InstallationType = objShell.RegRead("HKLM\Software\Microsoft\Windows NT\CurrentVersion\InstallationType")
      Select Case InstallationType
        Case "Client"
          GetOSType = "Win7"
        Case Else
          GetOSType = "WS2008R2"
      End Select
    End If
  End If

  'Windows8/Windows 2012Check

  If BuildNumber > 9199 Then
    ' Windows 7 /Windows Server 2008 R2ȍ~݂ȂWXĝ߁AœǂݍށB
    InstallationType = objShell.RegRead("HKLM\Software\Microsoft\Windows NT\CurrentVersion\InstallationType")
    Select Case InstallationType
      Case "Client"
        GetOSType = "Win8"
      Case Else
        GetOSType = "WS2012"
    End Select
  End If

  'Windows8.1/Windows 2012R2Check

  If BuildNumber > 9599 Then
    ' Windows 7 /Windows Server 2008 R2ȍ~݂ȂWXĝ߁AœǂݍށB
    InstallationType = objShell.RegRead("HKLM\Software\Microsoft\Windows NT\CurrentVersion\InstallationType")
    Select Case InstallationType
      Case "Client"
        GetOSType = "Win8.1"
      Case Else
        GetOSType = "WS2012R2"
    End Select
  End If


End Function

'-------------------------------------------------
' t@C̃o[WуTCYr
'-------------------------------------------------
Function CompareFile(FileName1st, FileName2nd)
  CompareFile = False

  If objFS.FileExists(FileName1st) <> True Then
    Exit Function
  End If

  If objFS.FileExists(FileName2nd) <> True Then
    Exit Function
  End If

  If objFS.GetFileVersion(FileName1st) = objFS.GetFileVersion(FileName2nd) Then
    If objFS.Getfile(FileName1st).Size = objFS.Getfile(FileName2nd).Size Then
      CompareFile = True
    End If
  End If
End Function

'-------------------------------------------------
' G[̒`
'-------------------------------------------------
Dim ErrSpace, ErrSuccess, ErrArch, ErrNoDev, ErrOS, ErrCancel, ErrUnknown, ErrCfgRead
ErrSuccess = 0 '
ErrSpace   = 1 'Xy[X̂tH_Ŏs
ErrArch    = 2 'VXeA[LeN`ΉĂȂ
ErrNoDev   = 3 'Abvf[gΏۃfoCXȂ
ErrOS      = 4 'OSΉĂȂ
ErrCancel  = 5 '[ULZ
ErrUnknown = 6 'sȃG[
ErrCfgRead = 7 'update.vbspRtBOt@Cɓǂݍ߂Ȃ

'-------------------------------------------------
' ϐ̎擾/ݒ
'-------------------------------------------------
Dim WINDIR, SYSPATH, FileSource, PopupEnable, PnputilMaxRetry
WINDIR = objShell.ExpandEnvironmentStrings("%windir%") ' WindowsCXg[ĂpX
SYSPATH = WINDIR & "\system32"                         ' System32̂pX
FileSource = Left(WScript.ScriptFullName, Instr(WScript.ScriptFullName, WScript.ScriptName)-1)
PopupEnable = True                                    ' Popup\邩ǂ True=\ False=\ɃhCoCXg[
PnputilMaxRetry = 5                                    ' Pnputilł܂CXg[łȂꍇ̃gC

' L܂ł͐錾/`Ȃ̂ŁAs
' KphCoɍ킹ăCύXKv
'========================================================
'                      C
'========================================================
Dim WindowTitle                 ' Popup̃EChE^Cg
Dim ProcessType                 ' bZ[Wɕ\鏈̖̂Lڂł܂BsetupupdateȂǁB
Dim DriverName                  ' syst@C
Dim DriverReg                   ' Servicesz̃WXg
Dim DriverType                  ' COfoCX̂L(OEMpɌ^Ԃ͋LڂȂ)
Dim DrvInfName                  ' hCoinf
Dim Pci_Ids                     ' hCoKpΏۂVendorID/DeviceIDi[z
'Dim DevID                       ' ۂ̃foCXID  

WindowTitle = "Driver Setup"
ProcessType = "setup"
DriverName = "LSI_SAS2.sys"
DriverReg  = "LSI_SAS2"
DriverType = "SAS Controller"
DrvInfName = "LSI_SAS2.inf"
Pci_Ids    = Array("VEN_1000&DEV_0072")

'--------------------------------------------------------
' tH_`FbN(pXɃXy[XsłȂ)
'--------------------------------------------------------
If InStr(1, FileSource, " ", vbTextCompare) <> 0 Then
  If PopupEnable = True Then
    MsgBox "You cannot execute the program on this folder." & Chr(13) & Chr(10) & "Execute it on the folder with the name that contains no blank characters.",vbExclamation, WindowTitle
  End If
  WScript.Quit ErrSpace
End If

'--------------------------------------------------------
'CXg[mFbZ[W
'--------------------------------------------------------
If PopupEnable = True Then
  Dim intMsg
  intMsg = MsgBox("Do you want to " & ProcessType & " the " & DriverType & " driver?",vbYesNo,WindowTitle)

  If intMsg = vbNo Then
    MsgBox "This " & ProcessType & " canceled." ,, WindowTitle
    WScript.Quit ErrCancel
  End if
End If

'--------------------------------------------------------
'foCX̑݊mF(x_IDŃ`FbN)
'--------------------------------------------------------
Dim oReg, sParentKey, aKeys, I, J
Dim DevFound

Const HKEY_LOCAL_MACHINE = &H80000002

sParentKey = "SYSTEM\CurrentControlSet\Enum\PCI"

Set oReg = GetObject("winmgmts:{impersonationLevel=impersonate}" & _
"!root/default:StdRegProv")

oReg.enumkey HKEY_LOCAL_MACHINE,sParentKey,aKeys

DevFound = False

For I=0 to UBound(aKeys)
  For J=0 to UBound(Pci_Ids)
    If InStr(aKeys(I), Pci_Ids(J)) <> 0 Then
      ' ΏۃfoCXB
      DevFound = True
    End If
  Next
Next

If DevFound = False Then
  ' ΏۃfoCX݂Ȃꍇ́A𒆎~B
  If PopupEnable = True Then
    MsgBox DriverType & " not Found. This " & ProcessType & " canceled." ,vbExclamation, WindowTitle
  End If
  WScript.Quit ErrNoDev
End If

'--------------------------------------------------------
' OS/Arch擾
'--------------------------------------------------------
Dim OSType
Dim ArchType

OSType = GetOSType()
Select Case OSType
  Case "Win7"
  Case "Win8"
  Case "WS2008"
  Case "WS2008R2"
  Case "WS2012"
  Case "WS2012R2"
  Case Else
    IF PopupEnable = True Then
      MsgBox "Failed to check the operating system. This " & ProcessType & " canceled." ,vbExclamation, WindowTitle
    End If
    WScript.Quit ErrOS
End Select

ArchType = GetArchType()
Select Case ArchType
  Case "x86"
  Case "x64"
  Case Else
    IF PopupEnable = True Then
      MsgBox "Failed to check the system architecture. This " & ProcessType & " canceled." ,vbExclamation, WindowTitle
    End If
    WScript.Quit ErrArch
End Select

'--------------------------------------------------------
' Driver̂tH_
'--------------------------------------------------------
Dim DriverPath
DriverPath = OSType & ArchType

Private cmdline                     ' sR}hC
Private src_inffile
Private src_drvfile
Private dist_drvfile

'*******************************************************
'hCõCXg[(Lsi_sas2.sys. for Windows 2008)
'*******************************************************
If OSType = "WS2008" Then

  src_inffile  = FileSource & DriverPath & "\" & DrvInfName
  src_drvfile  = FileSource & DriverPath & "\" & DriverName
  dist_drvfile = SYSPATH & "\drivers\" & DriverName

  For I = 0 to PnputilMaxRetry
    cmdline = "pnputil -i -a " & src_inffile
    If PopupEnable = True Then
      objShell.Run cmdline, 1, 1
    Else
      objShell.Run cmdline, 0, 1
    End If
    If CompareFile(dist_drvfile, src_drvfile) = True Then
      If PopupEnable = True Then
        MsgBox "This " & ProcessType & " finished successfully. Please restart the system." ,, WindowTitle
      End If
      WScript.Quit ErrSuccess
    End If
    WScript.Sleep(5000)
  Next
End If

'*******************************************************
'hCõCXg[(Lsi_sas2.sys for Windows 2008R2)
'*******************************************************
If OSType = "WS2008R2" Then

  src_inffile  = FileSource & DriverPath & "\" & DrvInfName
  src_drvfile  = FileSource & DriverPath & "\" & DriverName
  dist_drvfile = SYSPATH & "\drivers\" & DriverName

  For I = 0 to PnputilMaxRetry
    cmdline = "pnputil -i -a " & src_inffile
    If PopupEnable = True Then
      objShell.Run cmdline, 1, 1
    Else
      objShell.Run cmdline, 0, 1
    End If
    If CompareFile(dist_drvfile, src_drvfile) = True Then
      If PopupEnable = True Then
        MsgBox "This " & ProcessType & " finished successfully. Please restart the system." ,, WindowTitle
      End If
      WScript.Quit ErrSuccess
    End If
    WScript.Sleep(5000)
  Next
End If

'*******************************************************
'hCõCXg[(Lsi_sas2.sys for Windows 2012)
'*******************************************************
If OSType = "WS2012" Then

  src_inffile  = FileSource & DriverPath & "\" & DrvInfName
  src_drvfile  = FileSource & DriverPath & "\" & DriverName
  dist_drvfile = SYSPATH & "\drivers\" & DriverName

  For I = 0 to PnputilMaxRetry
    cmdline = "pnputil -i -a " & src_inffile
    If PopupEnable = True Then
      objShell.Run cmdline, 1, 1
    Else
      objShell.Run cmdline, 0, 1
    End If
    If CompareFile(dist_drvfile, src_drvfile) = True Then
      If PopupEnable = True Then
        MsgBox "This " & ProcessType & " finished successfully. Please restart the system." ,, WindowTitle
      End If
      WScript.Quit ErrSuccess
    End If
    WScript.Sleep(5000)
  Next
End If

'*******************************************************
'hCõCXg[(Lsi_sas2.sys for Windows 2012R2)
'*******************************************************
If OSType = "WS2012R2" Then

  src_inffile  = FileSource & DriverPath & "\" & DrvInfName
  src_drvfile  = FileSource & DriverPath & "\" & DriverName
  dist_drvfile = SYSPATH & "\drivers\" & DriverName

  For I = 0 to PnputilMaxRetry
    cmdline = "pnputil -i -a " & src_inffile
    If PopupEnable = True Then
      objShell.Run cmdline, 1, 1
    Else
      objShell.Run cmdline, 0, 1
    End If
    If CompareFile(dist_drvfile, src_drvfile) = True Then
      If PopupEnable = True Then
        MsgBox "This " & ProcessType & " finished successfully. Please restart the system." ,, WindowTitle
      End If
      WScript.Quit ErrSuccess
    End If
    WScript.Sleep(5000)
  Next
End If

'--------------------------------------------------------
' {sȂ(ErrUnKnownŏI)
'--------------------------------------------------------
If PopupEnable = True Then
  MsgBox "This " & ProcessType & " failed." ,, WindowTitle
End If
WScript.Quit ErrUnknown

