#!/bin/sh

export AXIS2C_HOME=/opt/nec/axis2c
export LANG=`cat $AXIS2C_HOME/lang`
export LD_LIBRARY_PATH=$AXIS2C_HOME/lib

AXIS2_HTTP_SV_START_LOG=$AXIS2C_HOME/bin/axis2_http_sv_start.log
EX_AXIS2_HTTP_SV_START_LOG=$AXIS2C_HOME/bin/Ex_axis2_http_sv_start.log
SYSTEMCTL_FILE=/usr/bin/systemctl

Put_Log() {
	if [ -e $AXIS2_HTTP_SV_START_LOG ]; then
		LOG_SIZE=`du -sS $AXIS2_HTTP_SV_START_LOG | sed -e "s/\/opt.*//"`

		if [ $LOG_SIZE -gt "1000" ]; then
			mv -f $AXIS2_HTTP_SV_START_LOG $EX_AXIS2_HTTP_SV_START_LOG
		fi
	fi
	
	echo `date '+%Y/%m/%d %T'` "$1" >> $AXIS2_HTTP_SV_START_LOG
}

Check_Axis() {
	COUNT=0
	LOOP_END=0

	if [ -e $SYSTEMCTL_FILE ]; then
	  RETRY_COUNT=100
	else
	  RETRY_COUNT=10
	fi

	while [ -z "`ps --no-header -C axis2_http_serv`" -a $COUNT -lt $RETRY_COUNT ]
	do
	  COUNT=`expr $COUNT + 1`
	  if [ -e $SYSTEMCTL_FILE ]; then
	    usleep 100000
	  else
	    sleep 1
	  fi
	done
	

	if [ $COUNT -ge $RETRY_COUNT ]
	then
	  echo "axis2_http_server not found."
	  exit 1
	fi

	if [ -e $SYSTEMCTL_FILE ]; then
	  LOOP_COUNT=30
	
	  while [ $LOOP_END -lt $LOOP_COUNT ]
	  do
	    AXIS2_HTTP_SV_CHECK=`ps ax | grep axis2_http | grep defunct`
	    if [ -n "$AXIS2_HTTP_SV_CHECK" ]; then
	      sleep 1
	      LOOP_END=`expr $LOOP_END + 1`
	    else
	      Put_Log "LOOP_END=$LOOP_END"
	      LOOP_END=$LOOP_COUNT
	    fi
	  done
	fi
}

cp -afpr $AXIS2C_HOME/bin/eciService.xml $AXIS2C_HOME/bin/eciService.xml.old >/dev/null 2>&1
cp -afpr $AXIS2C_HOME/bin/eciService.xml.org $AXIS2C_HOME/bin/eciService.xml >/dev/null 2>&1

cd $AXIS2C_HOME/bin

ulimit -c unlimited

CNT=`ls core.* 2>/dev/null | wc -l`

if [ $CNT -gt 3 ]
then
  for c in `ls -rt core.*`
  do
    if [ $CNT -le 3 ]
    then
      break;
    else
      rm -f $c
      CNT=`expr $CNT - 1`
    fi
  done
fi

. $AXIS2C_HOME/bin/eci_setport.sh

if [ -z "`ps --no-header -C slpd`" ]
then
  LOOP_CNT=0
  LOOP_END=0

  if [ -x /usr/sbin/slpd ]
  then
    $AXIS2C_HOME/bin/eciSlpdStart /usr/sbin/slpd
  elif [ -x /sbin/slpd ]
  then
    $AXIS2C_HOME/bin/eciSlpdStart /sbin/slpd
  else
    $AXIS2C_HOME/bin/eciSlpdStart "$AXIS2C_HOME/bin/slpd -l $AXIS2C_HOME/bin/slpd.log -c $AXIS2C_HOME/bin/slp.conf"
  fi

  while [ $LOOP_CNT -lt 10 -a $LOOP_END -eq 0 ]
  do
    if [ -z "`pgrep -f slpd`" ]
    then
      LOOP_CNT=`expr $LOOP_CNT + 1`
      sleep 1
    else
      LOOP_END=1
    fi
  done

  if [ $LOOP_CNT -ge 10 ]
  then
    echo "SLPD Daemon Not Founds"
  else
    sleep 3
  fi
fi

if [ -z "`pgrep -f $AXIS2C_HOME/bin/eciServiceProgram`" ]
then
  $AXIS2C_HOME/bin/eciServiceProgram -start > $AXIS2C_HOME/bin/eci_start.log 2>&1

  if [ $? -eq 0 ]
  then
    Check_Axis

    if [ -e $SYSTEMCTL_FILE ]; then
      ECI_INIT_CHECK_COUNT=0
      ECI_INIT_CHECK_RETRY_COUNT=10
      
      while [ $ECI_INIT_CHECK_COUNT -lt $ECI_INIT_CHECK_RETRY_COUNT ]
      do
        ECI_INIT_CHECK=`ps ax | grep eciInitProcess | grep -v grep`
        if [ -n "$ECI_INIT_CHECK" ]; then
          sleep 1
          ECI_INIT_CHECK_COUNT=`expr $ECI_INIT_CHECK_COUNT + 1`
        else
          Put_Log "ECI_INIT_CHECK_COUNT=$ECI_INIT_CHECK_COUNT"
          ECI_INIT_CHECK_COUNT=$ECI_INIT_CHECK_RETRY_COUNT
        fi
      done

      AXIS2_HTTP_SV_PID=`pgrep -f axis2_http_server`
      kill $AXIS2_HTTP_SV_PID
    
      if [ $? -eq 0 ]; then
        Put_Log "axis2_http_server start."
      else
        Put_Log "Failed to start axis2_http_server."
      fi
    
      Check_Axis
    fi

    XMLPORT=`sed -n 's/.*<PortNum>\(.*\)<\/PortNum>/\1/p' $AXIS2C_HOME/bin/eciService.xml`
    PORTSZ=`echo $XMLPORT | wc -c`
    PORTSZ=`expr $PORTSZ - 1`
    PORTNUM=`echo $XMLPORT | cut -c1-$PORTSZ`

    XMLPORT=`sed -n 's/.*<UserPort>\(.*\)<\/UserPort>/\1/p' $AXIS2C_HOME/bin/eciService.xml.org`
    PORTNUM1=0
    PORTSZ=`echo $XMLPORT | wc -c`
    PORTSZ=`expr $PORTSZ - 1`
    if [ $PORTSZ -ne 0 ]
    then
      PORTNUM1=`echo $XMLPORT | cut -c1-$PORTSZ`
    fi
    if [[ $PORTNUM -ne $PORTNUM1 ]]
    then
      set_slpportnm
      set_eciportnm
    fi
  fi

  if [ -s $AXIS2C_HOME/bin/eci_start.log ]
  then
    cat $AXIS2C_HOME/bin/eci_start.log
  fi
else
  echo "eciServiceProgram has already started."
fi

touch /var/lock/subsys/eciServiceProgram
