#!/bin/bash
IFS=$'\n'

if [ -d /var/lock/subsys ]; then
    lockfile=/var/lock/subsys/raidcmd
else
    lockfile=/var/lock/raidcmd
fi
ret=0

trap 'rm -f $lockfile; echo "raidcmd:<RU4006> Command failed."; exit 1' 1 2 3 15 20

if [ -f $lockfile ]; then
    echo "raidcmd:<RU4009> The raidcmd command is already running.";
    exit 1;
fi

touch $lockfile
if [ $? != 0 ]; then
    echo "raidcmd:<RU4006> Command failed.";
    exit 1
fi

/opt/nec/raidcmd/raidcmd $*
ret=$?

rm -f $lockfile

exit $ret
