#!/bin/sh

## outputFilename
get_version_filename="Get_version.xml";
update_normal_filename="Update_normal.xml";
update_force_filename="Update_force.xml";
install_filename="Install.xml";
uninstall_filename="Un_install.xml";

## Arguments
get_version_arg="version";
update_normal_arg="UpdateNormal";
update_force_arg="UpdateForce";
install_arg="Install";
uninstall_arg="Uninstall";

## Revision String
revision="Rev ";

# outputXmlFile
# filename
# resultCode
# cmp
# version
# return value: none
outputXmlFile(){
    echo "<?xml version='1.0' encoding='UTF-8'?>" > $1;
    echo "<Response>" >> $1;
    echo "<result_code>"$2"</result_code>" >> $1;
    echo "<data>" >> $1;
    if [ "$2" ]; then
        echo "<cmp>"$3"</cmp>" >> $1;
    fi
    if [ "$4" ]; then
        echo "<version>"$4"</version>" >> $1;
    fi
    echo "</data>" >> $1;
    echo "</Response>" >> $1;
}

# verCompare - compare $1 and $2
# return value:  2 when $1 > $2
#                1 when $1 = $2
#                0 when $1 < $2
verCompare(){
    arg1major=`echo $1 | cut -d " " -f 1 | cut -d . -f 1`; arg1major=`expr ${arg1major} + 0`;
    arg1minor=`echo $1 | cut -d " " -f 1 | cut -d . -f 2`; arg1minor=`expr ${arg1minor} + 0`;
    arg1rev=`echo $1 | cut -d " " -f 3`; arg1rev=`expr ${arg1rev} + 0`;
    arg2major=`echo $2 | cut -d " " -f 1 | cut -d . -f 1`; arg2major=`expr ${arg2major} + 0`;
    arg2minor=`echo $2 | cut -d " " -f 1 | cut -d . -f 2`; arg2minor=`expr ${arg2minor} + 0`;
    arg2rev=`echo $2 | cut -d " " -f 3`; arg2rev=`expr ${arg2rev} + 0`;

    if [ -z $arg1rev ]; then
        arg1rev=0;
    fi
    if [ -z $arg2rev ]; then
        arg2rev=0;
    fi

    if [ $arg1major -gt $arg2major ]; then
        return 2;
    elif [ $arg1major -lt $arg2major ]; then
        return 0;
    else
        if [ $arg1minor -gt $arg2minor ]; then
            return 2;
        elif [ $arg1minor -lt $arg2minor ]; then
            return 0;
        else
            if [ $arg1rev -gt $arg2rev ]; then
                return 2;
            elif [ $arg1rev -lt $arg2rev ]; then
                return 0;
            else
                return 1;
            fi
        fi
    fi
}
# getReptblLang $# $2
# return value: 1 -> en
#               0 -> jp
getReptblLang(){
    if [ `cat /opt/nec/report/inf/raidsrv.inf | grep LanguageID | cut -d "\"" -f 2` == 'E' ]; then
        return 1;
    else
        return 0;
    fi
}

if [ $# -eq 0 ]; then
    exit 1;
fi

# duplexCheck
if [ `ps ax | grep -c "sh.*setup.sh.*"` -gt 1 ]; then
    case "$1" in
        ${get_version_arg})
            outputXmlFile ${get_version_filename} "Busy"
        ;;
        ${update_normal_arg})
            outputXmlFile ${update_normal_filename} "Duplex"
        ;;
        ${update_force_arg})
            outputXmlFile ${update_force_filename} "Duplex"
        ;;
        ${install_arg})
            outputXmlFile ${install_filename} "Duplex"
        ;;
        ${uninstall_arg})
            outputXmlFile ${uninstall_filename} "Duplex"
        ;;
    esac
    exit 1;
fi

# get Package URU Version
uruNewVersion=`cat ./ExUpInfo.xml | grep \<version\> | cut -d ">" -f 2 | cut -d "<" -f 1`

# get Current URU Version
if [ -f /opt/nec/raidsrv/version.txt ]; then
    uruCurrentVersion=`cat /opt/nec/raidsrv/version.txt | grep Ver | cut -d " " -f 6`" "${revision}`cat /opt/nec/raidsrv/version.txt | grep Revision | cut -d " " -f 2`
    len=`echo $((${#uruCurrentVersion}))`
    uruCurrentVersion=`echo ${uruCurrentVersion} | cut -c 1-${len}`
fi

# compare URU version
resultCmp=null;
if [ -n "${uruCurrentVersion}" ]; then
    verCompare "${uruNewVersion}" "${uruCurrentVersion}";
    ret=$?;
    if [ ${ret} -eq 1 ]; then
        resultCmp="Even";
    elif [ ${ret} -eq 0 ]; then
        resultCmp="Lower";
    else
        resultCmp="Upper";
    fi
fi

# find raidsrv agent
installOpt="--install";
if [ ! -d "/opt/nec/axis2c/bin/AgentFolder/raidsrv_agent" ]; then
	installOpt="--nomgr";
fi

case "$1" in
    ${get_version_arg})
        if [ -n "${uruCurrentVersion}" ]; then
            outputXmlFile ${get_version_filename} "OK" ${resultCmp} "${uruCurrentVersion}";
        else
            outputXmlFile ${get_version_filename} "Not-install";
        fi
        ;;

    ${update_normal_arg})
        if [ -n "${uruCurrentVersion}" ]; then
            verCompare "2.40" "${uruCurrentVersion}";
            if [ $? -eq 2 ]; then
                outputXmlFile ${update_normal_filename} "NotInstalled";
            elif [ ${resultCmp} = "Lower" ]; then
                outputXmlFile ${update_normal_filename} "DownGrade";
            else
                outputXmlFile ${update_normal_filename} "OK";
                sleep 30s;
                getReptblLang;
                ret=$?;
                sh ./lnx_vm4/setup.sh --uninstall --eua;
                if [ ${ret} -eq 0 ]; then
                    sh ./lnx_vm4/setup.sh ${installOpt} --reptbljp --eua;
                else
                    sh ./lnx_vm4/setup.sh ${installOpt} --reptblen --eua;
                fi
                outputXmlFile ${update_normal_filename} "Complete";
            fi
        else
            outputXmlFile ${update_normal_filename} "NotInstalled";
        fi
        ;;

    ${update_force_arg})
        if [ -n "${uruCurrentVersion}" ]; then
            verCompare "2.40" "${uruCurrentVersion}";
            if [ $? -eq 2 ]; then
                outputXmlFile ${update_force_filename} "NotInstalled";
            else
                outputXmlFile ${update_force_filename} "OK";
                sleep 30s;
                getReptblLang;
                ret=$?;
                sh ./lnx_vm4/setup.sh --uninstall --eua;
                if [ ${ret} -eq 0 ]; then
                    sh ./lnx_vm4/setup.sh ${installOpt} --reptbljp --eua;
                else
                    sh ./lnx_vm4/setup.sh ${installOpt} --reptblen --eua;
                fi
                outputXmlFile ${update_force_filename} "Complete";
            fi
        else
            outputXmlFile ${update_force_filename} "NotInstalled";
        fi
        ;;

    ${install_arg})
        if [ -n "${uruCurrentVersion}" ]; then
            outputXmlFile ${install_filename} "AlreadyInstalled";
        else
            outputXmlFile ${install_filename} "OK";
            sleep 30s;
            sh ./lnx_vm4/setup.sh --install --eua;
            outputXmlFile ${install_filename} "Complete";
        fi
        ;;

    ${uninstall_arg})
        if [ -n "${uruCurrentVersion}" ]; then
            verCompare "2.40" "${uruCurrentVersion}";
            if [ $? -eq 2 ]; then
                outputXmlFile ${uninstall_filename} "NotInstalled";
            else
                outputXmlFile ${uninstall_filename} "OK";
                sleep 30s;
                sh ./lnx_vm4/setup.sh --uninstall;
                outputXmlFile ${uninstall_filename} "Complete";
            fi
        else
            outputXmlFile ${uninstall_filename} "NotInstalled";
        fi
        ;;

    *)
        exit 1;
        ;;
esac


  
