#/****************************************************************
#*               COPYRIGHT (C) NEC CORPORATION 2017              *
#*                                                               *
#*    ALL RIGHTS RESERVED BY NEC CORPORATION. THIS PROGRAM MUST  *
#* BE USED SOLELY FOR THE PURPOSE FOR WHICH IT WAS FURNISHED BY  *
#* NEC CORPORATION.  NO PART OF THIS PROGRAM MAY BE REPRODUCED   *
#* OR DISCLOSED TO OTHERS,IN ANY FORM,WITHOUT THE PRIOR WRITTEN  *
#* PERMISSON OF NEC CORPORATION.                                 *
#*    USE OF COPYRIGHT NOTICE DOES NOT EVIDENCE PUBLICATION OF   *
#* THE PROGRAM.                                                  *
#*                                                               *
#*               NEC CONFIDENTIAL AND PROPRIENTARY               *
#****************************************************************/

import sys
import redfish
import json
import gc

REST_OBJ = None

def init(iLO_host,login_account,login_password):
    global REST_OBJ
    #if REST_OBJ is None:
    REST_OBJ = redfish.redfish_client(base_url=iLO_host,username=login_account, \
                      password=login_password, default_prefix='/redfish/v1')
    if REST_OBJ is not None:
        REST_OBJ.login(auth="session")

def get(uri):
    global REST_OBJ
    response = REST_OBJ.get(uri, None)
    enc_data = response.read
    del response
    return enc_data

def close():
    global REST_OBJ
    if REST_OBJ is not None:
        REST_OBJ.logout()
        del REST_OBJ
        REST_OBJ = None
    gc.collect()
    return
