#!/bin/sh

# permission check
id | grep uid=0 > /dev/null
if [ $? -ne 0 ]; then
  echo "Please execute by root user."
  echo
  exit 1;
fi

# variables
setup_path=`echo $0 | sed s/setup.sh//g`
if [ -z ${setup_path} ]; then
    setup_path="./"
fi
product="RAID Report Service";
raidsrv_package="raidsrv-1.00-0.x86_64.*rpm";
installver="1.00";
uname -r | grep 'el6' >& /dev/null
if [ $? -eq 0 ]; then
    raidsrv_package="raidsrv-1.00-0.el6.x86_64.*rpm";
fi
uname -r | grep 'el8' >& /dev/null
if [ $? -eq 0 ]; then
    raidsrv_package="raidsrv-1.00-0.el8.x86_64.*rpm";
    installver="1.00";
fi

declare -i errcode;
errcode=0;

usage_message="usage: setup.sh --install [--reptbljp | --reptblen]\n\
       setup.sh --uninstall"

# needToInstallUru - make decision to install RAID Report Service
# return value: 1 -> need to install RAID Report Service
#               0 -> doesn't need to install RAID Report Service
needToInstallUru(){
    rpm -q raidsrv >& /dev/null
    if [ $? = 0 ]; then    
        echo "        Setup error: RAID Report Service has been already installed.";
        echo "        Please uninstall existing version to install this version.";
        return 0;
    fi
    return 1; # first installation
}

# SelectReptbl $# $2
# return value: 1 -> Selected Reptbl
#               2 -> No select Reptbl option
#               0 -> Option error
selectReptbl(){
    if [ $1 -eq 1 ]; then
        return 2;
    elif [ $1 -ge 2 ]; then
        case "$2" in
            --reptbljp)
                echo ja > /var/tmp/reptbl.tmp; # Set Japanese
                ;;
            --reptblen)
                echo en > /var/tmp/reptbl.tmp; # Set English
                ;;
            *)
                return 0; # second option error
                ;;
        esac
    else
        return 0; # too much options
    fi
    return 1;
}

# chkRaidctrl
# return value: 1 -> Detect RAID Controller to support
#               0 -> No RAID Controller to support
chkRaidctrl(){
	### Smart RAID Gen10 ###
    lspci -n | grep '9005:028f'  > /dev/null
    if [ $?  -eq 0 ]; then
        return 1;
	fi

	echo "Cannot detect the supported RAID Controller.";
	echo "Installation aborted.";
	return 0;
}

# chkPackages
chkPackages(){
    # check connected RAID controller
    #chkRaidctrl;
    #if [ $? -eq 0 ]; then
    #    exit 1;
    #fi

    # check raidsrv_package
    ls ${setup_path}${raidsrv_package} > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        errcode=$errcode+1;
    fi
}

# parse argument
case "$1" in
  --install)
    # check Packages
    chkPackages $1;
    if [ ${errcode} -ne 0 ]; then
        printf 'Setup error: (errcode: 0x%02x)\n' ${errcode};
        exit 1;
    fi
    
    # check ExpressUpdate
    if [ "$2" == "--eua" ]; then
        # EUA install
        export RAIDSRVexpressUpdate=1;
        # SelectReptbl
        selectReptbl 1;
    elif [ "$3" == "--eua" ]; then
        # EUA Update
        export RAIDSRVexpressUpdate=1;
        # SelectReptbl
        selectReptbl 2 $2;
    else
        # SelectReptbl
        selectReptbl $# $2;
    fi

    if [ $? -eq 0 ]; then
        echo -e "${usage_message}";
        exit 1;
    fi

    # check whether utility is installed
    needToInstallUru;
    if [ $? -eq 0 ]; then
        exit 1; # already installed
    fi

    echo "Installing ${product}...";

    # ldconfig /opt/nec/esmpro_sa/python-2.7/lib

    # install RAID Report Service
    uname -r | grep 'el6' >& /dev/null
    if [ $? -eq 0 ]; then
        rpm -ivh --nodeps ${setup_path}${raidsrv_package};
    else
        rpm -ivh ${setup_path}${raidsrv_package};
    fi
    # sleep 3 seconds to wait service starts
    sleep 3
    rm -f /var/tmp/reptbl.tmp >& /dev/null
    ;;

  --uninstall)
    echo "Uninstalling ${product}...";

    # uninstall by ExpressUpdate
    if [ "$2" == "--eua" ]; then
        export RAIDSRVexpressUpdate=1;
    fi
    
    # uninstall RAID Report Service
    rpm -e raidsrv
    if [ $? -ne 0 ]; then
        # error occurred
        echo "Setup error: Uninstalling package raidsrv is failed."
        exit 1;
    fi
    ;;

  --force-install)    
    # SelectReptbl
    selectReptbl $# $2;
    if [ $? -eq 0 ]; then
        echo -e "${usage_message}";
        exit 1;
    fi

    # uninstall RAID Report Service
    rpm -q raidsrv >& /dev/null
    if [ $? -eq 0 ]; then
        rpm -e raidsrv
        if [ $? -ne 0 ]; then
            # error occurred
            echo "Setup error: Uninstalling package raidsrv is failed."
            exit ;
        fi
    fi

    # force install (there's no support)
    echo "Force installing ${product}...";
    rpm -ivh ${setup_path}${raidsrv_package};
    # sleep 3 seconds to wait service starts
    sleep 3
    rm -f /var/tmp/reptbl.tmp >& /dev/null
    ;;

  --version)
    echo "RAID Report Service installer Ver ${installver}";
    ;;

  *)
    echo -e "${usage_message}";
    ;;
esac

