#!/bin/sh

export AXIS2C_HOME=/opt/nec/axis2c
export LANG=`cat $AXIS2C_HOME/lang`
export LD_LIBRARY_PATH=$AXIS2C_HOME/lib

if [ -n "`pgrep -f $AXIS2C_HOME/bin/eciServiceProgram`" ]
then
  $AXIS2C_HOME/bin/eciServiceProgram -stop > $AXIS2C_HOME/bin/eci_stop.log 2>&1

  if [ $? -eq 0 ]
  then
    XMLPORT=`sed -n 's/.*<PortNum>\(.*\)<\/PortNum>/\1/p' $AXIS2C_HOME/bin/eciService.xml`
    PORTSZ=`echo $XMLPORT | wc -c`
    PORTSZ=`expr $PORTSZ - 1`
    PORTNUM=`echo $XMLPORT | cut -c1-$PORTSZ`

    XMLPORT=`sed -n 's/.*<UserPort>\(.*\)<\/UserPort>/\1/p' $AXIS2C_HOME/bin/eciService.xml.org`
    PORTNUM1=0
    PORTSZ=`echo $XMLPORT | wc -c`
    PORTSZ=`expr $PORTSZ - 1`
    if [ $PORTSZ -ne 0 ]
    then
      PORTNUM1=`echo $XMLPORT | cut -c1-$PORTSZ`
    fi
    if [[ $PORTNUM -ne $PORTNUM1 ]]
    then
      if [ -n "`iptables -L -n | grep $PORTNUM`" ]
      then
        iptables -D INPUT -p tcp --dport $PORTNUM -j ACCEPT >> $AXIS2C_HOME/bin/eci_stop.log 2>&1
      fi
    fi
  fi

  if [ -s $AXIS2C_HOME/bin/eci_stop.log ]
  then
    cat $AXIS2C_HOME/bin/eci_stop.log
  fi
fi

cp -afpr $AXIS2C_HOME/bin/eciService.xml $AXIS2C_HOME/bin/eciService.xml.old >/dev/null 2>&1
cp -afpr $AXIS2C_HOME/bin/eciService.xml.org $AXIS2C_HOME/bin/eciService.xml >/dev/null 2>&1

rm -f /var/lock/subsys/eciServiceProgram
