#!/bin/sh

export AXIS2C_HOME=/opt/nec/axis2c

set_eciportnm ()
{
  XMLPORT=`sed -n 's/.*<PortNum>\(.*\)<\/PortNum>/\1/p' $AXIS2C_HOME/bin/eciService.xml`
  PORTSZ=`echo $XMLPORT | wc -c`
  PORTSZ=`expr $PORTSZ - 1`
  PORTNUM=`echo $XMLPORT | cut -c1-$PORTSZ`

  if [ -z "`iptables -L -n | grep $PORTNUM`" ]
  then
    iptables -I INPUT -p tcp --dport $PORTNUM -j ACCEPT
  fi
}

set_slpportnm ()
{
  SLPPORT=427
  
  if [ -z "`iptables -L -n | grep $SLPPORT`" ]
  then
    iptables -I INPUT -p udp --dport svrloc -j ACCEPT
  fi
}

if [ -z "`pgrep -f $AXIS2C_HOME/bin/eciServiceProgram`" ]
then
  if [ `basename $0` = eci_setport.sh ]
  then
    echo "eciServiceProgram is not started."
  fi
else
  XMLPORT=`sed -n 's/.*<PortNum>\(.*\)<\/PortNum>/\1/p' $AXIS2C_HOME/bin/eciService.xml`
  PORTSZ=`echo $XMLPORT | wc -c`
  PORTSZ=`expr $PORTSZ - 1`
  PORTNUM=`echo $XMLPORT | cut -c1-$PORTSZ`

  XMLPORT=`sed -n 's/.*<UserPort>\(.*\)<\/UserPort>/\1/p' $AXIS2C_HOME/bin/eciService.xml`
  PORTNUM1=0
  PORTSZ=`echo $XMLPORT | wc -c`
  PORTSZ=`expr $PORTSZ - 1`

  if [ $PORTSZ -ne 0 ]
  then
    PORTNUM1=`echo $XMLPORT | cut -c1-$PORTSZ`
  fi

  if [[ $PORTNUM -ne $PORTNUM1 ]]
  then
    if [ `basename $0` = eci_setport.sh ]
    then
      echo "Set port numbers of axis2_http_server and slpd to firewall."
    fi
    set_slpportnm
    set_eciportnm
  fi
fi

