#!/bin/sh

ECI_VERSION=3.21
INTERNAL_ECI_VERSION=321
AXIS2C_HOME=/opt/nec/axis2c
VERSION_FILE_PATH=/etc/ecia/version
ECI_START_SHELL_PATH=$AXIS2C_HOME/bin/eci_start.sh
ECI_STOP_SHELL_PATH=$AXIS2C_HOME/bin/eci_stop.sh
AGENT_START_STOP_PROCESS_PATH=$AXIS2C_HOME/bin/eciControlAgents
ECI_AUTO_START_STOP_SHELL_PATH=/etc/rc.d/init.d/eciServiceProgram
SUSE_ECI_AUTO_START_STOP_SHELL_PATH=/etc/init.d/eciServiceProgram
ECISERVICE_XML_ORG=$AXIS2C_HOME/bin/eciService.xml.org
ECISERVICE_XML_ORG_BAK=$AXIS2C_HOME/bin/eciService.xml.org.bak
#symbolic link
ECI_SYMBOLIC_LINK_PATH_0=/etc/rc.d/rc0.d/K01eciServiceProgram
ECI_SYMBOLIC_LINK_PATH_1=/etc/rc.d/rc1.d/K01eciServiceProgram
ECI_SYMBOLIC_LINK_PATH_2=/etc/rc.d/rc2.d/S99eciServiceProgram
ECI_SYMBOLIC_LINK_PATH_3=/etc/rc.d/rc3.d/S99eciServiceProgram
ECI_SYMBOLIC_LINK_PATH_4=/etc/rc.d/rc4.d/S99eciServiceProgram
ECI_SYMBOLIC_LINK_PATH_5=/etc/rc.d/rc5.d/S99eciServiceProgram
ECI_SYMBOLIC_LINK_PATH_6=/etc/rc.d/rc6.d/K01eciServiceProgram
INSTALL_LOG=/opt/nec/axis2c/bin/ECI_Install.log
PKG_RESULT_FILE=/etc/ecia/result
SLP_LIB_PATH=$AXIS2C_HOME/lib/libslp.so.1.0.0
Message_Tmp=/tmp/ecia
Message_Dir=$Message_Tmp/message

INTERACTIVE_INSTALL=0
SILENT_MODE=0
SILENT_INSTALL=0
SILENT_UNINSTALL=0
INTERACTIVE_NEW_INSTALL=0
SILENT_NEW_INSTALL=0
ECI_INSTALLER=0
ECI_INSTALL=0
INTERACTIVE_UPDATE_INSTALL=0
INTERACTIVE_REINSTALL=0
SILENT_UPDATE_INSTALL=0
SLP_INSTALL=0

#systemd
SYSTEMCTL_FILE=/usr/bin/systemctl

readonly EUA_START_SHELL_PATH=$AXIS2C_HOME/bin/eua_start.sh
readonly EUA_STOP_SHELL_PATH=$AXIS2C_HOME/bin/eua_stop.sh
readonly PKG_START=-pkgstart
readonly EUA_VERSION_FILE_PATH=/etc/eua/version
readonly NEW_OPTION_EUA_VERSION=310

trap 'check_trap; exit 2' 1 2 3 15
trap 'check_trap' EXIT

check_trap(){
	rm -rf $Message_Tmp
}

#function ECI_Make_Install_Log
ECI_Make_Install_Log() {
	if [ -e $INSTALL_LOG ]; then
		LOG_SIZE=`du -sS $INSTALL_LOG | sed -e "s/\/opt.*//"`

		if [ $LOG_SIZE -gt "1000" ]; then
			mv -f $INSTALL_LOG $AXIS2C_HOME/bin/ExECI_Install.log
		fi
	fi
	
	echo `date '+%Y/%m/%d %T'` "Line:[$1]" $2 >> $INSTALL_LOG
}

#function ECI_New_Install
ECI_New_Install() {
	ECI_Make_Install_Log $LINENO "ECI_New_Install() start"
	
	if [ $INTERACTIVE_INSTALL = 1 ]; then
		#INTERACTIVE_NEW_INSTALL_MODE
		rpm -Uvh --allfiles --nomd5 --noscripts $PWD/$ECISERVICE_RPM
		#ECI_Make_Install_Log $LINENO "INTERACTIVE_NEW_INSTALL_MODE. [rpm -Uvh "$PWD/$ECISERVICE_RPM"]"
		ECI_Make_Install_Log $LINENO "INTERACTIVE_NEW_INSTALL_MODE. [rpm -Uvh $PWD/$ECISERVICE_RPM]"
	else
		#SILENT_NEW_INSTALL_MODE
		rpm -U --allfiles --nomd5 --noscripts $PWD/$ECISERVICE_RPM
		ECI_Make_Install_Log $LINENO "SILENT_NEW_INSTALL_MODE. [rpm -U $PWD/$ECISERVICE_RPM]"
	fi
	
	mkdir -p $AXIS2C_HOME/logs
	
	tar xvzf $AXIS2C_HOME/lib.tgz -C $AXIS2C_HOME > /dev/null
	
	echo $LANG >> $AXIS2C_HOME/lang
	
	#OpenSLP library thawing
	if [ $SLP_INSTALL = 1 ]; then
		tar xzvf $AXIS2C_HOME/OpenSLP_lib_1.2.tgz -C $AXIS2C_HOME/lib > /dev/null
	else
		tar xzvf $AXIS2C_HOME/OpenSLP_lib_2.0.tgz -C $AXIS2C_HOME/lib > /dev/null
	fi

	if [ -e $SYSTEMCTL_FILE ]; then
		# systemd
		if [ ! -d $AXIS2C_HOME/scripts ]; then
			mkdir -p $AXIS2C_HOME/scripts
		fi
		mv -f $AXIS2C_HOME/eciServiceProgram $AXIS2C_HOME/scripts
		
		mv -f $AXIS2C_HOME/eciServiceProgram.service /etc/systemd/system
		systemctl daemon-reload > /dev/null 2>&1
		systemctl enable eciServiceProgram.service > /dev/null 2>&1
	else
		# Make symbolic link file
		if [ -e /etc/SuSE-release ]; then
			# SLES
			mv -f $AXIS2C_HOME/eciServiceProgram /etc/init.d
			
			insserv $SUSE_ECI_AUTO_START_STOP_SHELL_PATH >/dev/null 2>&1
		else
			# RHELAESX4.1
			mv -f $AXIS2C_HOME/eciServiceProgram /etc/rc.d/init.d
			ln -s $ECI_AUTO_START_STOP_SHELL_PATH $ECI_SYMBOLIC_LINK_PATH_0
			ln -s $ECI_AUTO_START_STOP_SHELL_PATH $ECI_SYMBOLIC_LINK_PATH_1
			ln -s $ECI_AUTO_START_STOP_SHELL_PATH $ECI_SYMBOLIC_LINK_PATH_2
			ln -s $ECI_AUTO_START_STOP_SHELL_PATH $ECI_SYMBOLIC_LINK_PATH_3
			ln -s $ECI_AUTO_START_STOP_SHELL_PATH $ECI_SYMBOLIC_LINK_PATH_4
			ln -s $ECI_AUTO_START_STOP_SHELL_PATH $ECI_SYMBOLIC_LINK_PATH_5
			ln -s $ECI_AUTO_START_STOP_SHELL_PATH $ECI_SYMBOLIC_LINK_PATH_6
		fi
	fi
	
	#Make version file
	echo $INTERNAL_ECI_VERSION > $VERSION_FILE_PATH
	
	if [ -f /usr/sbin/getenforce ]; then
		SELINUX_CHECK=`getenforce`
		
		if [ $SELINUX_CHECK != "Disabled" ]; then
			if [ -f /usr/sbin/semanage ]; then
				semanage fcontext -a -t textrel_shlib_t /opt/nec/axis2c/services/eciService/libeciService.so
				semanage fcontext -a -t textrel_shlib_t /opt/nec/axis2c/services/eciServicePlain/libeciServicePlain.so
				semanage fcontext -a -t textrel_shlib_t /opt/nec/axis2c/lib/libpwcb.so.0.0.0
				
				ECI_Make_Install_Log $LINENO "semanage command start."
			fi
		fi
	fi
	
	chcon -t textrel_shlib_t /opt/nec/axis2c/services/eciService/libeciService.so 2>>$INSTALL_LOG
	chcon -t textrel_shlib_t /opt/nec/axis2c/services/eciServicePlain/libeciServicePlain.so 2>>$INSTALL_LOG
	chcon -t textrel_shlib_t /opt/nec/axis2c/lib/libpwcb.so.0.0.0 2>>$INSTALL_LOG
	
	ECI_Make_Install_Log $LINENO "SELinux $SELINUX_CHECK."
		
	rm -rf $AXIS2C_HOME/lib.tgz
	rm -rf $AXIS2C_HOME/OpenSLP*
	
	#Make install version file
	echo "ECIService Ver $ECI_VERSION" > $AXIS2C_HOME/bin/eciVersion.txt
	
	ECI_Make_Install_Log $LINENO "ECI_New_Install() end"
}

#function ECI_Update_Install
ECI_Update_Install() {
	ECI_Make_Install_Log $LINENO "ECI_Update_Install() start"
	
	#Agent process stop
	$AGENT_START_STOP_PROCESS_PATH -stop $AXIS2C_HOME
	AGENT_STOP_RESULT=$?
	
	ECI_Make_Install_Log $LINENO "eciControlAgents stop result. [$AGENT_STOP_RESULT]"
	
	if [ $AGENT_STOP_RESULT = 0 ]; then
		#slp process stop
		if [ ! -e /etc/SuSE-release ]; then
			# Except for SLES.
			if [ -e $SLP_LIB_PATH ]; then
				pkill -f 'slpd'
			fi
		fi
		
		# you want to back up because it is removed from the version to install eciService.xml.org, when you update.
		if [ -e $ECISERVICE_XML_ORG ]; then
			mv -f $ECISERVICE_XML_ORG $ECISERVICE_XML_ORG_BAK
		fi
		
		if [ $INTERACTIVE_INSTALL = 1 ]; then
			#INTERACTIVE_UPDATE_INSTALL_MODE
			rpm -Uvh --allfiles --nomd5 --noscripts $ECISERVICE_RPM
			ECI_Make_Install_Log $LINENO "INTERACTIVE_UPDATE_INSTALL_MODE. [rpm -Uvh $PWD/$ECISERVICE_RPM]"
		else
			#SILENT_UPDATE_INSTALL_MODE
			rpm -U --allfiles --nomd5 --noscripts $ECISERVICE_RPM
			ECI_Make_Install_Log $LINENO "SILENT_UPDATE_INSTALL_MODE. [rpm -U $PWD/$ECISERVICE_RPM]"
		fi
		
		# Restore a file that you backed up.
		if [ -e $ECISERVICE_XML_ORG_BAK ]; then
			mv -f $ECISERVICE_XML_ORG_BAK $ECISERVICE_XML_ORG
		fi
		
		if [ -e $SYSTEMCTL_FILE ]; then
			# systemd
		    if [ -d $AXIS2C_HOME/scripts ]; then
				mkdir -p $AXIS2C_HOME/scripts
			fi
			mv -f $AXIS2C_HOME/eciServiceProgram $AXIS2C_HOME/scripts

			# delete symbolic link file
			if [ -e /etc/SuSE-release ]; then
				# SLES
				insserv -r $SUSE_ECI_AUTO_START_STOP_SHELL_PATH >/dev/null 2>&1
		
				rm -rf $SUSE_ECI_AUTO_START_STOP_SHELL_PATH
			else
				# RHEL
				rm -rf $ECI_SYMBOLIC_LINK_PATH_0
				rm -rf $ECI_SYMBOLIC_LINK_PATH_1
				rm -rf $ECI_SYMBOLIC_LINK_PATH_2
				rm -rf $ECI_SYMBOLIC_LINK_PATH_3
				rm -rf $ECI_SYMBOLIC_LINK_PATH_4
				rm -rf $ECI_SYMBOLIC_LINK_PATH_5
				rm -rf $ECI_SYMBOLIC_LINK_PATH_6
				rm -rf $ECI_AUTO_START_STOP_SHELL_PATH
			fi
			
			mv -f $AXIS2C_HOME/eciServiceProgram.service /etc/systemd/system
			systemctl daemon-reload > /dev/null 2>&1
			systemctl enable eciServiceProgram.service > /dev/null 2>&1
		else
			if [ -e /etc/SuSE-release ]; then
				# SLES
				mv -f $AXIS2C_HOME/eciServiceProgram /etc/init.d
			else
				# RHEL
				mv -f $AXIS2C_HOME/eciServiceProgram /etc/rc.d/init.d
			fi
		fi

		tar xvzf $AXIS2C_HOME/lib.tgz -C $AXIS2C_HOME > /dev/null
		
		#OpenSLP library thawing
		if [ -e $SLP_LIB_PATH ]; then
			tar xzvf $AXIS2C_HOME/OpenSLP_lib_2.0.tgz -C $AXIS2C_HOME/lib > /dev/null
		else
			tar xzvf $AXIS2C_HOME/OpenSLP_lib_1.2.tgz -C $AXIS2C_HOME/lib > /dev/null
		fi
		
		#Agent process start
		$AGENT_START_STOP_PROCESS_PATH -start $AXIS2C_HOME
		AGENT_START_RESULT=$?
		
		ECI_Make_Install_Log $LINENO "eciControlAgents start result. [$AGENT_START_RESULT]"
		
		if [ $AGENT_START_RESULT = 0 ]; then
			#Make version file
			echo $INTERNAL_ECI_VERSION > $VERSION_FILE_PATH
			
			if [ -f /usr/sbin/getenforce ]; then
				SELINUX_CHECK=`getenforce`
		
				if [ $SELINUX_CHECK != "Disabled" ]; then
					if [ -f /usr/sbin/semanage ]; then
						semanage fcontext -a -t textrel_shlib_t /opt/nec/axis2c/services/eciService/libeciService.so
						semanage fcontext -a -t textrel_shlib_t /opt/nec/axis2c/services/eciServicePlain/libeciServicePlain.so
						semanage fcontext -a -t textrel_shlib_t /opt/nec/axis2c/lib/libpwcb.so.0.0.0

						ECI_Make_Install_Log $LINENO "semanage command start."
					fi
				fi
			fi
			
			chcon -t textrel_shlib_t /opt/nec/axis2c/services/eciService/libeciService.so  2>>$INSTALL_LOG
			chcon -t textrel_shlib_t /opt/nec/axis2c/services/eciServicePlain/libeciServicePlain.so  2>>$INSTALL_LOG
			chcon -t textrel_shlib_t /opt/nec/axis2c/lib/libpwcb.so.0.0.0  2>>$INSTALL_LOG
	
			ECI_Make_Install_Log $LINENO "SELinux $SELINUX_CHECK."
			
			if [ $INTERACTIVE_INSTALL = 1 ]; then
				$ECI_START_SHELL_PATH
			fi
			
			rm -rf $AXIS2C_HOME/lib.tgz
			rm -rf $AXIS2C_HOME/OpenSLP*
			
			# PKG Mode
			CHECK_EUAEXECMD=`ps ax | grep EUAexecmd | grep -v grep`
			
			if [ $SILENT_MODE = 2 -o -n "$CHECK_EUAEXECMD" ]; then
				INST_EUA_VERSION=`cat $EUA_VERSION_FILE_PATH`

				ECI_Make_Install_Log $LINENO "INST_EUA_VERSION=$INST_EUA_VERSION"

				if [ $NEW_OPTION_EUA_VERSION -le $INST_EUA_VERSION ]; then
					#Stop EUA Service
					$EUA_STOP_SHELL_PATH
					#Start EUA Service
					$EUA_START_SHELL_PATH $PKG_START
					
					ECI_Make_Install_Log $LINENO "EUA pkg start."
				fi
			fi
			
			#Make install version file
			echo "ECIService Ver $ECI_VERSION" > $AXIS2C_HOME/bin/eciVersion.txt
		else
			#eci process start
			$ECI_START_SHELL_PATH
			
			if [ $SILENT_MODE != 2 ]; then
			#err_agent_start_message
				case $LANG in
					ja_JP.eucJP)
						echo `cat $Message_Dir/euc/err_agent_start`
						;;
					ja_JP.UTF-8)
						echo `cat $Message_Dir/utf8/err_agent_start`
						;;
					*)
						echo "Agent service could not be started."
						;;
				esac
			fi
			ECI_Make_Install_Log $LINENO "Agent service could not be started."
			exit 2
		fi
	else
		#eci process start
		$ECI_START_SHELL_PATH
		
		if [ $SILENT_MODE != 2 ]; then
			#err_agent_stop_message
			case $LANG in
				ja_JP.eucJP)
					echo `cat $Message_Dir/euc/err_agent_stop`
					;;
				ja_JP.UTF-8)
					echo `cat $Message_Dir/utf8/err_agent_stop`
					;;
				*)
					echo "Agent service could not be stopped."
					;;
			esac
		fi
		ECI_Make_Install_Log $LINENO "Agent service could not be stopped."
		exit 2
	fi
	
	ECI_Make_Install_Log $LINENO "ECI_Update_Install() end"
}

#function ECI_UnInstall
ECI_UnInstall() {
	ECI_Make_Install_Log $LINENO "ECI_UnInstall() start"
	
	#slp process stop
	if [ ! -e /etc/SuSE-release ]; then
		# Except for SLES.
		if [ -e $SLP_LIB_PATH ]; then
			pkill -f 'slpd'
		fi
	fi
	
	#UnInstall eci
	rpm -e --noscripts $ECISERVICE_PKG
	
	#Delete symbolic link file
	if [ -e /etc/SuSE-release ]; then
		# SLES
		insserv -r $SUSE_ECI_AUTO_START_STOP_SHELL_PATH >/dev/null 2>&1
		
		rm -rf $SUSE_ECI_AUTO_START_STOP_SHELL_PATH
	else
		# RHEL
		rm -rf $ECI_SYMBOLIC_LINK_PATH_0
		rm -rf $ECI_SYMBOLIC_LINK_PATH_1
		rm -rf $ECI_SYMBOLIC_LINK_PATH_2
		rm -rf $ECI_SYMBOLIC_LINK_PATH_3
		rm -rf $ECI_SYMBOLIC_LINK_PATH_4
		rm -rf $ECI_SYMBOLIC_LINK_PATH_5
		rm -rf $ECI_SYMBOLIC_LINK_PATH_6
		
		rm -rf $ECI_AUTO_START_STOP_SHELL_PATH
	fi

	if [ -e $SYSTEMCTL_FILE ]; then
		# systemd
		systemctl disable eciServiceProgram.service > /dev/null 2>&1
		rm -f /etc/systemd/system/eciServiceProgram.service
		systemctl daemon-reload > /dev/null 2>&1
	fi

	rm -rf /dev/shm/sem.ECI_CLI_SYNCREQ_MUTEX
	rm -rf /dev/shm/sem.ExpressUpdate_Com_Log_Sem
	rm -rf /dev/shm/sem.BIOS_LOGFILE_MUTEX
	
	if [ ! -e /tmp/EUA_Shell_Lock ]; then
		rm -rf $AXIS2C_HOME
	fi
	
	rm -rf /etc/ecia
}

mkdir -p $AXIS2C_HOME/bin

ECI_Make_Install_Log $LINENO "eciService Install Start."

#Set rpm
ECISERVICE_RPM=eciservice-$ECI_VERSION-x.i386.rpm


ECI_Make_Install_Log $LINENO "The confirmation completion of the Install RPMPKG. [$ECISERVICE_RPM]"
ECI_Make_Install_Log $LINENO "Target machine LANG=$LANG"

#Delete message directory
if [ -d $Message_Dir ]; then
    rm -rf $Message_Dir
    ECI_Make_Install_Log $LINENO "Deleted a message directory."
fi

#Thawing message.tgz
if [ -e $PWD/message.tgz ]; then
	if [ ! -e $Message_Tmp ]; then
		mkdir -p $Message_Tmp
	fi

    tar xvzf message.tgz -C $Message_Tmp > /dev/null
    ECI_Make_Install_Log $LINENO "Success of the thawing of the message.tgz."
else
	#Failure Thawing message.tgz
    LANG=
    ECI_Make_Install_Log $LINENO "Failure of the thawing of the message.tgz."
fi

#Argument check
if [ -z $1 ]; then
	#No argument
	INTERACTIVE_INSTALL=1
	ECI_Make_Install_Log $LINENO "INTERACTIVE_INSTALL [No argument]"
else
	#Silent install flag
	SILENT_MODE=1
	
	case $1 in
		-si)
			SILENT_INSTALL=1
			ECI_Make_Install_Log $LINENO "SILENT_INSTALL_MODE_Argument. [$1]"
			;;
		-su)
			SILENT_UNINSTALL=1
			ECI_Make_Install_Log $LINENO "SILENT_UNINSTALL_MODE_Argument. [$1]"
			;;
		-pi)
			#Silent install flag(AGENT_SILENT_MODE)
			SILENT_MODE=2
			SILENT_INSTALL=1
			ECI_Make_Install_Log $LINENO "SILENT_INSTALL_MODE_Argument(AGENT_SILENT_MODE). [$1]"
			;;
		-pu)
			#Silent install flag(AGENT_SILENT_MODE)
			SILENT_MODE=2
			SILENT_UNINSTALL=1
			ECI_Make_Install_Log $LINENO "SILENT_UNINSTALL_MODE_Argument(AGENT_SILENT_MODE). [$1]"
			;;
		*)
			case $LANG in
				ja_JP.eucJP)
					echo `cat $Message_Dir/euc/err_argument`
					;;
				ja_JP.UTF-8)
					echo `cat $Message_Dir/utf8/err_argument`
					;;
				*)
					echo "Wrong argument error."
					;;
			esac
		
			ECI_Make_Install_Log $LINENO "Wrong argument error. [$1]"
			exit 2
			;;
	esac
fi

#Check whether ECI is installed
ECISERVICE_PKG=`rpm -qa | grep eciservice`

#ECI is not installed
if [ -z $ECISERVICE_PKG ]; then
	#No argument
	if [ $INTERACTIVE_INSTALL = 1 ]; then
		#Interactive install flag
		INTERACTIVE_NEW_INSTALL=1
		ECI_Make_Install_Log $LINENO "INTERACTIVE_NEW_INSTALL_MODE."
	elif [ $SILENT_MODE != 0 ]; then
		#When -su was appointed in an argument
		if [ $SILENT_UNINSTALL = 1 ]; then
			ECI_Make_Install_Log $LINENO "Wrong argument error."
			exit 2
		fi
		
		#Silent install flag
		SILENT_NEW_INSTALL=1
		ECI_Make_Install_Log $LINENO "SILENT_NEW_INSTALL_MODE."
	fi
	
	#axis2_http_server the process exists is checked
	AXIS2_PROCESS=`pgrep axis2`
	
	#slpd the process exists is checked
	if [ -e /etc/SuSE-release ]; then
		if [ -e /usr/sbin/slpd ]; then
			OPENSLP_PROCESS=
			if [ -e $SYSTEMCTL_FILE ]; then
				# SLP Ver2
				SLP_INSTALL=2
			else
				# SLP ver1
				SLP_INSTALL=1
			fi
		else
			OPENSLP_PROCESS=
		fi
	elif [ -e /etc/vmware-release ]; then #ESX4.1
		if [ -e /sbin/slpd ]; then
			OPENSLP_PROCESS=
			SLP_INSTALL=1
		else
			OPENSLP_PROCESS=`pgrep slpd`
		fi
	else
		OPENSLP_PROCESS=`pgrep slpd`
	fi
	
	#Not slp process exists
	if [ -z $OPENSLP_PROCESS ]; then
		#Not axis2_http_server process exists
		if [ -z $AXIS2_PROCESS ]; then
			:
		else
			if [ $SILENT_MODE != 2 ]; then
				#err_axis2_message
				case $LANG in
					ja_JP.eucJP)
						echo `cat $Message_Dir/euc/err_axis2`
						;;
					ja_JP.UTF-8)
						echo `cat $Message_Dir/utf8/err_axis2`
						;;
					*)
						echo "Axis2C already exists, preventing the installation of this product."
						;;
				esac
			else
				if [ -d /etc/ecia ]; then
					echo "ECILInst01" > $PKG_RESULT_FILE
				else
					mkdir /etc/ecia
					echo "ECILInst01" > $PKG_RESULT_FILE
				fi
			fi
			ECI_Make_Install_Log $LINENO "Axis2C already exists, preventing the installation of this product."
			exit 2
		fi
	else
		if [ $SILENT_MODE != 2 ]; then
			#err_slp_message
			case $LANG in
				ja_JP.eucJP)
					echo `cat $Message_Dir/euc/err_slp`
					;;
				ja_JP.UTF-8)
					echo `cat $Message_Dir/utf8/err_slp`
					;;
				*)
					echo "OpenSLP already exists, preventing the installation of this product."
					;;
			esac
		else
			if [ -d /etc/ecia ]; then
				echo "ECILInst02" > $PKG_RESULT_FILE
			else
				mkdir /etc/ecia
				echo "ECILInst02" > $PKG_RESULT_FILE
			fi
		fi
		ECI_Make_Install_Log $LINENO "OpenSLP already exists, preventing the installation of this product."
		exit 2
	fi
#ECI is installed
else
	#version file check
	if [ -f $VERSION_FILE_PATH ]; then
		OLD_ECI_VERSION=`cat $VERSION_FILE_PATH`
		
		ECI_Make_Install_Log $LINENO "Installed version [$OLD_ECI_VERSION]"
		
		#INTERACTIVE INSTALL
		if [ $INTERACTIVE_INSTALL = 1 ]; then
			#Update check
			if [ $INTERNAL_ECI_VERSION -gt $OLD_ECI_VERSION ]; then
				INTERACTIVE_UPDATE_INSTALL=1
				ECI_Make_Install_Log $LINENO "INTERACTIVE_UPDATE_INSTALL."
			else
				#Same or down version
				INTERACTIVE_REINSTALL=1
				ECI_Make_Install_Log $LINENO "INTERACTIVE_REINSTALL."
			fi
		fi
		
		#Silent mode
		if [ $SILENT_INSTALL = 1 ]; then
			#Update check
			if [ $INTERNAL_ECI_VERSION -gt $OLD_ECI_VERSION ]; then
				SILENT_UPDATE_INSTALL=1
				ECI_Make_Install_Log $LINENO "SILENT_UPDATE_INSTALL."
			else
				#Same or down version
				ECI_Make_Install_Log $LINENO "SILENT_REINSTALL."
				exit 0
			fi
		fi
	else
		if [ $SILENT_UNINSTALL = 0 ]; then
			if [ $SILENT_MODE != 2 ]; then
				#err_version_check_message
				case $LANG in
					ja_JP.eucJP)
						echo `cat $Message_Dir/euc/err_version_check`
						;;
					ja_JP.UTF-8)
						echo `cat $Message_Dir/utf8/err_version_check`
						;;
					*)
						echo "Update installation operation failed."
						;;
				esac
			fi
			ECI_Make_Install_Log $LINENO "Update installation operation failed.(There is no version file or it has broken)"
			exit 2
		else
			#EUA is uninstall mode.
			ECI_Make_Install_Log $LINENO "ECI is uninstall mode.[There is no version file or it has broken]"
			:
		fi
	fi
fi

#Interactive new install
if [ $INTERACTIVE_NEW_INSTALL = 1 ]; then
	LOOP_END=0
	while [ $LOOP_END = 0 ];do
		#install_eci_message
		case $LANG in
			ja_JP.eucJP)
				echo -n `cat $Message_Dir/euc/install_eci`
				;;
			ja_JP.UTF-8)
				echo -n `cat $Message_Dir/utf8/install_eci`
				;;
			*)
				echo -n "Do you want to install eciService?  [yes or no]. >"
				;;
		esac
		
		read reply leftover
		
		case $reply in
			y* | Y*)
				LOOP_END=1
				;;
			n* | N*)
				#install_finish_message
				case $LANG in
					ja_JP.eucJP)
						echo `cat $Message_Dir/euc/install_finish`
						;;
					ja_JP.UTF-8)
						echo `cat $Message_Dir/utf8/install_finish`
						;;
					*)
						echo "The install of eciService is now finished."
						;;
				esac
				
				ECI_Make_Install_Log $LINENO "The install of eciService is now finished."
				
				LOOP_END=1
				exit 0
				;;
		esac
	done
	
	#install_start_eci_message
	case $LANG in
		ja_JP.eucJP)
			echo `cat $Message_Dir/euc/install_start_eci`
			;;
		ja_JP.UTF-8)
			echo `cat $Message_Dir/utf8/install_start_eci`
			;;
		*)
			echo "The install of eciService is started."
			;;
	esac
	
	#call function ECI_New_Install
	ECI_New_Install
	
	#ECI process start
	$ECI_START_SHELL_PATH
	
	#install_end_eci_message
	case $LANG in
		ja_JP.eucJP)
			echo `cat $Message_Dir/euc/install_end_eci`
			;;
		ja_JP.UTF-8)
			echo `cat $Message_Dir/utf8/install_end_eci`
			;;
		*)
			echo "Installation of eciService is now completed."
			;;
	esac
fi

#Interactive update install
if [ $INTERACTIVE_UPDATE_INSTALL = 1 ]; then
	#AgentFolder the directory exists is checked
	AGENT_CHECK=`ls $AXIS2C_HOME/bin/AgentFolder`
	
	#No directory exists
	if [ -z "$AGENT_CHECK" ]; then
		#agent notting
		LOOP_END=0
		while [ $LOOP_END = 0 ];do
			#update_uninstall_eci_message
			case $LANG in
				ja_JP.eucJP)
					echo -n `cat $Message_Dir/euc/update_uninstall_eci`
					;;
				ja_JP.UTF-8)
					echo -n `cat $Message_Dir/utf8/update_uninstall_eci`
					;;
				*)
					echo -n "When you install, input [add], and when you uninstall , input [delete], when you skip the setup, input [skip]. >"
					;;
			esac
		
			read reply leftover
						
			case $reply in
				add | ADD)
					ECI_Make_Install_Log $LINENO "read reply [$reply]"
					
					#update_start_eci_message
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/update_start_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/update_start_eci`
							;;
						*)
							echo "The update install of eciService is started."
							;;
					esac
					
					#eci process stop
					$ECI_STOP_SHELL_PATH
					
					#call function ECI_Update_Install
					ECI_Update_Install
					
					LOOP_END=1
					
					#update_end_eci_message
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/update_end_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/update_end_eci`
							;;
						*)
							echo "The update install of eciService is now completed."
							;;
					esac
					;;
				delete | DELETE)
					ECI_Make_Install_Log $LINENO "read reply [$reply]"
					
					#uninstall_start_eci_message
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/uninstall_start_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/uninstall_start_eci`
							;;
						*)
							echo "The uninstall of eciService is started."
							;;
					esac
				
					#eci process stop
					$ECI_STOP_SHELL_PATH
					
					#call function ECI_UnInstall
					ECI_UnInstall
					
					LOOP_END=1
					
					#uninstall_end_eci_message
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/uninstall_end_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/uninstall_end_eci`
							;;
						*)
							echo "Uninstallation of eciService is now completed."
							;;
					esac
					;;
				skip | SKIP)
					ECI_Make_Install_Log $LINENO "read reply [$reply]"
					LOOP_END=1
					;;
			esac
		done
	#Directory exists
	else
		#agent Existence
		LOOP_END=0
		while [ $LOOP_END = 0 ];do
			#update_eci_message
			case $LANG in
				ja_JP.eucJP)
					echo -n `cat $Message_Dir/euc/update_eci`
					;;
				ja_JP.UTF-8)
					echo -n `cat $Message_Dir/utf8/update_eci`
					;;
				*)
					echo -n "When you install, input [add], and when you skip the setup, input [skip]. >"
					;;
			esac
			
			read reply leftover
		
			case $reply in
				add | ADD)
					ECI_Make_Install_Log $LINENO "read reply [$reply]"
					
					#update_start_eci_message
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/update_start_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/update_start_eci`
							;;
						*)
							echo "The update install of eciService is started."
							;;
					esac
					
					#eci process stop
					$ECI_STOP_SHELL_PATH
					
					#call function ECI_Update_Install
					ECI_Update_Install
					
					LOOP_END=1
					
					#update_end_eci_message
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/update_end_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/update_end_eci`
							;;
						*)
							echo "The update install of eciService is now completed."
							;;
					esac
					;;
				skip | SKIP)
					ECI_Make_Install_Log $LINENO "read reply [$reply]"
					LOOP_END=1
					;;
			esac
		done
	fi
fi

#INTERACTIVE_REINSTALL
if [ $INTERACTIVE_REINSTALL = 1 ]; then
	#AgentFolder the directory exists is checked
	AGENT_CHECK=`ls $AXIS2C_HOME/bin/AgentFolder`
	
	#No directory exists
	if [ -z "$AGENT_CHECK" ]; then
		LOOP_END=0
		while [ $LOOP_END = 0 ];do
			#uninstall_start_eci_message
			case $LANG in
				ja_JP.eucJP)
					echo -n `cat $Message_Dir/euc/uninstall_eci`
					;;
				ja_JP.UTF-8)
					echo -n `cat $Message_Dir/utf8/uninstall_eci`
					;;
				*)
					echo -n "When you uninstall , input [delete], and when you skip the setup, input [skip]. >"
					;;
			esac
			
			read reply leftover
			
			case $reply in
				delete | DELETE)
					ECI_Make_Install_Log $LINENO "read reply [$reply]"
					
					#uninstall_start_eci
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/uninstall_start_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/uninstall_start_eci`
							;;
						*)
							echo "The uninstall of eciService is started."
							;;
					esac
					
					#eci process stop
					$ECI_STOP_SHELL_PATH
					
					#call function ECI_UnInstall
					ECI_UnInstall
					
					LOOP_END=1
					
					#uninstall_end_eci_message
					case $LANG in
						ja_JP.eucJP)
							echo `cat $Message_Dir/euc/uninstall_end_eci`
							;;
						ja_JP.UTF-8)
							echo `cat $Message_Dir/utf8/uninstall_end_eci`
							;;
						*)
							echo "Uninstallation of eciService is now completed."
							;;
					esac
					;;
				skip | SKIP)
					ECI_Make_Install_Log $LINENO "read reply [$reply]"
					LOOP_END=1
					;;
			esac
		done
	else
		#err_uninstall_eci_message
		case $LANG in
			ja_JP.eucJP)
				echo `cat $Message_Dir/euc/err_uninstall_eci`
				;;
			ja_JP.UTF-8)
				echo `cat $Message_Dir/utf8/err_uninstall_eci`
				;;
			*)
				echo "Another service has exclusive access to the eciService."
				;;
		esac
		ECI_Make_Install_Log $LINENO "Another service has exclusive access to the eciService."
		exit 1
	fi
fi

#New silent install
if [ $SILENT_NEW_INSTALL = 1 ]; then
	#call function ECI_New_Install
	ECI_New_Install
fi

#SILENT_UPDATE_INSTALL
if [ $SILENT_UPDATE_INSTALL = 1 ]; then
	#call function ECI_Update_Install
	ECI_Update_Install
fi

#SILENT_UNINSTALL
if [ $SILENT_UNINSTALL = 1 ]; then
	#AgentFolder the directory exists is checked
	AGENT_CHECK=`ls $AXIS2C_HOME/bin/AgentFolder`
	
	#No directory exists
	if [ -z "$AGENT_CHECK" ]; then
		#call function ECI_UnInstall
		ECI_UnInstall
	else
		$ECI_START_SHELL_PATH
		ECI_Make_Install_Log $LINENO "Another service has exclusive access to the eciService."
		exit 1
	fi
fi

if [ -e $AXIS2C_HOME/bin/eciService.xml -a ! -e $AXIS2C_HOME/bin/eciService.xml.org ]; then
	cp -afpr $AXIS2C_HOME/bin/eciService.xml $AXIS2C_HOME/bin/eciService.xml.org >/dev/null 2>&1
fi

exit 0
