# mcemonitor-3.02.spec

Summary:	Tool to monitor x86-64 CPU Machine Check Exception.
Name:		mcl-mcemonitor2
Version:	2.4
Release:	3.02.el6
Vendor:		NEC Corporation
Packager:	NEC Corporation
License:	GPL
URL:		http://www.nec.co.jp/
Group:		System Environment/Base
Source:		mcemonitor-3.02.tgz
Prefix:		%{_prefix}
BuildRoot:	/var/tmp%{:name}-root

%description
 mcemonitor is a daemon that monitors Machine Check Exception.

%prep
%setup -n mcemonitor-3.02

%build
sh ./make_rpm.sh

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/opt/nec/mcemonitor/
mkdir -p $RPM_BUILD_ROOT/opt/nec/mcemonitor/tmp/
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d/
mkdir -p $RPM_BUILD_ROOT/etc/cron.d/
mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d/
mkdir -p $RPM_BUILD_ROOT/var/opt/nec/
mkdir -p $RPM_BUILD_ROOT/etc/modprobe.d/
install -m 500 -o 0 -g 0 mcemonitor       $RPM_BUILD_ROOT/opt/nec/mcemonitor/mcemonitor
install -m 644 -o 0 -g 0 mcemonitor.cron  $RPM_BUILD_ROOT/etc/cron.d/mcemonitor
install -m 644 -o 0 -g 0 mcemonitor.logrotate  $RPM_BUILD_ROOT/etc/logrotate.d/mcemonitor
install -m 500 -o 0 -g 0 mcemonitord      $RPM_BUILD_ROOT/etc/rc.d/init.d/mcemonitord
install -m 644 -o 0 -g 0 disable_edac.conf     $RPM_BUILD_ROOT/etc/modprobe.d/disable_edac.conf

%clean
rm -rf $RPM_BUILD_ROOT

%pre
KERNEL=`uname -r`
MODEL=`cat /sys/class/dmi/id/product_name`

case $KERNEL in
	*".el6."*)
		;;
	*)
		echo "INFORMATION: skip to install mcemonitor for" $KERNEL
		exit 1
		;;
esac

case $MODEL in
	"Express5800/A2010c"*)
		;;
	"Express5800/A2020c"*)
		;;
	"Express5800/A2040c"*)
		;;
	"Express5800/A1040c"*)
		;;
	"NX7700x/A3012M-4"*)
		;;
	"NX7700x/A3012L-2"*)
		;;
	"NX7700x/A3012L-1"*)
		;;
	"NX7700x/A3010M-4"*)
		;;
	*)
		echo "INFORMATION: skip to install mcemonitor for" $MODEL
		exit 1
		;;
esac

if [ "$1" = "2" ]; then

	if ps aux | awk '{print $2,$11}' | grep mcemonitor
	then
		if [ -x /etc/rc.d/init.d/mcemonitord ] ; then
			/etc/rc.d/init.d/mcemonitord stop
		else
			if [ -e "/var/run/mcemonitor.pid" ] ; then
				pid=`cat /var/run/mcemonitor.pid`
				if [ -d "/proc/$pid" ] ; then
					kill -TERM $pid
					usleep 100000
					try=0
					while [ $try -lt 30 ] ; do
						if [ ! -d "/proc/$pid" ] ; then
							break
						fi
						sleep 1
						let try+=1
					done
					if [ -d "/proc/$pid" ] ; then
						kill -KILL $pid >/dev/null 2>&1
						usleep 100000
					fi
				fi
			fi

			rm -f /var/lock/subsys/mcemonitord
		fi
	fi

	if [ -x /sbin/chkconfig ]; then
		if [ -x /etc/rc.d/init.d/mcemonitord ] ; then
			/sbin/chkconfig --del mcemonitord
		else
			rm -f /etc/rc.d/rc?.d/???mcemonitord
		fi
	else
		rm -f /etc/rc.d/rc?.d/???mcemonitord
	fi

fi


%post

/sbin/modprobe -r sb_edac

if [ -e /etc/cron.hourly/mcelog.cron ] ; then
	cp -f /etc/cron.hourly/mcelog.cron /opt/nec/mcemonitor/tmp/mcelog.cron
fi

if [ -x /sbin/chkconfig ]; then
	/sbin/chkconfig --add mcemonitord
	if [ -x /etc/rc.d/init.d/mcelogd ] ; then
		/sbin/chkconfig --del mcelogd
	else
		rm -f /etc/rc.d/rc?.d/???mcelogd
	fi
else
	for i in 3 5; do
		/bin/ln -sf /etc/rc.d/init.d/mcemonitord /etc/rc.d/rc${i}.d/S42mcemonitord
	done
	for i in 0 1 2 4 6; do
		/bin/ln -sf /etc/rc.d/init.d/mcemonitord /etc/rc.d/rc${i}.d/K60mcemonitord
	done
	rm -f /etc/rc.d/rc?.d/???mcelogd
fi

if ps aux | awk '{print $2,$11}' | grep mcelog
then
	if [ -x /etc/rc.d/init.d/mcelogd ] ; then
		/etc/rc.d/init.d/mcelogd stop
	else
		if [ -e "/var/run/mcelog.pid" ] ; then
			pid=`cat /var/run/mcelog.pid`
			if [ -d "/proc/$pid" ] ; then
				kill -TERM $pid
				usleep 100000
				try=0
				while [ $try -lt 30 ] ; do
					if [ ! -d "/proc/$pid" ] ; then
						break
					fi
					sleep 1
					let try+=1
				done
				if [ -d "/proc/$pid" ] ; then
					kill -KILL $pid >/dev/null 2>&1
					usleep 100000
				fi
			fi
		fi

		rm -f /var/lock/subsys/mcelogd
	fi
fi


if [ -x /etc/rc.d/init.d/mcemonitord ] ; then
	/etc/rc.d/init.d/mcemonitord start
else
	echo /etc/rc.d/init.d/mcemonitord was not found.
	exit 1
fi

%preun
# only on uninstall, not on upgrades.
if [ "$1" = "0" ]; then

	if ps aux | awk '{print $2,$11}' | grep mcemonitor
	then
		if [ -x /etc/rc.d/init.d/mcemonitord ] ; then
			/etc/rc.d/init.d/mcemonitord stop
		else
			if [ -e "/var/run/mcemonitor.pid" ] ; then
				pid=`cat /var/run/mcemonitor.pid`
				if [ -d "/proc/$pid" ] ; then
					kill -TERM $pid
					usleep 100000
					try=0
					while [ $try -lt 30 ] ; do
						if [ ! -d "/proc/$pid" ] ; then
							break
						fi
						sleep 1
						let try+=1
					done
					if [ -d "/proc/$pid" ] ; then
						kill -KILL $pid >/dev/null 2>&1
						usleep 100000
					fi
				fi
			fi	
			rm -f /var/lock/subsys/mcemonitord
		fi
	fi

	if [ -x /sbin/chkconfig ]; then
		if [ -x /etc/rc.d/init.d/mcelogd ] ; then
			/sbin/chkconfig --add mcelogd
		fi
		if [ -x /etc/rc.d/init.d/mcemonitord ] ; then
			/sbin/chkconfig --del mcemonitord
		else
			rm -f /etc/rc.d/rc?.d/???mcemonitord
		fi
	else
		if [ -x /etc/rc.d/init.d/mcelogd ] ; then
			for i in 3 5; do
				/bin/ln -sf /etc/rc.d/init.d/mcelogd /etc/rc.d/rc${i}.d/S50mcelogd
			done
			for i in 0 1 2 4 6; do
				/bin/ln -sf /etc/rc.d/init.d/mcelogd /etc/rc.d/rc${i}.d/K50mcelogd
			done
		fi
		rm -f /etc/rc.d/rc?.d/???mcemonitord
	fi
	if [ -x /etc/rc.d/init.d/mcelogd ] ; then
		/etc/rc.d/init.d/mcelogd start
	else
	    echo /etc/rc.d/init.d/mcelogd was not found.
	fi
	
fi

%postun
# only on uninstall, not on upgrades.
if [ "$1" = "0" ]; then
	if [ -e /opt/nec/mcemonitor/tmp/mcelog.cron ] ; then
		cp -f /opt/nec/mcemonitor/tmp/mcelog.cron /etc/cron.hourly/mcelog.cron
	fi

	/sbin/modprobe -b sb_edac
fi

%files
%defattr(-,root,root)
%dir /opt/nec/
%dir /opt/nec/mcemonitor/
%dir /opt/nec/mcemonitor/tmp/
%dir /var/opt/nec/
/opt/nec/mcemonitor/mcemonitor
/etc/rc.d/init.d/mcemonitord
%config(noreplace) /etc/modprobe.d/disable_edac.conf
%config(noreplace) /etc/cron.d/mcemonitor
%config(noreplace) /etc/logrotate.d/mcemonitor

%changelog
* Mon Mar 8 2013 NEC Corporation
created for mcemonitor Ver.1
