@echo off
pushd %~dp0
setlocal enabledelayedexpansion

rem My architecture set. AMD64 or x86
set MYARCH=AMD64
rem Set product. X or XSSS
set PRODUCT=XSSS

set PARAM1=%~1
set PARAM2=%~2
set PARAM3=%~3
set PARAM4=%~4
set PARAM5=%~5
set PARAM6=%~6

rem Parameter check
if /i "%PARAM1%"=="-i" (
	set ISSPATH=!PARAM2!
	if "!ISSPATH!"=="" goto USAGE
	if not exist "!ISSPATH!" (
		echo  ISS-file path is not exist.
		echo.
		goto EXIT
	)
	if /i "%PARAM3%"=="-l" (
		set LOGPATH=!PARAM4!
		if "!LOGPATH!"=="" goto USAGE
		set LOGPATH=%~dp4
		if not exist !LOGPATH!NUL (
			echo  Setup-log path is not exist.
			echo.
			goto EXIT
		)
		set LOGPATH=!PARAM4!
		set PARAMPATH=!PARAM5!
		set CHECK=!PARAM6!
	) else (
		set LOGPATH=%TEMP%\install.log
		set PARAMPATH=!PARAM3!
		set CHECK=!PARAM4!
	)
) else (
	if /i "%PARAM1%"=="-l" (
		set LOGPATH=!PARAM2!
		if "!LOGPATH!"=="" goto USAGE
		set LOGPATH=%~dp2
		if not exist !LOGPATH!NUL (
			echo  Setup-log path is not exist.
			echo.
			goto EXIT
		)
		set LOGPATH=!PARAM2!
		set PARAMPATH=!PARAM3!
		set CHECK=!PARAM4!
	) else (
		set LOGPATH=%TEMP%\install.log
		set PARAMPATH=!PARAM1!
		set CHECK=!PARAM2!
	)
)
if not "%PARAMPATH%"=="" (
	if not exist "%PARAMPATH%" (
		goto USAGE
	)
)
if not "%CHECK%"=="" goto USAGE

rem iss-file select
set CURPATH=%~dp0
if "%ISSPATH%"=="" (
	for /f "tokens=2 delims=:" %%p in ('chcp') do (
		set CODEPAGE=%%p
	)
	if /i "%PRODUCT%"=="X" (
		if "!CODEPAGE!"==" 932" (
			rem Japanese
			set ISSPATH=!CURPATH!response\setup_updt_jp.iss
		) else if "!CODEPAGE!"==" 936" (
			rem Chinese
			set ISSPATH=!CURPATH!response\setup_updt_cn.iss
		) else (
			rem English
			set ISSPATH=!CURPATH!response\setup_updt_en.iss
		)
	) else if /i "%PRODUCT%"=="XSSS" (
		if "!CODEPAGE!"==" 932" (
			rem Japanese
			set ISSPATH=!CURPATH!response\setup_sss_updt_jp.iss
		) else if "!CODEPAGE!"==" 936" (
			rem Chinese
			set ISSPATH=!CURPATH!response\setup_sss_updt_cn.iss
		) else (
			rem English
			set ISSPATH=!CURPATH!response\setup_sss_updt_en.iss
		)
	) else (
		echo  Product error.
		echo  Silent update was failed.
		goto ERROR
	)
	if not exist "!ISSPATH!" (
		echo  ISS-file path is not exist.
		echo.
		goto EXIT
	)
)

rem Add double quotation
set ISSPATH="%ISSPATH%"
set LOGPATH="%LOGPATH%"
set PARAMPATH="%PARAMPATH%"

if /i "%PROCESSOR_ARCHITECTURE%"=="%MYARCH%" (
	if %PARAMPATH%=="" (
		start "title" /wait "%CURPATH%setup.exe" /s /f1!ISSPATH! /f2!LOGPATH!
	) else (
		start "title" /wait "%CURPATH%setup.exe" /s /z!PARAMPATH! /f1!ISSPATH! /f2!LOGPATH!
	)
	rem check return code
	for /f "tokens=2 delims==" %%2 in ('findstr "ResultCode=" !LOGPATH!') do (
		set /A RESULT=%%2
	)
	if !RESULT!==0 (
		echo  Silent update was succeeded.
	) else (
		echo  Silent update was failed. code=!RESULT!
	)
	rem setup-log move
	for /f "tokens=2 delims==" %%2 in ('findstr "szDir=" !ISSPATH!') do (
		set INSTALLPATH=%%2
		set INSTALLPATH="!INSTALLPATH!\log"
	)
	rem copy & del
	copy /y !LOGPATH! !INSTALLPATH! >NUL 2>&1
	del !LOGPATH! >NUL 2>&1
) else (
	goto ERROREXIT
)


:NORMALEXIT
exit /b !RESULT!

:ERROREXIT
echo  Architecture is not correct.
echo  Silent update was failed.
exit /b 1

:USAGE
echo  Invalid parameter.
echo. 
echo  usage:
echo  silent-update.bat [-i "ISS-file path"] [-l "setup-log path"]
exit /b 1

:EXIT
exit /b 1
