#!/bin/bash

HOSTNAME_FULL=`uname -n`		# get hostname
HOSTNAME=`echo ${HOSTNAME_FULL%%.*}`	# delete domain name
MONNAME=${CLP_MONITORNAME}

RSCNAME=`clpcfget -g /root/monitor/fipw@${MONNAME}/target`
if [ $? -ne 0 ]; then
	echo "failed to load configuration."
	exit 1
fi

IP=`clpcfget -g /root/resource/fip@${RSCNAME}/parameters/ip -s ${HOSTNAME}`
if [ $? -ne 0 ]; then
	echo "failed to load configuration."
	exit 1
fi

ECAP_COMMANDS=(
"ip n"
"ping -w 3 ${IP}"
)

NAME=""
if [ -z ${CLP_RESOURCENAME} ]; then
	if [ -z ${CLP_MONITORNAME} ]; then
		if [ -z ${CLP_FORCESTOPENV} ]; then
			NAME="unknown"
		else
			NAME=${CLP_FORCESTOPENV}
		fi
	else
		NAME=${CLP_MONITORNAME}
	fi
else
	NAME=${CLP_RESOURCENAME}
fi

echo "# Log for investigation of [${NAME}]"

IFS=$'\n'
for command in ${ECAP_COMMANDS[@]}
do
	echo ""
	echo "## Result of executing the [${command}] command"
	echo ""
	echo "\`\`\`"
	IFS=$' \t\n'
	$command
	echo "\`\`\`"
done

