#!/bin/bash

MONNAME=${CLP_MONITORNAME}

RSCNAME=`clpcfget -g /root/monitor/ddnsw@${MONNAME}/target`
if [ $? -ne 0 ]; then
	echo "failed to load configuration."
	exit 1
fi

DDNSNAME=`clpcfget -g /root/resource/ddns@${RSCNAME}/parameters/host/ddnsname`
if [ $? -ne 0 ]; then
	echo "failed to load configuration."
	exit 1
fi

ECAP_COMMANDS=(
"nslookup -timeout=3 ${DDNSNAME}"
"dig any +time=3 ${DDNSNAME}"
)

NAME=""
if [ -z ${CLP_RESOURCENAME} ]; then
	if [ -z ${CLP_MONITORNAME} ]; then
		if [ -z ${CLP_FORCESTOPENV} ]; then
			NAME="unknown"
		else
			NAME=${CLP_FORCESTOPENV}
		fi
	else
		NAME=${CLP_MONITORNAME}
	fi
else
	NAME=${CLP_RESOURCENAME}
fi

echo "# Log for investigation of [${NAME}]"

IFS=$'\n'
for command in ${ECAP_COMMANDS[@]}
do
	echo ""
	echo "## Result of executing the [${command}] command"
	echo ""
	echo "\`\`\`"
	IFS=$' \t\n'
	$command
	echo "\`\`\`"
done

