#!/bin/sh
#
# Startup script for the CLUSTERPRO webalert
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=0
LANG=C

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_
export LANG
# See how we were called.
case "$1" in
  start)
	targetos=`/bin/uname`
	clp_filedel "$1" init_alert $targetos
	clp_logwrite "$1" "clusterpro_alertsync start process start." init_alert
	
	#
	cd /opt/nec/clusterpro/bin

	#
	if [ "$targetos" = "SunOS" ]
	then
		echo "Starting clusterpro webalert: \c"
	else
		logging=`clpcfget -g /root/event/container/logging` 
		cfget_ret=$?
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Starting clusterpro webalert: " > /dev/null 2>&1
		else
			echo -n "Starting clusterpro webalert: "
		fi
	fi

	#
	clp_logwrite "$1" "clppidof start." init_alert
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webalert 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_alert

	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "alertsync already exist." init_alert
		clp_logwrite "$1" "clusterpro_alert start process end." init_alert
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success $targetos > /dev/null 2>&1
		else
			clp_success $targetos
		fi
		exit 0
	fi

	# starting clusterpro webalert
	clp_logwrite "$1" "alertsync start process start." init_alert
	./clpmonp --webalert -a 2 -r 0 -w 0 > /dev/null 2>&1
	monp_ret=$?
	clp_logwrite "$1" "alertsync start process end.("$monp_ret")" init_alert

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_checkerr "$monp_ret" $targetos > /dev/null 2>&1
	else
		clp_checkerr "$monp_ret" $targetos
	fi
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_alert start process end." init_alert
		exit 0
	fi

	clp_logwrite "$1" "clusterpro_alert start process end." init_alert
	;;
  stop)
	targetos=`/bin/uname`

	clp_filedel "$1" init_alert $targetos
	clp_logwrite "$1" "clusterpro_alertsync stop process start." init_alert

	#
	if [ "$targetos" = "SunOS" ]
	then
		echo "Shutting down clusterpro webalert: \c"
	else
		logging=`clpcfget -g /root/event/container/logging` 
		cfget_ret=$?
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Shutting down clusterpro webalert: " > /dev/null 2>&1
		else
			echo -n "Shutting down clusterpro webalert: "
		fi
	fi

	#
	cd /opt/nec/clusterpro/bin

	#
	clp_logwrite "$1" "clppidof start." init_alert
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webalert 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_alert
	
	if [ "$pids" != "" ]
	then
		# shutting down clusterpro webalert
		clp_logwrite "$1" "alertsync stop process start." init_alert
		if [ "$targetos" = "SunOS" ]
		then
			kill -17 "$pids" 2>/dev/null
			kill_ret=$?
		else
			kill -12 "$pids" 2>/dev/null
			kill_ret=$?
		fi
		clp_logwrite "$1" "alertsync stop process end.("$kill_ret")" init_alert

		i=0
		while [ "$i" -lt "10" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_alert
			pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webalert 2>&1`
			clp_logwrite "$1" "clppidof2 end.(pids=${pids})" init_alert
			
			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "alertsync stop success." init_alert
				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_success $targetos > /dev/null 2>&1
				else
					clp_success $targetos
				fi

				clp_logwrite "$1" "clusterpro_alertsync stop process end." init_alert
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done
		
		clp_logwrite "$1" "alertsync stop timeout." init_alert
	else
		clp_logwrite "$1" "alertsync not exist." init_alert
	fi
	
	clp_logwrite "$1" "clusterpro_alertsync stop process end." init_alert
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success $targetos > /dev/null 2>&1
	else
		clp_success $targetos
	fi
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	targetos=`/bin/uname`
	if [ "$targetos" = "SunOS" ]
	then
		clp_status_s clpaltd
	else
		clp_status clpaltd
	fi
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
