#!/bin/bash

# シェルスクリプトの if 文の判定に合わせて 0 を true にする
clpcloudutil_true=0
clpcloudutil_false=1

clpcloudutil_set_aws_env()
{
	local logflag=$1
	local r
	local line
	local ids
	local id
	local name
	local value

	ids=(`clpcfget -e "/root/cluster/cloud/aws/envs/env"`)
	r=$?

	if [ "$r" -eq 11 ]
	then
		if [ "$logflag" -eq "$clpcloudutil_true" ]
		then
			# 戻り値 11 の not exit xmlpath エラーは
			# 設定によっては常時発生するためログ出力フラグの制御対象にする
			echo "cmd: clpcfget -e /root/cluster/cloud/aws/envs/env = $r" 1>&2
			echo "msg: ${ids[@]}" 1>&2
		fi
		return $clpcloudutil_false
	elif [ "$r" -ne 0 ]
	then
		echo "cmd: clpcfget -e /root/cluster/cloud/aws/envs/env = $r" 1>&2
		echo "msg: ${ids[@]}" 1>&2
		return $clpcloudutil_false
	fi

	for id in "${ids[@]}"
	do
		name=`clpcfget -g "/root/cluster/cloud/aws/envs/env@$id/name"`
		r=$?

		if [ "$r" -ne 0 ]
		then
			echo "env$id: cmd: clpcfget -e /root/cluster/cloud/aws/envs/env@$id/name = $r" 1>&2
			echo "env$id: msg: $name" 1>&2
			continue
		fi

		value=`clpcfget -g "/root/cluster/cloud/aws/envs/env@$id/value"`
		r=$?

		if [ "$r" -ne 0 ]
		then
			echo "env$id: cmd: clpcfget -e /root/cluster/cloud/aws/envs/env@$id/value = $r" 1>&2
			echo "env$id: msg: $value" 1>&2
			continue
		fi

		if [ "$logflag" -eq "$clpcloudutil_true" ]
		then
			echo "env$id: set: '$name' = '$value'" 1>&2
		fi

		if [ "$name" = "" ]
		then
			echo "env$id: empty name" 1>&2
			continue
		fi

		export "$name"="$value"
	done

	return $clpcloudutil_true
}

clpcloudutil_line_clpaws_setting()
{
	local logflag=$1
	local line=$2

	# コメント除去
	line="`echo "${line%%#*}" | sed -e "s/^[ \t]*\|[ \t]*$//"`"

	# 設定情報読み込み
	name="`echo "${line%%=*}" | sed -e "s/[ \t]*$//"`"
	value="`echo "${line#*=}" | sed -e "s/^[ \t]*//"`"

	if [ "$line" = "$name" -o "$line" = "$value" ]
	then
		# = で分割できなかった場合
		return
	fi

	if [ "$logflag" -eq "$clpcloudutil_true" ]
	then
		echo "clpaws_setting: set: '$name' = '$value'" 1>&2
	fi

	if [ "$name" = "" ]
	then
		echo "clpaws_setting: empty name" 1>&2
		return
	fi

	export "$name"="$value"
}

clpcloudutil_load_clpaws_setting()
{
	local logflag=$1
	local filepath=$2
	local r

	if [ ! -f "$filepath" ]
	then
		if [ "$logflag" -eq "$clpcloudutil_true" ]
		then
			# 設定によっては常時発生するためログ出力フラグの制御対象にする
			echo "not found: $filepath" 1>&2
		fi
		return $clpcloudutil_false
	fi

	if [ "$logflag" -eq "$clpcloudutil_true" ]
	then
		echo "load: $filepath" 1>&2
	fi

	while read line
	do
		clpcloudutil_line_clpaws_setting "$logflag" "$line"
	done < "$filepath"

	if [ -n "$line" ]
	then
		# ファイル末尾が改行以外の場合
		clpcloudutil_line_clpaws_setting "$logflag" "$line"
	fi

	return $clpcloudutil_true
}

clpcloudutil_env_init()
{
	local logflag=$1
	local filepath=$2

	if ! clpcloudutil_set_aws_env "$logflag"
	then
		echo "failure: clpcloudutil_set_aws_env()" 1>&2
	else
		return $clpcloudutil_true
	fi

	if ! clpcloudutil_load_clpaws_setting "$logflag" "$filepath"
	then
		echo "failure: clpcloudutil_load_clpaws_setting()" 1>&2
		return $clpcloudutil_false
	fi

	return $clpcloudutil_true
}

clpcloudutil_awscli_cmdopt()
{
	local logflag=$1
	local awssvc=$2
	local r
	local awscmdopt

	awscmdopt=`clpcfget -g "/root/cluster/cloud/aws/cmdopt/${awssvc}" -p cluster`
	r=$?

	if [ "$r" -ne 0 ]
	then
		echo "awscli_cmdopt: cmd: clpcfget -g /root/cluster/cloud/aws/cmdopt/${awssvc} -p cluster = $r" 1>&2
		echo "awscli_cmdopt: msg: $awscmdopt" 1>&2
		return
	fi

	if [ -z "${awscmdopt}" ]
	then
		return
	fi

	if [[ "$awscmdopt" =~ ";" ]] || [[ "$awscmdopt" =~ "&&" ]] || [[ "$awscmdopt" =~ "||" ]] || [[ "$awscmdopt" =~ "\`" ]]
	then
		echo "awscli_cmdopt: contains the special characters" 1>&2
		echo "awscli_cmdopt: svcname=${awssvc} cmdopt=\"${awscmdopt}\"" 1>&2
		return
	fi

	if [[ "$awscmdopt" =~ "--output" ]]
	then
		echo "awscli_cmdopt: contains the special output option" 1>&2
		echo "awscli_cmdopt: svcname=${awssvc} cmdopt=\"${awscmdopt}\"" 1>&2
		return
	fi

	if [ "$logflag" -eq "$clpcloudutil_true" ]
	then
		echo "awscli_cmdopt: svcname=${awssvc} cmdopt=\"${awscmdopt}\"" 1>&2
	fi

	echo $awscmdopt
}