#! /bin/sh 

#
#  usage : clpbmcforcestop.sh <sub-command>
# 
#  sub-command :
#         stop
#         check-stop
#         monitor
#

#------- static variables -------#

readonly OPT_MODE_MONITOR="monitor"
readonly OPT_MODE_STOPSRV="stop"
readonly OPT_MODE_CHECKSTOP="check-stop"

readonly MSG_CMD_SUCCESS="Command succeeded."
readonly MSG_CMD_FAILED="Command failed."
readonly MSG_ERR_INVALID_OPTION="Invalid option."
readonly MSG_ERR_INVALID_PARAM="Invalid parameter."

readonly RET_CHASSIA_POWER="Chassis Power is off"

readonly RET_CMD_SUCCESS=0
readonly RET_CMD_FAILED=1

#------- variables -------#

opt_cnt=0
opt_nam=""

ret_execute=${RET_CMD_SUCCESS}

# goto MAIN_ROUTINE

####################################################################
#                                                                  #
# Common Functions                                                 #
#                                                                  #
####################################################################

#####################################################################
# name   : DO_MONITOR
# arg#1  : (none)
# local  : ret_cmd, ret_ipmitool, cmd_ipmitool
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Get server power status.
####################################################################
DO_MONITOR()
{
	local ret_cmd=0
	local ret_ipmitool=""

	local cmd_ipmitool="ipmitool -H ${CLP_BMC_HOST} -U ${CLP_BMC_USER} -P ${CLP_BMC_PASSWORD} power status"
	
	#------- execute ipmitool -------
	ret_ipmitool=`${cmd_ipmitool} 2>&1`

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -eq ${RET_CMD_SUCCESS} ]
	then
		return ${RET_CMD_SUCCESS}
	fi

	#------- lanplus -------
	cmd_ipmitool="ipmitool -I lanplus -H ${CLP_BMC_HOST} -U ${CLP_BMC_USER} -P ${CLP_BMC_PASSWORD} power status"
	
	#------- execute ipmitool -------
	ret_ipmitool=`${cmd_ipmitool} 2>&1`

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -eq ${RET_CMD_SUCCESS} ]
	then
		return ${RET_CMD_SUCCESS}
	fi
	
	echo "${MSG_CMD_FAILED} [DO_MONITOR() failed]" 1>&2
	return ${RET_CMD_FAILED}
}

#####################################################################
# name   : FORCE_STOP_SRV
# arg#1  : (none)
# local  : ret_cmd, ret_ipmitool, cmd_ipmitool
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Performing a forced stop action.
####################################################################
FORCE_STOP_SRV()
{
	local ret_cmd=0
	local ret_ipmitool=""

	local cmd_ipmitool="ipmitool -H ${CLP_BMC_HOST} -U ${CLP_BMC_USER} -P ${CLP_BMC_PASSWORD} power ${CLP_BMC_ACTION}"
	
	#------- execute ipmitool -------
	ret_ipmitool=`${cmd_ipmitool} 2>&1`

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -eq ${RET_CMD_SUCCESS} ]
	then
		return ${RET_CMD_SUCCESS}
	fi
	
	#------- lanplus -------
	cmd_ipmitool="ipmitool -I lanplus -H ${CLP_BMC_HOST} -U ${CLP_BMC_USER} -P ${CLP_BMC_PASSWORD} power ${CLP_BMC_ACTION}"
	
	#------- execute ipmitool -------
	ret_ipmitool=`${cmd_ipmitool} 2>&1`

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -eq ${RET_CMD_SUCCESS} ]
	then
		return ${RET_CMD_SUCCESS}
	fi

	echo "${MSG_CMD_FAILED} [FORCE_STOP_SRV() failed]" 1>&2
	return ${RET_CMD_FAILED}
}

#####################################################################
# name   : CHECK_STOP
# arg#1  : (none)
# local  : ret_cmd, ret_ipmitool, cmd_ipmitool
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Check server power.
####################################################################
CHECK_STOP()
{
	local ret_cmd=0
	local ret_ipmitool=""

	local cmd_ipmitool="ipmitool -H ${CLP_BMC_HOST} -U ${CLP_BMC_USER} -P ${CLP_BMC_PASSWORD} power status"
	
	#------- execute ipmitool -------
	ret_ipmitool=`${cmd_ipmitool} 2>&1`

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -eq ${RET_CMD_SUCCESS} ] 
	then
		if [ "${RET_CHASSIA_POWER}" == "${ret_ipmitool}" ]; then
			return ${RET_CMD_SUCCESS}
		else
			echo "${CLP_BMC_HOST} is poweredOn." 1>&2
			return ${RET_CMD_FAILED}
		fi
	fi
	
	#------- lanplus -------
	local cmd_ipmitool="ipmitool -I lanplus -H ${CLP_BMC_HOST} -U ${CLP_BMC_USER} -P ${CLP_BMC_PASSWORD} power status"
	
	#------- execute ipmitool -------
	ret_ipmitool=`${cmd_ipmitool} 2>&1`

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -eq ${RET_CMD_SUCCESS} ]
	then
		if [ "${RET_CHASSIA_POWER}" == "${ret_ipmitool}" ]; then
			return ${RET_CMD_SUCCESS}
		else
			echo "${CLP_BMC_HOST} is poweredOn." 1>&2
			return ${RET_CMD_FAILED}
		fi
	fi
	
	echo "${MSG_CMD_FAILED} [CHECK_STOP() failed]" 1>&2
	return ${RET_CMD_FAILED}
}

####################################################################
#                                                                  #
# Main Routine                                                     #
#                                                                  #
####################################################################
#:MAIN_ROUTINE

#------- option check -------#

opt_cnt=0

for i in $@
do
	case "$i" in
	"${OPT_MODE_MONITOR}" )
		opt_nam=${OPT_MODE_MONITOR}
		opt_cnt=`expr ${opt_cnt} + 1`
		;;
	"${OPT_MODE_STOPSRV}" )
		opt_nam=${OPT_MODE_STOPSRV}
		opt_cnt=`expr ${opt_cnt} + 1`
		;;
	"${OPT_MODE_CHECKSTOP}" )
		opt_nam=${OPT_MODE_CHECKSTOP}
		opt_cnt=`expr ${opt_cnt} + 1`
		;;
	* )
		echo "${MSG_ERR_INVALID_OPTION}" 1>&2
		exit ${RET_CMD_FAILED}
		;;
	esac
done
if [ ${opt_cnt} -ne 1 ]
then

	echo "${MSG_ERR_INVALID_OPTION}" 1>&2
	exit ${RET_CMD_FAILED}
fi

#------- environmental variables check -------#
if [ "${opt_nam}" == "${OPT_MODE_STOPSRV}" ]; then
	if [ -z "$CLP_BMC_ACTION" ]; then
		echo "${MSG_ERR_INVALID_PARAM} [CLP_BMC_ACTION]" 1>&2
		exit ${RET_CMD_FAILED}
	fi
fi
if [ -z "$CLP_BMC_HOST" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_BMC_HOST]" 1>&2
	exit ${RET_CMD_FAILED}
elif [ -z "$CLP_BMC_USER" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_BMC_USER]" 1>&2
	exit ${RET_CMD_FAILED}
elif [ -z "$CLP_BMC_PASSWORD" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_BMC_PASSWORD]" 1>&2
	exit ${RET_CMD_FAILED}
fi

#------- execute -------#
case "${opt_nam}" in
"${OPT_MODE_MONITOR}" )
	DO_MONITOR
	;;
"${OPT_MODE_STOPSRV}" )
	FORCE_STOP_SRV
	;;
"${OPT_MODE_CHECKSTOP}" )
	CHECK_STOP
	;;
* )
	echo "${MSG_ERR_INVALID_OPTION}" 1>&2
	exit ${RET_CMD_FAILED}
	;;
esac

ret_execute=$?

exit ${ret_execute}