#!/bin/sh
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
elif [ -f /lib/lsb/init-functions ]
then
        . /lib/lsb/init-functions
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=0
LANG=C

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_
export LANG

# See how we were called.
case "$1" in
  start)
	targetos=`/bin/uname`
	clp_filedel "$1" init_webmgr $targetos
	clp_logwrite "$1" "clusterpro_webmgr start process start." init_webmgr

	#
	cd /opt/nec/clusterpro/bin

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Starting clusterpro webmanager" > /dev/null 2>&1
	else
		log_begin_msg "Starting clusterpro webmanager"
	fi
	#
	clp_logwrite "$1" "clppidof start." init_webmgr
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webmgr 2>&1`
	clp_logwrite "$1" "clppidof end." init_webmgr
	
	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "webmgr already exist." init_webmgr
		clp_logwrite "$1" "clusterpro_webmgr start process end." init_webmgr
		clp_success
		exit 0
	fi

	# starting clusterpro webmanager server
	clp_logwrite "$1" "webmgr start process start." init_webmgr
	./clpmonp --webmgr -a 2 -o "-start" -r 0 -w 0 > /dev/null 2>&1
	monp_ret=$?
	clp_logwrite "$1" "webmgr start process end.("$monp_ret")" init_webmgr

	clp_checkerr "$monp_ret"
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_webmgr start process end." init_webmgr
		exit 0
	fi

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_webmgr start process end." init_webmgr
		log_end_msg $? > /dev/null 2>&1
	else
		clp_logwrite "$1" "clusterpro_webmgr start process end." init_webmgr
		log_end_msg $?
	fi
	;;
  stop)
	clp_filedel "$1" init_webmgr
	clp_logwrite "$1" "clusterpro_webmgr stop process start." init_webmgr

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Shutting down clusterpro webmanager" > /dev/null 2>&1
	else
		log_begin_msg "Shutting down clusterpro webmanager"
	fi

	#
	cd /opt/nec/clusterpro/bin

	#
	clp_logwrite "$1" "clppidof start." init_webmgr
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/bin/clpmonp --webmgr 2>&1`
	clp_logwrite "$1" "clppidof end." init_webmgr
	
	if [ "$pids" != "" ]
	then
		# shutting down clusterpro webmanager server
		clp_logwrite "$1" "webmgr stop process start." init_webmgr
		kill -12 "$pids" 2>/dev/null
		kill_ret=$?
		clp_logwrite "$1" "webmgr stop process end.("$kill_ret")" init_webmgr

		i=0
		while [ "$i" -lt "25" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_webmgr
			pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webmgr 2>&1`
			clp_logwrite "$1" "clppidof2 end." init_webmgr
			
			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "webmgr stop success." init_webmgr
				clp_success

				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_logwrite "$1" "clusterpro_webmgr stop process end." init_webmgr
					log_end_msg $? > /dev/null 2>&1
				else
					clp_logwrite "$1" "clusterpro_webmgr stop process end." init_webmgr
					log_end_msg $?
				fi
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done

		clp_logwrite "$1" "webmgr stop timeout." init_webmgr
	else
		clp_logwrite "$1" "webmgr not exist." init_webmgr
	fi

	clp_logwrite "$1" "clusterpro_webmgr stop process end." init_webmgr

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success
		log_end_msg $? > /dev/null 2>&1
	else
		clp_success
		log_end_msg $?
	fi
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	clp_status clpwebmc
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
