#!/bin/sh
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
elif [ -f /lib/lsb/init-functions ]
then
        . /lib/lsb/init-functions
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=0
LANG=C

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_
export LANG

# See how we were called.
case "$1" in
  start)
	clp_filedel "$1" init_nm
	clp_logwrite "$1" "clusterpro_nm start process start." init_nm

	#
	cd /opt/nec/clusterpro/bin

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Starting clusterpro node manager" > /dev/null 2>&1
	else
		log_begin_msg "Starting clusterpro node manager"
	fi

	#
	clp_logwrite "$1" "clppidof start." init_nm
	pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --nm 2>&1`
	clp_logwrite "$1" "clppidof end." init_nm

	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "node manager already exist." init_nm
		clp_logwrite "$1" "clusterpro_nm start process end." init_nm
		clp_success
		exit 0
	fi

	# starting clusterpro node manager
	clp_logwrite "$1" "node manager start process start." init_nm
	./clpmonp --nm -a 1 -r 0 -w 0 > /dev/null 2>&1
	monp_ret=$?
	clp_logwrite "$1" "node manager start process end.("$monp_ret")" init_nm

	clp_checkerr "$monp_ret"
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_nm start process end." init_nm
		exit 0
	fi

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_nm start process end." init_nm
		log_end_msg $? > /dev/null 2>&1
	else
		clp_logwrite "$1" "clusterpro_nm start process end." init_nm
		log_end_msg $?
	fi
	;;
  stop)
	clp_filedel "$1" init_nm
	clp_logwrite "$1" "clusterpro_nm stop process start." init_nm

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Shutting down clusterpro node manager" > /dev/null 2>&1
	else
		log_begin_msg "Shutting down clusterpro node manager"
	fi

	#
	cd /opt/nec/clusterpro/bin

	#
	clp_logwrite "$1" "clppidof start." init_nm
	pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --nm 2>&1`
	clp_logwrite "$1" "clppidof end." init_nm
	
	if [ "$pids" != "" ]
	then
		# shutting down clusterpro node manager
		clp_logwrite "$1" "node manager stop process start." init_nm
		kill -12 "$pids" 2>/dev/null
		kill_ret=$?
		clp_logwrite "$1" "node manager stop process end.("$kill_ret")" init_nm

		i=0
		while [ "$i" -lt "270" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_nm
			pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --nm 2>&1`
			clp_logwrite "$1" "clppidof2 end." init_nm
			
			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "node manager stop success." init_nm
				clp_success

				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_logwrite "$1" "clusterpro_nm stop process end." init_nm
					log_end_msg $? > /dev/null 2>&1
				else
					clp_logwrite "$1" "clusterpro_nm stop process end." init_nm
					log_end_msg $?
				fi
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done
		
		clp_logwrite "$1" "node manager stop timeout." init_nm
	else
		clp_logwrite "$1" "node manager not exist." init_nm
	fi

	clp_logwrite "$1" "clusterpro_nm stop process end." init_nm

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success
		log_end_msg $? > /dev/null 2>&1
	else
		clp_success
		log_end_msg $?
	fi
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	clp_status clpnm
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
