#!/bin/sh
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
elif [ -f /lib/lsb/init-functions ]
then
        . /lib/lsb/init-functions
fi

. /opt/nec/clusterpro/bin/clpfunctions
export PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
export LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
export MALLOC_CHECK_=0
export LANG=C

# See how we were called.
case "$1" in
  start)
	clp_filedel "$1" init_ib
	clp_logwrite "$1" "clusterpro_ib start process start." init_ib

	#
	cd /opt/nec/clusterpro/bin

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Starting clusterpro information base" > /dev/null 2>&1
	else
		log_begin_msg "Starting clusterpro information base"
	fi

	#
	clp_logwrite "$1" "clppidof start." init_ib
	pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --ibsv 2>&1`
	clp_logwrite "$1" "clppidof end." init_ib

	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "information base already exist." init_ib
		clp_logwrite "$1" "clusterpro_ib start process end." init_ib
		clp_success
		exit 0
	fi

	# starting clusterpro information base
	clp_logwrite "$1" "information base start process start." init_ib
	./clpmonp --ibsv -a 2 -r 0 -w 0 > /dev/null 2>&1
	monp_ret=$?
	clp_logwrite "$1" "information base start process end.("$monp_ret")" init_ib

	clp_checkerr "$monp_ret"
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_ib start process end." init_ib
		exit 0
	fi

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_ib start process end." init_ib
		log_end_msg $? > /dev/null 2>&1
	else
		clp_logwrite "$1" "clusterpro_ib start process end." init_ib
		log_end_msg $?
	fi
	;;
  stop)
	clp_filedel "$1" init_ib
	clp_logwrite "$1" "clusterpro_ib stop process start." init_ib

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Shutting down clusterpro information base" > /dev/null 2>&1
	else
		log_begin_msg "Shutting down clusterpro information base"
	fi

	#
	cd /opt/nec/clusterpro/bin

	#
	clp_logwrite "$1" "clppidof start." init_ib
	pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --ibsv 2>&1`
	clp_logwrite "$1" "clppidof end." init_ib
	
	if [ "$pids" != "" ]
	then
		# shutting down clusterpro information base
		clp_logwrite "$1" "information base stop process start." init_ib
		kill -12 "$pids" 2>/dev/null
		kill_ret=$?
		clp_logwrite "$1" "information base stop process end.("$kill_ret")" init_ib

		i=0
		while [ "$i" -lt "10" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_ib
			pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --ibsv 2>&1`
			clp_logwrite "$1" "clppidof2 end." init_ib
			
			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "information base stop success." init_ib
				clp_success

				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_logwrite "$1" "clusterpro_ib stop process end." init_ib
					log_end_msg $? > /dev/null 2>&1
				else
					clp_logwrite "$1" "clusterpro_ib stop process end." init_ib
					log_end_msg $?
				fi
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done
		
		clp_logwrite "$1" "information base stop timeout." init_ib
	else
		clp_logwrite "$1" "information base not exist." init_ib
	fi

	clp_logwrite "$1" "clusterpro_ib stop process end." init_ib

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success
		log_end_msg $? > /dev/null 2>&1
	else
		clp_success
		log_end_msg $?
	fi
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	clp_status clpibsv
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
