#!/bin/sh
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
elif [ -f /lib/lsb/init-functions ]
then
        . /lib/lsb/init-functions
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=2

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_

# See how we were called.
case "$1" in
  start)
	targetos=`/bin/uname`

	clp_filedel "$1" init_api $targetos
	clp_logwrite "$1" "clusterpro_api start process start." init_api

	#
	cd /opt/nec/clusterpro/bin

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Starting clusterpro api" > /dev/null 2>&1
	else
		log_begin_msg "Starting clusterpro api"
	fi

	#
	clp_logwrite "$1" "clppidof start." init_api
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --rstd 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_api

	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "api already exist." init_api
		clp_logwrite "$1" "clusterpro_api start process end." init_api
		clp_success $targetos
		exit 0
	fi

	# starting clusterpro api
	clp_logwrite "$1" "api start process start." init_api
	./clpmonp --rstd -a 2 -r 0 -w 0 > /dev/null 2>&1
	monp_ret=$?
	clp_logwrite "$1" "api start process end.("$monp_ret")" init_api

	clp_checkerr "$monp_ret" $targetos
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_api start process end." init_api
		exit 0
	fi

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_api start process end." init_api
		log_end_msg $? > /dev/null 2>&1
	else
		clp_logwrite "$1" "clusterpro_api start process end." init_api
		log_end_msg $?
	fi
	;;
  stop)
	targetos=`/bin/uname`

	clp_filedel "$1" init_api $targetos
	clp_logwrite "$1" "clusterpro_api stop process start." init_api

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Shutting down clusterpro api" > /dev/null 2>&1
	else
		log_begin_msg "Shutting down clusterpro api"
	fi

	#
	cd /opt/nec/clusterpro/bin

	#
	clp_logwrite "$1" "clppidof start." init_api
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --rstd 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_api

	if [ "$pids" != "" ]
	then
		# shutting down clusterpro api
		clp_logwrite "$1" "api stop process start." init_api
		if [ "$targetos" = "SunOS" ]
		then
			kill -17 "$pids" 2>/dev/null
			kill_ret=$?
		else
			kill -12 "$pids" 2>/dev/null
			kill_ret=$?
		fi
		clp_logwrite "$1" "api stop process end.("$kill_ret")" init_api

		i=0
		while [ "$i" -lt "10" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_api
			pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --rstd 2>&1`
			clp_logwrite "$1" "clppidof2 end.(pids=${pids})" init_api

			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "api stop success." init_api
				clp_success $targetos

				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_logwrite "$1" "clusterpro_api stop process end." init_api
					log_end_msg $? > /dev/null 2>&1
				else
					clp_logwrite "$1" "clusterpro_api stop process end." init_api
					log_end_msg $?
				fi
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done

		clp_logwrite "$1" "api stop timeout." init_api
	else
		clp_logwrite "$1" "api not exist." init_api
		clp_success $targetos

		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_logwrite "$1" "clusterpro_api stop process end." init_api
			log_end_msg $? > /dev/null 2>&1
		else
			clp_logwrite "$1" "clusterpro_api stop process end." init_api
			log_end_msg $?
		fi
		exit 0
	fi

	clp_logwrite "$1" "clusterpro_api stop process end." init_api
	clp_success $targetos
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	targetos=`/bin/uname`
	if [ "$targetos" = "SunOS" ]
	then
		clp_status_s clprstd
	else
		clp_status clprstd
	fi
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
