#!/bin/sh
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
elif [ -f /lib/lsb/init-functions ]
then
        . /lib/lsb/init-functions
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=0
LANG=C

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_
export LANG

# See how we were called.
case "$1" in
  start)
	clp_filedel "$1" init_alert
	clp_logwrite "$1" "clusterpro_alertsync start process start." init_alert

	#
	cd /opt/nec/clusterpro/bin

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Starting clusterpro webalert" > /dev/null 2>&1
	else
		log_begin_msg "Starting clusterpro webalert"
	fi

	#
	clp_logwrite "$1" "clppidof start." init_alert
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webalert 2>&1`
	clp_logwrite "$1" "clppidof end." init_alert

	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "alertsync already exist." init_alert
		clp_logwrite "$1" "clusterpro_alert start process end." init_alert
		clp_success
		exit 0
	fi

	# starting clusterpro webalert
	clp_logwrite "$1" "alertsync start process start." init_alert
	./clpmonp --webalert -a 2 -r 0 -w 0 > /dev/null 2>&1
	monp_ret=$?
	clp_logwrite "$1" "alertsync start process end.("$monp_ret")" init_alert

	clp_checkerr "$monp_ret"
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_alert start process end." init_alert
		exit 0
	fi

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_alert start process end." init_alert
		log_end_msg $? > /dev/null 2>&1
	else
		clp_logwrite "$1" "clusterpro_alert start process end." init_alert
		log_end_msg $?
	fi
	;;
  stop)
	clp_filedel "$1" init_alert
	clp_logwrite "$1" "clusterpro_alertsync stop process start." init_alert

	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		log_begin_msg "Shutting down clusterpro webalert" > /dev/null 2>&1
	else
		log_begin_msg "Shutting down clusterpro webalert"
	fi

	#
	cd /opt/nec/clusterpro/bin

	#
	clp_logwrite "$1" "clppidof start." init_alert
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webalert 2>&1`
	clp_logwrite "$1" "clppidof end." init_alert
	
	if [ "$pids" != "" ]
	then
		# shutting down clusterpro webalert
		clp_logwrite "$1" "alertsync stop process start." init_alert
		kill -12 "$pids" 2>/dev/null
		kill_ret=$?
		clp_logwrite "$1" "alertsync stop process end.("$kill_ret")" init_alert

		i=0
		while [ "$i" -lt "10" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_alert
			pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --webalert 2>&1`
			clp_logwrite "$1" "clppidof2 end." init_alert
			
			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "alertsync stop success." init_alert
				clp_success

				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_logwrite "$1" "clusterpro_alertsync stop process end." init_alert
					log_end_msg $? > /dev/null 2>&1
				else
					clp_logwrite "$1" "clusterpro_alertsync stop process end." init_alert
					log_end_msg $?
				fi
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done
		
		clp_logwrite "$1" "alertsync stop timeout." init_alert
	else
		clp_logwrite "$1" "alertsync not exist." init_alert
	fi

	clp_logwrite "$1" "clusterpro_alertsync stop process end." init_alert

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success
		log_end_msg $? > /dev/null 2>&1
	else
		clp_success
		log_end_msg $?
	fi
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	clp_status clpaltd
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
