/*
 * clphttpsvr.js
 * Copyright (C) 2019 nec
 */

const fs = require('fs');
const http = require('http');
const https = require('https');
const net = require('net');
const process = require('process');
const childProcess = require('child_process');
const conf = require('./clprstconf.js');
const URL = require('url').URL;
const URLSearchParams = require('url').URLSearchParams;
const qs_str = require('querystring');

/* 
 * args
 */
/* method */
const method = process.argv[2];
/* log level */
const loglv = process.argv[3];
/* log size */
const logsz = process.argv[4];
/* Install Path */
const Inspath = process.argv[5];
const logpath = Inspath + '/log';
const log = require('./clplogger.js').init('rsthttp', logpath, loglv, logsz);
/* keyfile */
const keyfile = process.argv[6];
/* crtfile */
const crtfile = process.argv[7];
/* httpport */
const httpport = process.argv[8];
/* rstdport */
const rstdport = process.argv[9];
/* httpauthto */
const http_authto = process.argv[10];
/* httpInterval */
const http_interval = (process.argv[11] * 1000);
/* dst ip addr */
const dst_ip_addr = process.argv[12];
/* httpauthretry */
const http_authretry = process.argv[13];
/* httpauthrefusetime */
const http_authrefusetime = process.argv[14];

/* global */
let rstd_web_server;
let req_id;
let conn_retry_arry = null;
let clsock;
let user_info;	/* array user_info[n] = [ip, auth, trial_num, lasttime, rejecttime, permission] */

let res_list = [];
let res_max_num = conf.method_list.RES_MAX;	/* request access max */

let recv_save_data = '';
let reqcode = 0;

/*********************** */
/*    main processing    */
/*********************** */

/* init */
rsthttp_init();

/* create web server( http or https ) and listen */
create_webserver();

/* Signal Handling of Node.js */
process.on('SIGINT', termhandle);
process.on('SIGTERM', termhandle);

/* Error Handling of Node.js(unhandledRejection) */
process.on('unhandledRejection', (err, p) => {
	log('error', p);
	log('error', err);
});

/* Error Handling of Node.js(uncaughtException) */
process.on('uncaughtException', (err) => {
	log('error', err).then(() => process.exit(1));
});

/*********************** */
/*   Entity definition   */
/*********************** */
/*
 * init
 */
function rsthttp_init() {
    var ret = 0;
    let i = 0;

    log('debug', 'rsthttp_init() start ->.');
    
 	/* create user_info arry */
	user_info = new Array();

	/* timer */
	conn_retry_arry = new Array();

   /* connect to rstd */
    connect_rstd();
    
    /* method check */
    ret = chk_method();
    if (ret == -1) {
        log('error', `chk_method() failed. unknown method(method=${method}).`).then(() => process.exit(1));
    }
    
    log('debug', `<- rsthttp_init() end(${method}).`);
    return;
}

/*
 * response list add
 */
function res_info_add(res) {
	let ret = 0;
	let res_num = 0;
	
	log('debug', 'res_info_add() start ->.');

	/* get list num */
	res_num = res_list.length;
	log('debug', `add before res num : ${res_num}`);
	
	if (res_num == res_max_num) {
		/* append to max request over */
		log('debug', `Append to end of res_list failed(res num : ${res_num}).`);
		ret = 1;
	} else {
		/* Append to end of res_list */
		res_list.push(res);
		/* get list num */
		res_num = res_list.length;
		log('debug', `add after res num : ${res_num}`);
	}
	
	log('debug', '<- res_info_add() end.');
	return ret;
}

/*
 * get response from list
 */
function res_info_get() {
	let res = 0;
	
	log('debug', 'res_info_get() start ->.');

	/* get list num */
	res_num = res_list.length;
	log('debug', `shift before res num : ${res_num}`);

	/* get response from list */
	res = res_list.shift();

	/* get list num */
	res_num = res_list.length;
	log('debug', `shift after res num : ${res_num}`);

	log('debug', '<- res_info_get() end.');
	return res;
}

/*
 * rstd connection
 */
function connect_rstd() {
	
    let mypid = '';
    let mypid_str = '';
    let req_data = '';
    let i = 0;

    log('debug', 'connect_rstd() start ->.');

    /* connect */
    clsock = net.createConnection(rstdport, dst_ip_addr, function() {
        log('info', 'rsthttp -> rstd connected.');
        /* clear timer */
        log('debug', `Timeout set id num: ${conn_retry_arry.length}.`);
        if (conn_retry_arry.length > 0) {
	        for (i<0; i < conn_retry_arry.length; i++) {
				clearTimeout(conn_retry_arry[i]);
				log('debug', `clearTimeout id : ${conn_retry_arry[i]}.`);
			}
		}
        /* pid send */
        mypid = process.pid;
        log('debug', `clprsthttp pid : ${mypid}.`);
	    let str_code = l_padding(0, '0', conf.req_head_fmt.CODE_LEN);
	    let str_type = l_padding(0, '0', conf.req_head_fmt.TYPE_LEN);
	    let str_mypid = String(mypid);
	    log('debug', `clprsthttp pid str: ${str_mypid}.`);
	    let str_dtsize = l_padding(str_mypid.length, '0', conf.req_head_fmt.DATA_LEM);
	    req_data = conf.req_head_fmt.REQ_ID + str_code + str_type + str_dtsize;
	    log('debug', `REQ DATA: ${req_data}`);
        clsock.write(req_data);
        clsock.write(str_mypid);
    });

	/* data event handling */
	clsock.on('data', socket_recv_handle);
	
	/* close event handling */
	clsock.on('close', socket_close_handle);

	/* error event handling */
	clsock.on('error', socket_error_handle);
        
    log('debug', '<- connect_rstd() end.');
    return;
}

/*
 * soket data(recv) handle
 */
function socket_recv_handle(data)
{
	let res;
	
	let index = 0;
	let work_data = '';
	let res_data = '';
	let next_data = '';
	let res_data_len = 0;
	let sep_pos = 0;
	let res_data_cnt = 1;
	let json;
	let json_obj;
	let incomp_flg = 0;
	
	log('debug', `socket_recv_handle() start -> .`);
    
    /* receive data = save data + new data */
    work_data = recv_save_data + data;
    log('debug', `recv_save_data(recv_save_data): ${recv_save_data}`);
    log('debug', `recv_new_data(data): ${data}`);
    
    /* serch separator */
    index = work_data.indexOf('\t');
    if (index !== -1) {
		/* get one response data length */
		res_data_len = Number(work_data.substring(0, index));
		log('debug', `response data len: ${res_data_len} workdata len: ${work_data.length}`);
		log('debug', `separator pos: ${index}`);
		/* get single response data? */
		if (res_data_len === work_data.length) {
        	res = res_info_get();
			try {
				res_data = work_data.substring((index+1), res_data_len);
				log('debug', `one res data : ${res_data}`);
    			json = JSON.parse(res_data);
        		json_obj = JSON.stringify(json, undefined,4);
        		log('debug', `json -> ${json_obj}.`);
        		send_response(res, 200, json_obj);
        	} catch (e) {
				log('error', `socket_recv_handle() make json : ${e.message}.`);
				err_json = make_error_json('9999', conf.err_msg_list.ERROR_MSG_RES_ANALYZE, reqcode);
				send_response(res, 500, err_json);
			}
			/* responce complete */
			recv_save_data = '';
			log('debug', `recv_save_data initialized : ${recv_save_data}.`);
		}
		/* get muilti response data? */
		else if (res_data_len < work_data.length) {
			/* nect response data */
			next_data = work_data.substr(res_data_len);
			log('debug', `incomplete next data: ${next_data}`);
			while(next_data.length != 0) {
				/* serch separator */
				index = next_data.indexOf('\t');
				if (index == -1) {
					console.log(`save incomplete receive data(next_data) : ${next_data} res_data_cnt: ${res_data_cnt}.`);
					recv_save_data = next_data;
					break;
				} else {
					/* get next response data length */
					res_data_len = Number(next_data.substring(0, index));
					log('debug', `next response data len: ${res_data_len} res_data_cnt: ${res_data_cnt}.`);
					if (res_data_len > next_data.length) {
						/* incomplete receive data */
						recv_save_data = next_data;
						console.log(`save incomplete receive data(next_data) : ${next_data} res_data_cnt: ${res_data_cnt}.`);
						incomp_flg = 1;
						break;
					} else {
						res = res_info_get();
						try {
							res_data = next_data.substring((index+1), res_data_len);
							console.log(`one res data(next) : ${res_data} res_data_cnt: ${res_data_cnt}.`);
							json = JSON.parse(res_data);
							json_obj = JSON.stringify(json, undefined,4);
							log('debug', `json -> ${json_obj}.`);
							send_response(res, 200, json_obj);
						} catch (e) {
							log('error', `socket_recv_handle() make json : ${e.message}.`);
							err_json = make_error_json('9999', conf.err_msg_list.ERROR_MSG_RES_ANALYZE, reqcode);
							send_response(res, 500, err_json);
						}
						/* get incomplete receive data*/
						next_data = next_data.substr(res_data_len);
						console.log(`get incomplete receive data(next_data) : ${next_data} res_data_cnt: ${res_data_cnt}.`);
					}
				}
				res_data_cnt++;
			}
			/* responce complete */
			if (incomp_flg === 0) {
				recv_save_data = '';
				log('debug', `recv_save_data initialized : ${recv_save_data}.`);
			}
		}
		/* incomplete receive data */
		else if (res_data_len > work_data.length) {
			/* save recv data */
			recv_save_data = work_data;
			console.log(`save incomplete receive data(work_data) : ${work_data}`);
			console.log(`recv save data(recv_save_data): ${recv_save_data}`);
		}
    } else {
		/* exist next recv data */
		recv_save_data = work_data;
		log('debug', `not exist sep in recv data save(work_data): ${work_data}`);
		log('debug', `recv save data(recv_save_data): ${recv_save_data}`);
	}

	log('debug', '<- socket_recv_handle() end.');
}

/*
 * socket close handle
 */
function socket_close_handle()
{
    log('debug', 'socket_close_handle() start -> .');
    /* destroy socket */
    clsock.destroy();
    log('info', 'socket destroy.');
    /* retry to rstd connect set */
    id = setTimeout(connect_rstd, Number(http_interval));
    log('info', `set retry connect timer(id: ${id}).`);
    conn_retry_arry.push(id);
    log('info', `retry to connect_rstd() after ${Number(http_interval)} msec.`);
	log('debug', '<- socket_close_handle() end.');
}

/*
 * socket close handle
 */
function socket_error_handle(err)
{
	let res_list_num = 0;
	let res;
	let del_res;
	
    log('debug', 'socket_error_handle() start -> .');
    log('error', `socket error : ${err}.`);

	/* res exist in resinfo send err response */
    res_list_num = res_list.length;
    log('debug', `accepting res num : ${res_list_num}.`);
    
    /* res exist in resinfo? */
    if (res_list.length != 0) {
		res_list.forEach( function( res )  {
	        log('error', `create_response() recv error : ${err}.`);
	        err_json = make_error_json('9999', conf.err_msg_list.ERROR_MSG_REQ_SEND, reqcode);
	        send_response(res, 500, err_json);
	        /* res delete from res_list */
	        del_res = res_list.shift();
	        res_list_num = res_list.length;
	        log('debug', `del after res num : ${res_list_num}.`);
		});
	}
	
	log('debug', '<- socket_error_handle() end.');
}

/*
 * create web server
 */
function create_webserver()
{
    log('debug', 'create_webserver() start -> .');

	try {
	    /* create web server */
	    switch (Number(method)) {
	        case conf.method_list.HTTP:
	            rstd_web_server = http.createServer((req,res) => web_server_listener(req, res, get_protocol()));
	            log('debug', `create webserver : ${method}.`);
	            break;
	        case conf.method_list.HTTPS:
	            const options = {
	                key: fs.readFileSync(keyfile),
	                cert: fs.readFileSync(crtfile)
	            }
	            rstd_web_server = https.createServer(options, (req,res) => web_server_listener(req, res, get_protocol()));
	            log('debug', `create webserver : ${method}.`);
	            break;
	        default:
	            break;
	    }
	    /* create failed */
	    rstd_web_server.on('error', (err) => {
	        log('error', `create_webserver() failed : ${err}.`).then(() => process.exit(1));
	    });
	    /* server listen */
	    rstd_web_server.listen(httpport);
	    /* server set timeout(0) */
	    rstd_web_server.setTimeout(0);
	} catch (e) {
		log('error', e).then(() => process.exit(1));
	}
    
    log('debug', `rstd_web_server listen (port=${httpport}).`);
    log('debug', '<- create_webserver() end.');
    return;
}

/* method check */
function chk_method() {
    var ret = -1;

    log('debug', 'chk_method() start -> .');

	try {
	    switch (Number(method)) {
	    case conf.method_list.HTTP:
	        ret = conf.method_list.HTTP;
	        break;
	    case conf.method_list.HTTPS:
	        ret = conf.method_list.HTTPS;
	        break;
	    default:
	        log('error', `non support method : ${method}.`).then(() => process.exit(1));
	        break;
	    }
	} catch (e) {
		log('error', e).then(() => process.exit(1));
	}

    log('debug', `<- chk_method() end(ret : ${ret}).`);
    return ret;
}

/*
 * is_auth
 */
function is_auth(path, size, auth, ip) {
    let child_ps;
    let exit_code;

	log('debug', 'is_auth() start -> .');
	
    child_ps = childProcess.spawn(path);
    child_ps.stdin.write(size);
    child_ps.stdin.write(auth);
    child_ps.stdin.write(ip);
    child_ps.stdin.end();
    return new Promise((resolve) => {
        child_ps.on('error', function (err) {
            log('error', `clprstauth() spawn faild(${err}).`);
            log('debug', 'is_auth() end -> .');
            resolve(1);
        });
        child_ps.on('close', function (exit_code) {
            log('debug', `exit_code : ${exit_code}`);
            log('debug', 'is_auth() end -> .');
            resolve(exit_code);
        });
    });
}
/*
 * client access chk
 */
async function cl_access_chk(auth, ip) {
    let b64_auth;
    let path;
    let size;
    let size_str;
    let ret;
    
    log('debug', 'cl_access_chk() start -> .');
    
    log('debug', `auth: ${auth}`);
    log('debug', `ip: ${ip}`);
    
    /* command */
    path = Inspath + '/bin/clprstauth';
    log('debug', `cmd: ${path}`);
    size = auth.substring(6).length;
    size_str = l_padding(size, '0', conf.req_head_fmt.CODE_LEN);
    log('debug', `auth size: ${size_str}`);
    ret = await is_auth(path, size_str, auth.substring(6), ip);
    
    log('debug', `cl_access_chk(is_auth ret: ${ret}) end -> .`);
    return ret;
}

/*
 * exist_user_info
 */
function exist_user_info(ip, auth) {
	let id = -1;
	let i;
	let a_info;
	let exist_ip;
	let exist_auth;
	
	log('debug', 'exist_user_info() start -> .');
	
	if (user_info.length > 0) {
		for (i=0; i < user_info.length; i++ ) {
			a_info = user_info[i];
			exist_ip = a_info.includes(ip);
			if (exist_ip) {
				log('debug', `exist ip :${ip} in user_info(index :${i})`);
				exist_auth = a_info.includes(auth);
				if (exist_auth) {
					log('debug', `exist auth :${auth} in user_info(index :${i})`);
					id = i;
					break;
				}
			}
		}
	}
	
	log('debug', `exist_user_info() end(user_info num: ${user_info.length} id: ${id}) -> .`);
	return id;
}
 
/*
 * add_user_info(ip, auth) {
 */
function add_user_info(ip, auth) {
	
	let i = 0;
	let id = -1;
	let a_info;
	let exist_free;

	log('debug', 'add_user_info() start -> .');
	
	/* find same user info */
	id = exist_user_info(ip, auth);
	if (id > 0) {
		log('debug', 'already exists user info. add skiped.');
		return 0;
	}
	
	if (user_info.length > 0) {
		id = user_info.length;
	} else {
		id = 0;
	}
	user_info[id] = new Array(ip, auth, 0, '', '');
	
	log('debug', `add_user_info() end -> (add id : ${id} ip: ${ip} auth: ${auth}).`);
	return id;
}
 
/*
 * update_user_info(auth_sts, ip, auth, permission)
 */
function update_user_info(auth_sts, ip, auth, permission) {
	
	let last_date = '';
	let reject_date = '';
	let trial = 0;
	let id = 0;
	
	log('debug', `update_user_info(auth_sts: ${auth_sts}) start -> .`);
	
	/* user info exist check */
	id = exist_user_info(ip, auth);
	if (id == -1) {
		log('debug', 'not exists specific user info.');
		return -1;
	}
	
	if (auth_sts < conf.user_permissions.RSTAUTH_AUTH_STATUS_NG) {
		/* auth success */
		last_date = get_now_date();
		log('debug', `auth success(auth_sts: ${auth_sts} last_date: ${last_date}`);
	} else {
		/* auth error */
		trial = user_info[id][conf.user_info_modify.USR_INF_TRIAL];
		trial += 1;
		if (trial == http_authretry) {
			reject_date = get_now_date();
		}
		log('debug', `auth failed(auth_sts: ${auth_sts} trial: ${trial} last_date: ${last_date} reject_date: ${reject_date}}`);
	}
	user_info[id][conf.user_info_modify.USR_INF_TRIAL] = trial;
	user_info[id][conf.user_info_modify.USR_INF_LASTTIME] = last_date;
	user_info[id][conf.user_info_modify.USR_INF_REJECTTIME] = reject_date;
	user_info[id][conf.user_info_modify.USR_INF_PERMISSION] = permission;
	
	log('debug', `update_user_info() end(trial: ${trial} last_date: ${last_date} reject_date: ${reject_date} permission: ${permission}) -> .`);
	return 0;
}

/*
 * is_user_rejection
 */
function is_user_rejection(ip, auth) {
	
	let id;
	let reject_date;
	let now_date;
	let reject_dt;
	let now_dt;
	
	log('debug', 'is_user_rejection() start -> .');
	
	/* parameter check */
	if (auth.length == 0) {
		log('error', `not specified authorization(length: ${auth.length}).`);
		log('error', 'is_user_rejection() end(1) -> .');
		return 1;
	}
	
	/* user info exist check */
	id = exist_user_info(ip, auth);
	if (id == -1) {
		log('debug', 'not exists specific user info. User access is new.');
		log('debug', 'is_user_rejection() end(0) -> .');
		return 0;
	}
	
	/* reject date check */
	reject_date = user_info[id][conf.user_info_modify.USR_INF_REJECTTIME];
	log('debug', `id :${id} reject_date :${reject_date}.`);
	if (reject_date == '') {
		log('debug', 'non set rejecttime.User access is possible.');
		log('debug', 'is_user_rejection() end(0) -> .');
		return 0;
	}
	
	now_date = get_now_date();
	log('debug', `now_date :${now_date}`);
	
	/* diff time check */
	reject_dt = new Date(reject_date);
	now_dt = new Date(now_date);
	diff_time = Math.floor((now_dt.getTime()-reject_dt.getTime()) / 1000);
	log('debug', `diff_time : ${diff_time}`);
	if (diff_time > http_authrefusetime) {
		log('debug', 'delete before user_info num :${user_info.length}');
		log('debug', 'reject time has passed. user_info delete');
		user_info[id] = [];
		log('debug', 'delete after user_info num :${user_info.length}');
		log('debug', 'is_user_rejection() end(0) -> .');
		return 0;
	} else {
		log('error', 'authorization rejection continued.');
		log('error', 'is_user_rejection() end(1) -> .');
		return 1;
	}
}
 
/*
 * is_auth_check
 */
function is_auth_check(ip, auth) {
	
	let id = 0;
	let now_date;
	let last_date;
	let last_dt;
	let now_dt;
	let diff_time = 0;
	
	log('debug', 'is_auth_check() start -> .');
	
	/* user info exist check */
	id = exist_user_info(ip, auth);
	if (id == -1) {
		log('debug', 'necessary authorization check.');
		add_user_info(ip, auth);
		return 1;
	}
	
	/* get now date / last date */
	now_date = get_now_date();
	last_date = user_info[id][conf.user_info_modify.USR_INF_LASTTIME];
	log('debug', `now_date : ${now_date} last_date : ${last_date}`);
	
	/* diff time check */
	now_dt = new Date(now_date);
	last_dt = new Date(last_date);
	diff_time = Math.floor((now_dt.getTime()-last_dt.getTime()) / 1000);
	log('debug', `diff_time : ${diff_time}`);
	log('debug', `http_authto : ${http_authto}`);
	if (diff_time <= http_authto) {
		log('debug', 'authorization skiped. is_auth_check() end(0) -> .');
		return 0;
	} else {
		log('debug', 'necessary authorization check. is_auth_check() end(1) -> .');
		return 1;
	}
}

/*
 * get_permission
 */
function get_permission(ip, auth) {
	let i;
	let a_info;
	let exist_ip;
	let exist_auth;
	let permission = -1;
	
	log('debug', 'get_permission() start -> .');
	
	if (user_info.length > 0) {
		for (i=0; i < user_info.length; i++ ) {
			a_info = user_info[i];
			exist_ip = a_info.includes(ip);
			if (exist_ip) {
				log('debug', `exist ip :${ip} in user_info(index :${i})`);
				exist_auth = a_info.includes(auth);
				if (exist_auth) {
					permission = a_info[conf.user_info_modify.USR_INF_PERMISSION];
					log('debug', `get permission :${permission} in user_info(index :${i})`);
					break;
				}
			}
		}
	}
	
	log('debug', `get_permission() end(id: ${i} permission :${permission}) -> .`);
	return permission;
}

/*
 * chk_permission
 */
function chk_permission(method, permission) {
	let ret = -1;
	
	/* check permission and method */
	switch (permission) {
	/* Non check permission */
	case conf.user_permissions.RSTAUTH_AUTH_STATUS_NORMAL_OK:
		log('error', `Non check Permission(${permission}).`);
		ret = 0;
		break;
	/* Reference permission */
	case conf.user_permissions.RSTAUTH_AUTH_STATUS_REF_OK:
		switch (method) {
		case 'GET':
		    log('debug', `GET method can be executed with this permission(${method} ${permission}).`);
		    ret = 0;
			break;
    	case 'POST':
		    log('error', `POST method cannot be executed with this permission(${method} ${permission}).`);
		    break;
		default:
		    log('error', `Non Supported Method(${method}).`);
    		break;
    	}
		break;
	/* Operate permission */
	case conf.user_permissions.RSTAUTH_AUTH_STATUS_OPE_OK:
		switch (method) {
		case 'GET':
    	case 'POST':
		    log('debug', `GET and POST method can be executed with this permission(${method} ${permission}).`);
		    ret = 0;
			break;
		default:
		    log('error', `Non Supported Method(${method}).`);
    		break;
    	}
		break;
	/* etc */
	default:
		log('error', `Non Supported Permission(${permission}).`);
	    break;
	}
	
	return ret;
}

/*
 * get now date
 */
function get_now_date() {
	let ymd;
	let hms;
	let now_date;
	let dt;
	
	log('debug', 'get_now_date() start -> .');
	
	dt = new Date();
	ymd = get_date_format(dt);
	hms = get_time_format(dt);
	
	now_date = ymd + ' ' + hms;
	
	log('debug', `get_now_date() end(now date: ${now_date}) -> .`);
	return now_date;
}

/*
 * get date format
 */
function get_date_format(dt) {
	let y;
	let m;
	let d;
	let ymd;
	
	log('debug', 'get_date_format() start -> .');
	/* format date */
	y = dt.getFullYear();
	m = dt.getMonth() + 1;
	d = dt.getDate();
	
	if (m < 10) m = '0' + m;
    if (d < 10) d = '0' + d;

    ymd = y + '/' + m + '/' + d;
    log('debug', `get_date_format() end(ymd: ${ymd}) -> .`);
    return ymd;
}

/*
 * get time format
 */
function get_time_format(dt) {
	let h;
	let m;
	let s;
	let hms;
	
	log('debug', 'get_time_format() start -> .');
	
	/* format time */
	h = dt.getHours();
	m = dt.getMinutes();
	s = dt.getSeconds();
	if (h < 10) h = '0' + h;
	if (m < 10) m = '0' + m;
	if (s < 10) s = '0' + s;
	hms = h + ':' + m + ':' + s;
	
    log('debug', `get_time_format() end(hms: ${hms}) -> .`);
	return hms;
}

/*
 * http or https listener
 */
function web_server_listener(req, res, protocol)
{
    let ret = 0;
    let update_ret = 0;
    let auth_ret = 0;
	let auth;
	let ip;
    let permission = -1;
    
    log('debug', 'web_server_listener() start -> .');

	req.setEncoding('utf8');
	
    /* url analyzed */
    const info = get_info(req, protocol);
    log('debug', `ID: ${info.id} protocol: ${info.protocol} method: ${info.method} host: ${info.host} port: ${info.port} path: ${info.path} search: ${info.search}` );
	
    req.on('data', function(chunk) {
        info.data += chunk;
        log('debug', `client recv chunk data : ${chunk}`);
    }).on('end', function() {
        log('debug', `ID: ${info.id}: Received request`);
        log('debug', info);
        
	    /* client check */
	    auth = req.headers["authorization"]||"";
	    const remoteAddress = req.connection.remoteAddress;
	    /* check auth rejection */
	    ret = is_user_rejection(remoteAddress, auth.substring(6));
	    log('debug', `is_user_rejection() ret(${ret}).`);
	    if (ret == 1) {
			log('error', `is_user_rejection() faild(${ret})`);
			err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_REQ_NOT_ALLOWED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
			send_response(res, 403, err_json);
			return;
		}
	    
		/* check exist user info */
	    ret = is_auth_check(remoteAddress, auth.substring(6));
		log('debug', `is_auth_check() ret(${ret}).`);
		if (ret == 1) {
    		cl_access_chk(auth, remoteAddress).then((auth_ret) => {
				log('debug', `cl_access_chk auth_ret: ${auth_ret}`);
				return new Promise((resolve, reject)=>{
					/* user info update */
					update_ret = update_user_info(auth_ret, remoteAddress, auth.substring(6), auth_ret);
					if (update_ret < 0) {
						/* internal error */
						err_json = make_error_json('9999', conf.err_msg_list.ERROR_MSG_REQ_PROCESSED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 500, err_json);
						log('error', `update_user_info() failed(${update_ret})`);
						reject(1);
					}
					if (auth_ret == conf.user_permissions.RSTAUTH_AUTH_STATUS_NG) {
						/* reject access user error */
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_AUTH_FAILED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 401, err_json);
						log('error', 'cl_access_chk() failed reject access user.');
						reject(1);
					}
					if (auth_ret == conf.user_permissions.RSTAUTH_IP_STATUS_NG) {
						/* reject access ip error */
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_REQ_NOT_ALLOWED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 403, err_json);
						log('error', 'cl_access_chk() failed reject access ip.');
						reject(1);
					}
					if (auth_ret == conf.user_permissions.RSTAUTH_INTERNAL_ERR) {
						/* internal error */
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_REQ_NOT_ALLOWED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 500, err_json);
						log('error', 'cl_access_chk() failed internal error.');
						reject(1);
					}
					/* success */
					resolve(auth_ret);
				});
			}).then((ret) => {
				log('debug', `cl_access_chk(permission : ${ret}) success.`);
				/* send to rstd request */
				request_worker(info, res, ret);
			});
		} else {
			permission = get_permission(remoteAddress, auth.substring(6));
			if (permission == -1) {
				log('error', 'get_permission() failed internal error.');
				err_json = make_error_json('9999', conf.err_msg_list.ERROR_MSG_REQ_PROCESSED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
				/* error response */
				send_response(res, 500, err_json);
			}
			/* send to rstd request */
			request_worker(info, res, permission);
		}
    }).on('error', function(err) {
        log('error', err);
        err_json = make_error_json('9999', conf.err_msg_list.ERROR_MSG_REQ_PROCESSED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
        /* error response */
        send_response(res, 500, err_json);
    });
    
    res.on('finish', function() {
        log('info', `ID: ${info.id}: Sent response`);
    }).on('error', function(err) {
        log('error', err);
    });

	log('debug', '<- web_server_listener() end.');
	return;
}

/*
 * request worker
 */
function request_worker(info,res,permission)
{
    let err_json;
	let path_arry = '';
	let param = '';
	let err_flg = 0;
	let obj = '';
	let target = '';
	let act = '';
	let query_param = '';
	let qs_num = 0;
	let qs_key;
	let ret = -1;
	let ratio = 0;
	let time = 'none';
	let script = 'none';
	let timeout = 180;
	let logdir = 'none';
	let method 
	
	log('debug', `request_worker() start -> (id: ${info.id} method: ${info.method} search: ${info.search} data: ${info.data}).`);
	
    /* Permit check */
    ret = chk_permission(info.method, permission);
    if (ret != 0) {
        /* permission error */
        log('error', `Illegal Permission(method:${method} permission:${permission}).`);
        err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
        send_response(res, 400, err_json);
        return;
    }
  
    /* send to rstd request */
    switch (info.method) {
    case 'POST':
        try {
			err_flg = conf.bool_value.BOOL_FALSE;
			path_arry = split_str('/', info.path);
			switch (path_arry[conf.url_type_list.URL_TYPE_POS]) {
			case conf.url_type_list.URL_TYPE_CLS:
			    if (info.data != '') {
					obj = JSON.parse(info.data);
					if ('ratio' in obj) {
						ratio = obj.ratio;
						log('debug', `set arg ratio : ${ratio}`);
					} else {
						log('error', `non set ratio parameter.`);
						err_flg = conf.bool_value.BOOL_TRUE;
					}
					if ('time' in obj) {
						if (ratio != 1) {
							time = obj.time;
							log('debug', `set arg time : ${time}`);
						} else {
							log('error', `not set time parameter when ratio set 1.`);
							err_flg = conf.bool_value.BOOL_TRUE;
						}
					} else {
						if (ratio == 1) {
							time = 'none';
							log('debug', `set arg time : ${time}`);
						} else {
							log('error', `non set time parameter.`);
							err_flg = conf.bool_value.BOOL_TRUE;
						}
					}
				}
				log('debug', `final set arg ratio : ${ratio} time : ${time}`);
				if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
			    	log('debug', `POST TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
			    	log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_NO_NM_POS]}`);
			    	act = path_arry[conf.url_type_list.URL_ACT_NO_NM_POS];
			    } else if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_6) {
					log('debug', `POST TYPE1: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
					log('debug', `POST TYPE2: ${path_arry[conf.url_type_list.URL_TYPE2_POS]}`);
					log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_POS]}`);
					act = path_arry[conf.url_type_list.URL_ACT_POS];
					param = ratio.toString() + ',' + time;
					log('debug', `param : ${param }`);
			    } else {
	                err_flg = conf.bool_value.BOOL_TRUE;
				}
			    if (err_flg == conf.bool_value.BOOL_FALSE) {
					switch (act) {
					case conf.url_type_list.URL_ACT_START:
						reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_START
						log('debug', 'post action cluster start.');
						break;
					case conf.url_type_list.URL_ACT_STOP:
						reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_STOP
						log('debug', 'post action cluster stop.');
						break;
					case conf.url_type_list.URL_ACT_REBOOT:
						reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_REBOOT
						log('debug', 'post action cluster reboot.');
						break;
					case conf.url_type_list.URL_ACT_SHUTDOWN:
						reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_SHUTDOWN
						log('debug', 'post action cluster shutdown.');
						break;
					case conf.url_type_list.URL_ACT_SUSPEND:
						reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_SUSPEND
						log('debug', 'post action cluster suspend.');
						break;
					case conf.url_type_list.URL_ACT_RESUME:
						reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_RESUME
						log('debug', 'post action cluster resume.');
						break;
					case conf.url_type_list.URL_ACT_SET:
					    reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_RATIO_SET
					    log('debug', 'post action cluster toratio set.');
					    break;
					case conf.url_type_list.URL_ACT_RESET:
					    reqcode = conf.reqcode_list.REQ_RSTAPI_CLS_ACT_RATIO_RESET
					    log('debug', 'post action cluster toratio reset.');
					    break;
		            default:
		                err_flg = conf.bool_value.BOOL_TRUE;
		                break;
					}
					if (err_flg == conf.bool_value.BOOL_FALSE) {
						create_response(reqcode, param, res);
					} else {
						log('error', `Unsupported Action(${act}).`);
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 400, err_json);
					}
				} else {
	                log('error', `Unsupported Action(${act}).`);
	                err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
	                send_response(res, 400, err_json);
				}
				break;
			case conf.url_type_list.URL_TYPE_SVR:
			    if (info.data != '') {
					obj = JSON.parse(info.data);
					target = obj.target;
				} else {
					target = 'none';
				}
				if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_6) {
				    log('debug', `POST TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
				    log('debug', `POST NAME: ${path_arry[conf.url_type_list.URL_NAME_POS]}`);
				    log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_POS]}`);
				    act = path_arry[conf.url_type_list.URL_ACT_POS];
				    param = path_arry[conf.url_type_list.URL_NAME_POS] + ',' + target;
				} else {
					err_flg = conf.bool_value.BOOL_TRUE;
				}
			    if (err_flg == conf.bool_value.BOOL_FALSE) {
					switch (act) {
					case conf.url_type_list.URL_ACT_START:
						reqcode = conf.reqcode_list.REQ_RSTAPI_SVR_ACT_START
						log('debug', 'post action server service start( -> ${param}).');
						break;
					case conf.url_type_list.URL_ACT_STOP:
						reqcode = conf.reqcode_list.REQ_RSTAPI_SVR_ACT_STOP
						log('debug', 'post action server service stop( -> ${param}).');
						break;
					case conf.url_type_list.URL_ACT_REBOOT:
						reqcode = conf.reqcode_list.REQ_RSTAPI_SVR_ACT_REBOOT
						log('debug', 'post action server reboot( -> ${param}).');
						break;
					case conf.url_type_list.URL_ACT_SHUTDOWN:
						reqcode = conf.reqcode_list.REQ_RSTAPI_SVR_ACT_SHUTDOWN
						log('debug', 'post action cluster shutdown( -> ${param}).');
						break;
		            default:
		                err_flg = conf.bool_value.BOOL_TRUE;
		                break;
					}
					if (err_flg == conf.bool_value.BOOL_FALSE) {
						create_response(reqcode, param, res);
					} else {
						log('error', `Unsupported Action(${act}).`);
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 400, err_json);
					}
				} else {
	                log('error', `Unsupported Action(${act}).`);
	                err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
	                send_response(res, 400, err_json);
				}
				break;
			case conf.url_type_list.URL_TYPE_GRP:
			    if (info.data != '') {
					obj = JSON.parse(info.data);
					target = obj.target;
				} else {
					target = 'none';
				}
				if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_6) {
				    log('debug', `POST TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
				    log('debug', `POST NAME: ${path_arry[conf.url_type_list.URL_NAME_POS]}`);
				    log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_POS]}`);
				    act = path_arry[conf.url_type_list.URL_ACT_POS];
				    param = path_arry[conf.url_type_list.URL_NAME_POS] + ',' + target;
				} else if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
				    log('debug', `POST TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
				    log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_NO_NM_POS]}`);
				    act = path_arry[conf.url_type_list.URL_ACT_NO_NM_POS];
				    param = 'none' + ',' + target;
				} else {
					err_flg = conf.bool_value.BOOL_TRUE;
				}
			    log('debug', `param: ${param}`);
			    if (err_flg == conf.bool_value.BOOL_FALSE) {
					switch (act) {
					case conf.url_type_list.URL_ACT_START:
						reqcode = conf.reqcode_list.REQ_RSTAPI_GRP_ACT_START
						log('debug', 'post action group start.');
						break;
					case conf.url_type_list.URL_ACT_STOP:
						reqcode = conf.reqcode_list.REQ_RSTAPI_GRP_ACT_STOP
						log('debug', 'post action group stop.');
						break;
					case conf.url_type_list.URL_ACT_MOVE:
						reqcode = conf.reqcode_list.REQ_RSTAPI_GRP_ACT_MOVE
						log('debug', 'post action group move( -> ${param}).');
						break;
		            default:
		                err_flg = conf.bool_value.BOOL_TRUE;
		                break;
					}
					if (err_flg == conf.bool_value.BOOL_FALSE) {
						create_response(reqcode, param, res);
					} else {
						log('error', `Unsupported Action(${act}).`);
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 400, err_json);
					}
				} else {
	                log('error', `Unsupported Action(${act}).`);
	                err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
	                send_response(res, 400, err_json);
				}
				break;
			case conf.url_type_list.URL_TYPE_RSC:
			    if (info.data != '') {
					obj = JSON.parse(info.data);
					target = obj.target;
				} else {
					target = 'none';
				}
				if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_6) {
				    log('debug', `POST TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
				    log('debug', `POST NAME: ${path_arry[conf.url_type_list.URL_NAME_POS]}`);
				    log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_POS]}`);
				    act = path_arry[conf.url_type_list.URL_ACT_POS];
				    param = path_arry[conf.url_type_list.URL_NAME_POS] + ',' + target;
				} else {
					err_flg = conf.bool_value.BOOL_TRUE;
				}
			    log('debug', `param: ${param}`);
			    if (err_flg == conf.bool_value.BOOL_FALSE) {
					switch (act) {
					case conf.url_type_list.URL_ACT_START:
						reqcode = conf.reqcode_list.REQ_RSTAPI_RES_ACT_START
						log('debug', 'post action resource start.');
						break;
					case conf.url_type_list.URL_ACT_STOP:
						reqcode = conf.reqcode_list.REQ_RSTAPI_RES_ACT_STOP
						log('debug', 'post action resource stop.');
						break;
		            default:
		                err_flg = conf.bool_value.BOOL_TRUE;
		                break;
					}
					if (err_flg == conf.bool_value.BOOL_FALSE) {
						create_response(reqcode, param, res);
					} else {
						log('error', `Unsupported Action(${act}).`);
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 400, err_json);
					}
				} else {
	                log('error', `Unsupported Action(${act}).`);
	                err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
	                send_response(res, 400, err_json);
				}
			    break;
			case conf.url_type_list.URL_TYPE_MON:
			    if (info.data != '') {
					obj = JSON.parse(info.data);
					target = obj.target;
				} else {
					target = 'none';
				}
				if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_6) {
				    log('debug', `POST TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
				    log('debug', `POST NAME: ${path_arry[conf.url_type_list.URL_NAME_POS]}`);
				    log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_POS]}`);
				    act = path_arry[conf.url_type_list.URL_ACT_POS];
				    param = path_arry[conf.url_type_list.URL_NAME_POS] + ',' + target;
				} else {
					err_flg = conf.bool_value.BOOL_TRUE;
				}
			    log('debug', `param: ${param}`);
			    if (err_flg == conf.bool_value.BOOL_FALSE) {
					switch (act) {
					case conf.url_type_list.URL_ACT_SUSPEND:
						reqcode = conf.reqcode_list.REQ_RSTAPI_MON_ACT_SUSPEND
						log('debug', 'post action resource start.');
						break;
					case conf.url_type_list.URL_ACT_RESUME:
						reqcode = conf.reqcode_list.REQ_RSTAPI_MON_ACT_RESUME
						log('debug', 'post action resource stop.');
						break;
		            default:
		                err_flg = conf.bool_value.BOOL_TRUE;
		                break;
					}
					if (err_flg == conf.bool_value.BOOL_FALSE) {
						create_response(reqcode, param, res);
					} else {
						log('error', `Unsupported Action(${act}).`);
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 400, err_json);
					}
				} else {
	                log('error', `Unsupported Action(${act}).`);
	                err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
	                send_response(res, 400, err_json);
				}
			    break;
			case conf.url_type_list.URL_TYPE_SCRIPTS:
			    if (info.data != '') {
					obj = JSON.parse(info.data);
					if ('script' in obj) {
						script = obj.script;
						log('debug', `set arg scriptname : ${script}`);
					} else {
						log('error', `non set scriptname parameter.`);
						err_flg = conf.bool_value.BOOL_TRUE;
					}
					if ('target' in obj) {
						target = obj.target;
					} else {
						target = 'none';
					}
					log('debug', `set arg target : ${target}`);
					if ('timeout' in obj) {
						timeout = obj.timeout;
					}
					log('debug', `set arg timeout : ${timeout}`);
					if ('logdir' in obj) {
						logdir = obj.logdir;
					}
					log('debug', `set arg logdir : ${logdir}`);
				} else {
					log('error', `not set parameter.`);
					err_flg = conf.bool_value.BOOL_TRUE;
				}
				if (err_flg == conf.bool_value.BOOL_FALSE) {
					if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
						log('debug', `POST TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
						log('debug', `POST ACTION: ${path_arry[conf.url_type_list.URL_ACT_NO_NM_POS]}`);
						act = path_arry[conf.url_type_list.URL_ACT_NO_NM_POS];
						param = script + ',' + target + ',' + timeout.toString() + ',' + logdir;
						log('debug', `param : ${param }`);
					} else {
						err_flg = conf.bool_value.BOOL_TRUE;
					}
				}
				if (err_flg == conf.bool_value.BOOL_FALSE) {
					switch (act) {
						case conf.url_type_list.URL_ACT_RUN:
							reqcode = conf.reqcode_list.REQ_RSTAPI_SC_ACT_EXEC
							log('debug', 'post action user script run.');
							break;
						default:
							err_flg = conf.bool_value.BOOL_TRUE;
							break;
					}
					if (err_flg == conf.bool_value.BOOL_FALSE) {
						create_response(reqcode, param, res);
					} else {
						log('error', `Unsupported Action(${act}).`);
						err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
						send_response(res, 400, err_json);
					}
				} else {
					log('error', `Unsupported Action(${act}).`);
					err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
					send_response(res, 400, err_json);
				}
				break;
	        default:
	            log('error', `Unsupported types(${path_arry[conf.url_type_list.URL_TYPE_POS]}).`);
	            err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
	            /* error response */
	            send_response(res, 400, err_json);
	            break;
	        }
        } catch {
	            log('error', `catch Post method illegal Error.`);
	            err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
	            /* error response */
	            send_response(res, 400, err_json);
		}
        break;
    case 'GET':
        path_arry = split_str('/', info.path);
        switch (path_arry[conf.url_type_list.URL_TYPE_POS]) {
        case conf.url_type_list.URL_TYPE_CLS:
			switch (path_arry.length) {
				case conf.url_param_num_list.URL_PARAM_NUM_4:
					log('debug', `GET TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
					create_response(conf.reqcode_list.REQ_RSTAPI_CLS_GET_STS, conf.req_head_fmt.NON_PARAM, res);
					break;
				case conf.url_param_num_list.URL_PARAM_NUM_5:
					log('debug', `GET TYPE1: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
					log('debug', `GET TYPE2: ${path_arry[conf.url_type_list.URL_TYPE2_POS]}`);
					create_response(conf.reqcode_list.REQ_RSTAPI_CLS_GET_RATIO, conf.req_head_fmt.NON_PARAM, res);
					break;
				default:
					log('error', `Unsupported types(${path_arry[conf.url_type_list.URL_TYPE_POS]}).`);
					err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
					send_response(res, 400, err_json);
					break;
			}
            break;
        case conf.url_type_list.URL_TYPE_SVR:
            log('debug', `GET TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
            if (info.search == "") {
            	/* get server status request */
            	log('debug', 'get server status request.');
            	if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
					log('debug', 'specified server name : ${path_arry[conf.url_type_list.URL_NAME_POS]}.');
					create_response(conf.reqcode_list.REQ_RSTAPI_SVR_GET_STS, path_arry[conf.url_type_list.URL_NAME_POS], res);
				} else {
					log('debug', 'non specified server name.');
					create_response(conf.reqcode_list.REQ_RSTAPI_SVR_GET_STS, conf.req_head_fmt.NON_PARAM, res);
				}
            } else {
            	/* get server name list */
            	log('debug', 'get server name list request.');
            	create_response(conf.reqcode_list.REQ_RSTAPI_SVR_GET_ENUM, conf.req_head_fmt.NAME_PARAM, res);
			}
            break;
        case conf.url_type_list.URL_TYPE_GRP:
            log('debug', `GET TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
            if (info.search == "") {
            	/* get group status request */
            	log('debug', 'get group status request.');
            	if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
					log('debug', 'specified group name : ${path_arry[conf.url_type_list.URL_NAME_POS]}.');
					create_response(conf.reqcode_list.REQ_RSTAPI_GRP_GET_STS, path_arry[conf.url_type_list.URL_NAME_POS], res);
				} else {
					log('debug', 'non specified group name.');
					create_response(conf.reqcode_list.REQ_RSTAPI_GRP_GET_STS, conf.req_head_fmt.NON_PARAM, res);
				}
            } else {
				/* query param check */
                log('debug', `query parameter: ${info.search.toString()}.`);
				query_param = qs_str.parse(info.search.toString());
				qs_num = Object.keys(query_param).length;
				/* parameter num check */
				if (qs_num != 1) {
					log('error', `query parameter specified error(qs_num: ${qs_num}).`);
					err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
					/* error response */
					send_response(res, 400, err_json);
					break;
				}
				log('debug', `get query param num : ${qs_num}.`);
				/* parameter value check */
				for (qs_key in query_param) {
					switch (qs_key) {
						case conf.req_head_fmt.SEL_PROP:
							switch (query_param[qs_key]) {
								case conf.req_head_fmt.NAME_PARAM:
									/* get group name list */
									log('debug', 'get group name list request.');
									create_response(conf.reqcode_list.REQ_RSTAPI_GRP_GET_ENUM, conf.req_head_fmt.NAME_PARAM, res);
									break;
								case conf.req_head_fmt.RSC_PARAM:
									if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
										/* get resource name list on group */
										log('debug', 'get resource name list on group request.');
										create_response(conf.reqcode_list.REQ_RSTAPI_GRP_GET_RSCENUM, path_arry[conf.url_type_list.URL_NAME_POS], res);
									} else {
										log('error', 'not specified group name.');
										err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
										/* error response */
										send_response(res, 400, err_json);
									}
									break;
								default:
									log('error', `get query parameter illegal error(key:${qs_key} value:${query_param[qs_key]}).`);
									err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
									/* error response */
									send_response(res, 400, err_json);
									break;
							}
							break;
						default:
							log('error', `get query parameter illegal error(key:${qs_key} value:${query_param[qs_key]}).`);
							err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
							/* error response */
							send_response(res, 400, err_json);
							break;
					}
				}
			}
            break;
        case conf.url_type_list.URL_TYPE_RSC:
            log('debug', `GET TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
            if (info.search == "") {
            	/* get resource status request */
            	log('debug', 'get resource status request.');
            	if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
					log('debug', 'specified group name : ${path_arry[conf.url_type_list.URL_NAME_POS]}.');
					create_response(conf.reqcode_list.REQ_RSTAPI_RES_GET_STS, path_arry[conf.url_type_list.URL_NAME_POS], res);
				} else {
					log('debug', 'non specified resource name.');
					create_response(conf.reqcode_list.REQ_RSTAPI_RES_GET_STS, conf.req_head_fmt.NON_PARAM, res);
				}
            } else {
            	/* get resource name list */
            	log('debug', 'get resource name list request.');
            	create_response(conf.reqcode_list.REQ_RSTAPI_RES_GET_ENUM, conf.req_head_fmt.NAME_PARAM, res);
			}
        	break;
        case conf.url_type_list.URL_TYPE_MON:
            log('debug', `GET TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
            if (info.search == "") {
            	/* get group status request */
            	log('debug', 'get group status request.');
            	if (path_arry.length == conf.url_param_num_list.URL_PARAM_NUM_5) {
					log('debug', 'specified group name : ${path_arry[conf.url_type_list.URL_NAME_POS]}.');
					create_response(conf.reqcode_list.REQ_RSTAPI_MON_GET_STS, path_arry[conf.url_type_list.URL_NAME_POS], res);
				} else {
					log('debug', 'non specified group name.');
					create_response(conf.reqcode_list.REQ_RSTAPI_MON_GET_STS, conf.req_head_fmt.NON_PARAM, res);
				}
            } else {
            	/* get group name list */
            	log('debug', 'get group name list request.');
            	create_response(conf.reqcode_list.REQ_RSTAPI_MON_GET_ENUM, conf.req_head_fmt.NAME_PARAM, res);
			}
        	break;
        case conf.url_type_list.URL_TYPE_MIRRORS:
        	log('debug', `GET TYPES: ${path_arry[conf.url_type_list.URL_TYPE_POS]}`);
        	if (info.search == "") {
				log('error', `query parameter specified error(qs_num: ${qs_num}).`);
				err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
				/* error response */
				send_response(res, 400, err_json);
				break;
			} else {
				/* query param check */
                log('debug', `query parameter: ${info.search.toString()}.`);
				query_param = qs_str.parse(info.search.toString());
				qs_num = Object.keys(query_param).length;
				/* parameter num check */
				if (qs_num != 1) {
					log('error', `query parameter specified error(qs_num: ${qs_num}).`);
					err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
					/* error response */
					send_response(res, 400, err_json);
					break;
				}
				log('debug', `get query param num : ${qs_num}.`);
				/* url path length check */
				if (path_arry.length != conf.url_param_num_list.URL_PARAM_NUM_6) {
					log('error', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL);
					err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
					/* error response */
					send_response(res, 400, err_json);
					break;
				}
				/* url action check */
				if (path_arry[conf.url_type_list.URL_ACT_POS] != conf.url_type_list.URL_ACT_RECOVERY) {
					log('error', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL);
					err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
					/* error response */
					send_response(res, 400, err_json);
					break;
				}
				log('debug', `get url action : ${path_arry[conf.url_type_list.URL_ACT_POS]}.`);
				/* parameter value check */
				for (qs_key in query_param) {
					switch (qs_key) {
						case conf.req_head_fmt.TYP_PROP:
							switch (query_param[qs_key]) {
								case conf.req_head_fmt.MD_PARAM:
									/* get mirror disk resource recovery status request */
									log('debug', 'get mirror disk resource recovery status request.');
									create_response(conf.reqcode_list.REQ_RSTAPI_MD_GET_RWTSTS, path_arry[conf.url_type_list.URL_NAME_POS], res);
									break;
								case conf.req_head_fmt.HD_PARAM:
									/* get hybrid disk resource recovery status request */
									log('debug', 'get hybrid disk resource recovery status request.');
									create_response(conf.reqcode_list.REQ_RSTAPI_HD_GET_RWTSTS, path_arry[conf.url_type_list.URL_NAME_POS], res);
									break;
								default:
									log('error', `get query parameter illegal error(key:${qs_key} value:${query_param[qs_key]}).`);
									err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
									/* error response */
									send_response(res, 400, err_json);
									break;
							}
							break;
						default:
							log('error', `get query parameter illegal error(key:${qs_key} value:${query_param[qs_key]}).`);
							err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
							/* error response */
							send_response(res, 400, err_json);
							break;
					}
				}
			}
        	break;
        default:
            log('error', `Unsupported types(${path_arry[conf.url_type_list.URL_TYPE_POS]}).`);
            err_json = make_error_json('1', conf.err_msg_list.ERROR_MSG_URL_ILLEGAL, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
            /* error response */
            send_response(res, 400, err_json);
            break;
        }
        break;
    default:
        log('error', `ID: ${info.id}: Unsupported method. (${info.method})`);
        err_json = make_error_json('3', conf.err_msg_list.ERROR_MSG_METHOD_FAILED, conf.reqcode_list.REQ_RSTAPI_UNKNOWN);
        /* error response */
        send_response(res, 405, err_json);
        break;
    }
    
    log('debug', `<-request_worker() end.`);
}

/*
 * get connect information
 */
function get_info(req, protocol)
{
    log('debug', 'get_info() start -> .');

    const url = new URL(req.url, `${protocol}://${req.headers.host}`);
    url.searchParams.sort();
    log('info', '<- get_info() end.');
    return {
        id: ++req_id,
        protocol: protocol,
        method: req.method,
        host: url.hostname,
        port: url.port,
        path: url.pathname,
        search: url.searchParams,
        data: ''
    };
}

/*
 * create response
 */
function create_response(reqcode, param, res) {

    let ret = 0;
    let req_data = '';
    let rcv_data = '';
    let wk_data = '';
    let wk_arry;
    let err_json;
    let res_arry;
    let rcv_full_size = 0;
    let rcv_cur_size = 0;
    
    let i = 0;

    log('debug', 'create_response() start -> .');
        
    /* create req header */
    let str_code = l_padding(reqcode, '0', conf.req_head_fmt.CODE_LEN);
    let str_type = l_padding(conf.req_head_fmt.TYPE_JSON, '0', conf.req_head_fmt.TYPE_LEN);
    let str_dtsize = l_padding(param.length, '0', conf.req_head_fmt.DATA_LEM);
    req_data = conf.req_head_fmt.REQ_ID + str_code + str_type + str_dtsize;
    log('debug', `REQ DATA: ${req_data}`);
    
	/* response list set */
	ret = res_info_add(res);
    if (ret == 1) {
		/* request is busy */
        log('error', `check_max_resinfo() faild : ${ret} request is busy.`);
        err_json = make_error_json('9999', conf.err_msg_list.ERROR_MSG_REQ_BUSY, reqcode);
        /* error response */
        send_response(res, 500, err_json);
	}
	
    /* send req to rstd */
    if (param == "") {
		/* send header only */
    	ret = clsock.write(req_data);
    } else {
		/* send header + data */
		ret = clsock.write(req_data);
		ret = clsock.write(param);
	}
	
    log('debug', '<- create_response() end.');
    return;
}

/*
 * terminate handle
 */
function termhandle(signal)
{
    let i = 0;

    log('debug', `termhandle() start(recv signal : (${signal})) ->.`);

    new Promise(resolve => {
        /* clear timer */
        log('debug', `Timeout set id num: ${conn_retry_arry.length}.`);
        if (conn_retry_arry.length > 0) {
	        for (i < 0; i < conn_retry_arry.length; i++) {
				clearTimeout(conn_retry_arry[i]);
				const retry_obj = JSON.stringify(conn_retry_arry[i]);
	        	log('debug', `conn_retry_arry[i] -> i : ${i} ${retry_obj}.`);
			}
		}
		
		conn_retry_arry.length = 0;
		res_list.length = 0;
		
	    /* delete userinfo */
	    user_info.length = 0;
        if (!rstd_web_server) {
            log('info', 'non create web server end');
            resolve();
            return;
        }
        rstd_web_server.close(() => {
            log('info', 'web server close');
            resolve();
        });
    }).then(() => log.term());
}

/*
 * right padding
 */
function r_padding(val, char, n) {
    log('debug', 'r_padding() start ->.');
    for (; val.length < n; val += char);
    return val;
    log('debug', '<- r_padding() end.');
}

/*
 * left padding
 */
function l_padding( val, char, n ) {
    var leftval = "";
    
    log('debug', 'l_padding() start ->.');
    for ( ; leftval.length < n; leftval += char);
    return ( leftval + val ).slice( -n );
    log('debug', '<- l_padding() end.');
}

/*
 * split str
 */
function split_str(sep, str) {
    log('debug', 'split_str() start ->.');
    return String(str).split(sep);
    log('debug', '<- split_str() end.');
}

/* get method property(protocol) */
function get_protocol() {
    log('debug', 'get_protocol() start ->.');
    return conf.method_list.properties[method].protocol;
    log('debug', '<- get_protocol() end.');
}

/* get key value in json */
function get_json_value(json ,key) {

    let json_arry;
    let value;

    log('debug', 'get_json_value() start ->.');

    json_arry = JSON.parse(json_data);
    value = json_arry[key];
    log('debug', `get value(${key} : ${value}).`);

    log('debug', '<- get_json_value() end.');

    return value;
}

/* make error json str */
function make_error_json(code, msg, reqcode) {

    let json;
    let json_str;

    log('debug', `make_error_json() start(code : ${code} reqcode : ${reqcode}) ->.`);

	try {
	    switch (Number(reqcode)) {
	    case conf.reqcode_list.REQ_RSTAPI_CLS_GET_STS:
	        json = {result:{},cluster:{}};
	        json.result['code'] = code;
	        json.result['message'] = msg;
	        json.cluster['name'] = "";
	        json.cluster['status'] = "";
	        break;
	    case conf.reqcode_list.REQ_RSTAPI_CLS_ACT_START:
	    case conf.reqcode_list.REQ_RSTAPI_CLS_ACT_STOP:
	    default:
	        json = {result:{}};
	        json.result['code'] = code;
	        json.result['message'] = msg;
	        break;
	    }
        str_json = JSON.stringify(json, undefined, 4);
	} catch (e) {
		log('error', e).then(() => process.exit(9999));
	}

    log('debug', `<-make_error_json() end(json : ${str_json}).`);
	return str_json;
}

/* send http response function */
function send_response(res, stscode, msg) {
    log('debug', `send_response() start(stscode : ${stscode} msg : ${msg}) ->.`);
    
    res.writeHead(stscode, { 'Content-Type': 'application/json;charset=utf-8', 'Cache-Control': 'private, no-cache, no-store, must-revalidate', 'Pragma': 'no-cache' });
    res.write(msg);
    res.end();

    log('debug', `<-send_response() end.`);
}
