/*
 * def.js
 * Copyright (C) 2019 nec
 */

/* protocol type */
var method_list = {
	HTTP  : 0,
	HTTPS : 1,
	properties : {
		0 : { protocol : 'http', value : 0 },
		1 : { protocol : 'https', value : 1 }
	},
	RES_MAX : 64
}

/* requrst code */
var reqcode_list = {
	REQ_RSTAPI_CLS_GET_STS         : 1001,
	REQ_RSTAPI_CLS_ACT_START       : 1002,
	REQ_RSTAPI_CLS_ACT_STOP        : 1003,
	REQ_RSTAPI_CLS_ACT_REBOOT      : 1004,
	REQ_RSTAPI_CLS_ACT_SHUTDOWN    : 1005,
	REQ_RSTAPI_CLS_ACT_SUSPEND     : 1006,
	REQ_RSTAPI_CLS_ACT_RESUME      : 1007,
	REQ_RSTAPI_CLS_GET_RATIO       : 1008,
	REQ_RSTAPI_CLS_ACT_RATIO_SET   : 1009,
	REQ_RSTAPI_CLS_ACT_RATIO_RESET : 1010,
	REQ_RSTAPI_SVR_GET_STS         : 1101,
	REQ_RSTAPI_SVR_GET_ENUM        : 1102,
	REQ_RSTAPI_SVR_ACT_START       : 1103,
	REQ_RSTAPI_SVR_ACT_STOP        : 1104,
	REQ_RSTAPI_SVR_ACT_REBOOT      : 1105,
	REQ_RSTAPI_SVR_ACT_SHUTDOWN    : 1106,
	REQ_RSTAPI_GRP_GET_STS         : 1201,
	REQ_RSTAPI_GRP_GET_ENUM        : 1202,
	REQ_RSTAPI_GRP_ACT_START       : 1203,
	REQ_RSTAPI_GRP_ACT_STOP        : 1204,
	REQ_RSTAPI_GRP_ACT_MOVE        : 1205,
	REQ_RSTAPI_GRP_GET_RSCENUM     : 1206,
	REQ_RSTAPI_RES_GET_STS         : 1301,
	REQ_RSTAPI_RES_GET_ENUM        : 1302,
	REQ_RSTAPI_RES_ACT_START       : 1303,
	REQ_RSTAPI_RES_ACT_STOP        : 1304,
	REQ_RSTAPI_MON_GET_STS         : 1401,
	REQ_RSTAPI_MON_GET_ENUM        : 1402,
	REQ_RSTAPI_MON_ACT_SUSPEND     : 1403,
	REQ_RSTAPI_MON_ACT_RESUME      : 1404,
	REQ_RSTAPI_SC_ACT_EXEC         : 1501,
	REQ_RSTAPI_MD_GET_RWTSTS       : 1601,
	REQ_RSTAPI_HD_GET_RWTSTS       : 1701,
	REQ_RSTAPI_UNKNOWN             : 9999
}

/* url in types list */
var url_type_list = {
	URL_TYPE_POS      : 3,
	URL_TYPE2_POS     : 4,
	URL_NAME_POS      : 4,
	URL_ACT_NO_NM_POS : 4,
	URL_ACT_POS       : 5,
    URL_TYPE_CLS      : 'cluster',
    URL_TYPE_SVR      : 'servers',
    URL_TYPE_GRP      : 'groups',
    URL_TYPE_RSC      : 'resources',
    URL_TYPE_MON      : 'monitors',
    URL_TYPE_TORATIO  : 'toratio',
    URL_TYPE_SCRIPTS  : 'scripts',
    URL_TYPE_MIRRORS  : 'mirrors',
    URL_ACT_START     : 'start',
    URL_ACT_STOP      : 'stop',
    URL_ACT_MOVE      : 'move',
    URL_ACT_REBOOT    : 'reboot',
    URL_ACT_SHUTDOWN  : 'shutdown',
    URL_ACT_SUSPEND   : 'suspend',
    URL_ACT_RESUME    : 'resume',
    URL_ACT_SET	      : 'set',
    URL_ACT_RESET	  : 'reset',
    URL_ACT_RUN       : 'run',
    URL_ACT_RECOVERY  : 'recovery'
}

/* url in param num pattern list */
var url_param_num_list = {
	URL_PARAM_NUM_4 : 4,
	URL_PARAM_NUM_5 : 5,
	URL_PARAM_NUM_6 : 6
}

/* url in action list */
var url_act_list = {
	URL_ACT_POS4     : 4,
	URL_ACT_POS5     : 5,
    URL_ACT_START    : 'start',
    URL_ACT_STOP     : 'stop',
    URL_ACT_REBOOT   : 'reboot',
    URL_ACT_SHUTDOWN : 'shutdown',
    URL_ACT_SUSPEND  : 'suspend',
    URL_ACT_RESUME   : 'resume',
    URL_ACT_MOVE     : 'move'
}


/* response mode */
var res_mode_list = {
    REQ_RSTAPI_RES_TYPE_JS  : 1,
    REQ_RSTAPI_RES_TYPE_BIN : 2
}

/* exit code */
var exitcode_list = {
	RSTHTTP_ERROR_SUCCESS   : 0,
	RSTHTTP_ERROR_NOT_START : 1
}

/* bool value */
var bool_value = {
	BOOL_TRUE  : 1,
	BOOL_FALSE : 0
}

/* flag value */
var flag_value = {
	ON  : 1,
	OFF : 0
}

/* req head format */
var req_head_fmt = {
	CONN_DST  : 'localhost',
	REQ_ID    : 'RSTAPIID',
	NON_PARAM : '',
	NAME_PARAM: 'name',
	RSC_PARAM : 'resources',
	SEL_PROP  : 'select',
	TYP_PROP  : 'type',
	MD_PARAM  : 'md',
	HD_PARAM  : 'hd',
	TYPE_JSON : 1,
	TYPE_BIN  : 2,
	CODE_LEN  : 4,
	TYPE_LEN  : 2,
	DATA_LEM  : 10,
	TOTAL_LEN : 24
}

/* error message list */
var err_msg_list = {
	ERROR_MSG_URL_ILLEGAL     : 'The requested URL has an error.',
	ERROR_MSG_AUTH_FAILED     : 'Authentication failed.',
	ERROR_MSG_REQ_NOT_ALLOWED : 'The request has not been allowed.',
	ERROR_MSG_METHOD_FAILED   : 'The request has an error.',
	ERROR_MSG_REQ_SEND        : 'An error occurred while sending the request.',
	ERROR_MSG_REQ_PROCESSED   : 'An error occurred while processing the request.',
	ERROR_MSG_RES_ANALYZE     : 'An error occurred while analyzing the response data.',
	ERROR_MSG_REQ_BUSY        : 'api is busy.cannot be accepted.'
}

/* user info modify */
var user_info_modify = {
	USR_INF_IP         : 0,
	USR_INF_AUTH       : 1,
	USR_INF_TRIAL      : 2,
	USR_INF_LASTTIME   : 3,
	USR_INF_REJECTTIME : 4,
	USR_INF_PERMISSION : 5
}

/* user permissions */
var user_permissions = {
	RSTAUTH_AUTH_STATUS_NORMAL_OK	: 10,
	RSTAUTH_AUTH_STATUS_REF_OK		: 11,
	RSTAUTH_AUTH_STATUS_OPE_OK		: 12,
	RSTAUTH_AUTH_STATUS_NG			: 90,
	RSTAUTH_IP_STATUS_NG			: 91,
	RSTAUTH_INTERNAL_ERR			: 99
}

/* exports */
exports.method_list = method_list;
exports.reqcode_list = reqcode_list;
exports.url_type_list = url_type_list;
exports.url_param_num_list = url_param_num_list;
exports.url_act_list = url_act_list;
exports.res_mode_list = res_mode_list;
exports.exitcode_list = exitcode_list;
exports.bool_value = bool_value;
exports.flag_value = flag_value;
exports.req_head_fmt = req_head_fmt;
exports.err_msg_list = err_msg_list;
exports.user_info_modify = user_info_modify;
exports.user_permissions = user_permissions;

