#!/bin/sh
##
#	Push/Pull Script
##

MALLOC_CHECK_=0;export MALLOC_CHECK_

##	functions

##
#	Collect
##
dnld_collect ()
{
	#  change archive directory
	cd ${opath}

	#  decide processing type
	case $type in 
	conf )
		cp -fp /opt/nec/clusterpro/etc/clp.conf . >/dev/null 2>&1
		cp -frp /opt/nec/clusterpro/scripts . >/dev/null 2>&1
		;;
	scr )
		;;
	lcns )
		cp -frp /opt/nec/clusterpro/license/${varpath}/* . >/dev/null 2>&1
		;;
	replaceconf)
		if [ ! -f /opt/nec/clusterpro/etc/config/clp.conf ];
		then
			#  create dummy conf
			echo "<?xml version=\"1.0\"?>" > /opt/nec/clusterpro/etc/config/clp.conf 2>&1
			echo "<root>" >> /opt/nec/clusterpro/etc/config/clp.conf 2>&1
			echo "        <dummyconf>1</dummyconf>" >> /opt/nec/clusterpro/etc/config/clp.conf 2>&1
			echo "</root>" >> /opt/nec/clusterpro/etc/config/clp.conf 2>&1
			chmod 600 /opt/nec/clusterpro/etc/config/clp.conf >/dev/null 2>&1
		fi
		#  copy
		cp -f /opt/nec/clusterpro/etc/config/clp.conf /opt/nec/clusterpro/etc/clp.conf.rep >/dev/null 2>&1
		chmod 600 /opt/nec/clusterpro/etc/clp.conf.rep >/dev/null 2>&1
		return 0
		;;
	lcnsrebuild)
		cp -frp /opt/nec/clusterpro/license/x50/inactive/* . >/dev/null 2>&1
		;;
	* )
		return 9
		;;
	esac

	#  create archive

	if [ "${os}" = "SunOS" ]; then
		tar -cf "${opath}/tmp.tar" * >/dev/null 2>&1
		[ $? -ne 0 ] && { return 255; }
		gzip -c "${opath}/tmp.tar" > "${opath}/${fname}"
		[ $? -ne 0 ] && { return 255; }
		rm -f "${opath}/tmp.tar" >/dev/null 2>&1
	else
		tar -zcf "${opath}/${fname}" * >/dev/null 2>&1
		[ $? -ne 0 ] && { return 255; }
	fi

	return 0
}

##
#	Delivery
##
dnld_delivery ()
{
	#  change extract directory
	cd "${opath}"

	#  extract
	if [ "${os}" = "SunOS" ]; then
		gzip -d "${ipath}/${fname}" >/dev/null 2>&1
		[ $? -ne 0 ] && { return 252; }
		fname=`echo ${fname} | cut -d. -f1,2`
		tar -xf "${ipath}/${fname}" >/dev/null 2>&1
		[ $? -ne 0 ] && { return 254; }
	else
		tar -zxf "${ipath}/${fname}" >/dev/null 2>&1
		[ $? -ne 0 ] && { return 254; }
	fi

	# clp.conf backup directory
	bkupdir="/opt/nec/clusterpro/etc/confbkup"
	if [ ! -e ${bkupdir} ]; then
		mkdir ${bkupdir} >/dev/null 2>&1
	fi

	#  remove archive
	rm -f "${ipath}/${fname}" >/dev/null 2>&1

	#  decide processing type
	case $type in 
	conf )
		#  copy
		if [ "${commode}" = "dpush" ]; then
			cp -fp ./clp.conf /opt/nec/clusterpro${wcfpath}>/dev/null 2>&1
			cp -frp ./scripts /opt/nec/clusterpro${wcfpath}>/dev/null 2>&1
		else
			cp -fp ./clp.conf /opt/nec/clusterpro/etc>/dev/null 2>&1
			cp -frp ./scripts /opt/nec/clusterpro>/dev/null 2>&1
		fi

		count=10
		# remove oldest clp.conf backup
		rm -f ${bkupdir}/*.pre$((count-2)) >/dev/null 2>&1

		while [ ${count} -gt 0 ]
		do
			fcnt=`expr ${count} - 2`
			precnt=`expr ${fcnt} - 1`

			if [ ${count} = 1 ]
			then
				if ls ${bkupdir}/*_clp.conf.cur >/dev/null 2>&1
				then
					rm -f ${bkupdir}/*.cur >/dev/null 2>&1
				fi
			elif [ ${count} = 2 ]
			then
				if ls ${bkupdir}/*_clp.conf.cur >/dev/null 2>&1
				then
					filename=`basename ${bkupdir}/*_clp.conf.cur _clp.conf.cur`
					mv "${bkupdir}/${filename}_clp.conf.cur" "${bkupdir}/${filename}_clp.conf.pre"
				fi
			elif [ ${count} = 3 ]
			then
				if ls ${bkupdir}/*_clp.conf.pre >/dev/null 2>&1
				then
					filename=`basename ${bkupdir}/*_clp.conf.pre _clp.conf.pre`
					mv "${bkupdir}/${filename}_clp.conf.pre" "${bkupdir}/${filename}_clp.conf.pre${fcnt}"
				fi
			else
				if ls ${bkupdir}/*_clp.conf.pre${precnt} >/dev/null 2>&1
				then
					filename=`basename ${bkupdir}/*_clp.conf.pre${precnt} _clp.conf.pre${precnt}`
					mv "${bkupdir}/${filename}_clp.conf.pre${precnt}" "${bkupdir}/${filename}_clp.conf.pre${fcnt}"
				fi
			fi

			count=`expr ${count} - 1`
		done

		# clp.conf backup
		datetime=`date '+%Y%m%d%H%M%S'`
		cp -fp ./clp.conf ${bkupdir}/${datetime}_clp.conf.cur >/dev/null 2>&1
		;;
	scr )
		;;
	lcns )
		if [ ! -d /opt/nec/clusterpro/license/${varpath} ];
		then
			mkdir -m 0755 /opt/nec/clusterpro/license/${varpath} >/dev/null 2>&1
			[ $? -ne 0 ] && { return 253; }
		fi
		#  copy
		cp -fp ./* /opt/nec/clusterpro/license/${varpath}/>/dev/null 2>&1
		;;
	lcnsrebuild)
		rm -rf /opt/nec/clusterpro/license/x50/inactive/* >/dev/null 2>&1
		;;
	cfchk )
		#  extract archive(<work>/clp.conf)
		;;
	* )
		return 9
		;;
	esac

	return 0
}

##
#	Main
##

proc=""
type=""
opath=""
ipath=""
varpath=""
rotate=""
patern=""
fname=""
commode=""
wcfpath=""

os=`uname -s`

while getopts ":c:d:f:i:o:r:t:v:m:w:" opt;
do
	##	decide options
	case $opt in
	c )
		##	collect
		proc='c'
		type=$OPTARG
		;;
	d )
		##	delivery
		proc='d'
		type=$OPTARG
		;;
	f )
		##	archive name
		fname=$OPTARG
		;;
	i )
		##	target file
		ipath=$OPTARG
		;;
	o )
		##	archive dir
		opath=$OPTARG
		;;
	v )
		##	variable dir
		varpath=$OPTARG
		;;
	m )
		##	commit mode
		commode=$OPTARG
		;;
	w )
		##	work cfmgr dir
		wcfpath=$OPTARG
		;;
	\? )
		exit 9
		;;
	esac
done

shift `expr $OPTIND - 1`

###	check parameters
if [ $proc = 'c' ] && [ $type = 'replaceconf' ];
then
	opath='/opt/nec/clusterpro/etc/config'
else
	[ -z $proc ] && { exit 9; }
	[ -z $type ] && { exit 9; }
	[ -z $fname ] && { exit 9; }
	[ $proc = 'd' ] && [ -z $ipath ] && { exit 9; }
	[ -z $opath ] && { exit 9; }
fi

###	decide proccessing
if [ $proc = 'c' ];
then
	dnld_collect; ret=$?
	[ $ret -ne 0 ] && { exit 255; }
elif [ $proc = 'd' ];
then
	dnld_delivery; ret=$?
	[ $ret -ne 0 ] && { exit 255; }
else
	exit 9
fi
	
exit 0

