#!/bin/sh

##
#	Log Collect
##

##
#	create directory
##
logc_mkdir ()
{
	echo "`date '+%Y/%m/%d %H:%M:%S'`  Start make directory." >> ${tdir}/script.log 2>&1
	
	##	modules log
	if [ "${os}" = "SunOS" ]; then
		mkdir $1 >/dev/null 2>&1
	else
		mkdir $1 -m 755 >/dev/null 2>&1
	fi
	ret=$?
	
	echo "`date '+%Y/%m/%d %H:%M:%S'`  End make directory." >> ${tdir}/script.log 2>&1
	
	return ${ret}
}


##
#	collect cluster logs
##
logc_clp_collect ()
{
	echo "`date '+%Y/%m/%d %H:%M:%S'`  Start collect cluster logs." >> ${tdir}/script.log 2>&1
	
	cd ${clpinfopath}
	##	modules log
	if [ "${os}" = "SunOS" ]; then
		cp ${logpath}${ttype}.log* . >/dev/null 2>&1
		cp ${logpath}${ttype}.err* . >/dev/null 2>&1
	else
		cp -a ${logpath}${ttype}.log* . >/dev/null 2>&1
		cp -a ${logpath}${ttype}.err* . >/dev/null 2>&1
	fi
	##	rm log
	if [ "${os}" = "SunOS" ]; then
		cp ${logpath}/${rmtype}.log* . >/dev/null 2>&1
		cp ${logpath}/${rmtype}.err* . >/dev/null 2>&1
	else
		cp -a ${logpath}/${rmtype}.log* . >/dev/null 2>&1
		cp -a ${logpath}/${rmtype}.err* . >/dev/null 2>&1
	fi
	
	echo "`date '+%Y/%m/%d %H:%M:%S'`  End collect cluster logs." >> ${tdir}/script.log 2>&1
	
	return 0
}


##
#	collect conf file
##
logc_conf_collect ()
{
	echo "`date '+%Y/%m/%d %H:%M:%S'`  Start collect conf file." >> ${tdir}/script.log 2>&1
	
	cd ${confinfopath}
	##	config
	if [ "${os}" = "SunOS" ]; then
		cp ${confpath}${confname} . >/dev/null 2>&1
	else
		cp -ar ${confpath}${confname} . >/dev/null 2>&1
	fi
	
	echo "`date '+%Y/%m/%d %H:%M:%S'`  End collect conf file." >> ${tdir}/script.log 2>&1
	
	return 0
}


##
#	collect os information
##
logc_os_collect ()
{
	echo "`date '+%Y/%m/%d %H:%M:%S'`  Start collect os info." >> ${tdir}/script.log 2>&1
	
	cd ${osinfopath}
	if [ "${os}" = "SunOS" ]; then
		##	cluster process status
		ps -eao user,pid,ppid,pcpu,pmem,vsz,rss,tty,s,stime,time,pri,nice,args | sort | grep -v grep >ps.result 2>&1
		
		##	cluster ps(thread) status
		ps -eLf >ps_th 2>&1
		
		##	messages
		cp /var/log/syslog* . >/dev/null 2>&1
		
	else
		##	cluster process status
		ps -eaw -ouser,pid,ppid,%cpu,%mem,vsz,rss,tty,stat,stime,cputime,priority,nice,cmd --sort pid | grep -v grep >ps 2>&1
		
		##	cluster ps(thread) status
		ps -eLf >ps_th 2>&1
		
		##	messages
		cp -a /var/log/syslog* . >/dev/null 2>&1
		
		##	top
		top -b -n 2 >top 2>&1
	fi
	
	echo "`date '+%Y/%m/%d %H:%M:%S'`  End collect os info." >> ${tdir}/script.log 2>&1
	
	return
}


##
#	execute monitor
##
logc_exec_mon ()
{
	echo "`date '+%Y/%m/%d %H:%M:%S'`  Start execute collecting target info." >> ${tdir}/script.log 2>&1
	
	if [ -z "${tpid}" ]; then
		##	cluster ps(thread) status
		${execpath}clp_${ttype} --collect -n ${tname} -d ${tdir}
		ret=$?
	else
		##	cluster ps(thread) status
		${execpath}clp_${ttype} --collect -n ${tname} -d ${tdir} -p ${tpid}
		ret=$?
	fi
	
	echo "`date '+%Y/%m/%d %H:%M:%S'`  End execute collecting target info." >> ${tdir}/script.log 2>&1
	
	return ${ret}
}


##
#	main
##

ttype=""
tname=""
tdir=""
tpid=""
execpath="/opt/nec/clusterpro/bin/"
confpath="/opt/nec/clusterpro/etc/"
rmtype="rm"
confname="clp.conf"

logpath=`/opt/nec/clusterpro/bin/clplogcf -p`
if [ $? -ne 0 ]; then
	logpath="/opt/nec/clusterpro/log/"
fi

os=`uname -s`


while getopts ":t:n:d:p:" opt;
do
	case $opt in
	t )
		ttype=$OPTARG
		;;
	n )
		tname=$OPTARG
		;;
	d )
		tdir=$OPTARG
		;;
	p )
		tpid=$OPTARG
		;;
	\? )
		exit 9
		;;
	esac

done

shift `expr $OPTIND - 1`

## parameter check
if [ -z "${ttype}" -o  -z "${tname}" -o -z "${tdir}" ]; then
	exit 244
fi

osinfopath="${tdir}"
clpinfopath="${tdir}/log"
confinfopath="${tdir}/etc"

## start date
echo "`date '+%Y/%m/%d %H:%M:%S'`  ### Start script ###" >> ${tdir}/script.log 2>&1


## os log collect
## get os information
logc_os_collect


##	execute monitor
logc_exec_mon
ret=$?
if [ $ret -ne 0 ]
then
	## end date
	echo "`date '+%Y/%m/%d %H:%M:%S'`  ### End script (ret=${ret}) ###" >> ${tdir}/script.log 2>&1
fi

## cluster log collect
logc_mkdir ${clpinfopath}
if [ $? -eq 0 ]
then
	## cluster log collect
	logc_clp_collect
fi

## conf file collect
logc_mkdir ${confinfopath}
if [ $? -eq 0 ]
then
	## conf file collect
	logc_conf_collect
fi

## end date
echo "`date '+%Y/%m/%d %H:%M:%S'`  ### End script (ret=${ret}) ###" >> ${tdir}/script.log 2>&1
exit 0

