#!/bin/sh

##
#	Core Collect Script
##

##	Trnsv calls this script.
##
#	send core files to CLP log directory.
##
pattern=$(cat /proc/sys/kernel/core_pattern | awk '{ print $1 }')
iscommand=$(echo $pattern | grep ^\|)
echo $pattern

##  In case that core files are outputted by a command,
##  core_pattern starts with |.
if [ -z "$iscommand" ]; then
    ##  Core files are outputted to an absolute path.
    exit 0
else
    ##  Core files are outputted by a command.
    command=$(echo $pattern | awk -F "/" '{ print $NF }')
    if [ $command = "systemd-coredump" ]; then
        coreList=`find /var/lib/systemd/coredump/core.clp* -type f 2>/dev/null`
        for corePath in $coreList; do
            fileName=$(basename $corePath)
            if [ ! -e /opt/nec/clusterpro/log/$fileName ]; then
                cp -n $corePath /opt/nec/clusterpro/log
                echo $corePath
            fi
        done
        
        exit 0
    else
        ##  Other commands
        exit 0
    fi
fi