#!/bin/sh

# set JAVA_HOME
JAVA_HOME=
umask 022

CLPJRASVC=clpjrasvc
UBUNTUFILE=/etc/os-release
TURBOFILE=/etc/turbolinux-release

OS=`uname -s`
if [ ${OS} = 'Linux' ]; then
    keyword=
    if [ -f ${UBUNTUFILE} ]; then
        keyword=`cat ${UBUNTUFILE} | grep -i Ubuntu`
        if [ -n "${keyword}" ]; then
            OS="UbuOrTur"
        fi
    fi
    keyword=
    if [ -f ${TURBOFILE} ];then
        keyword=`cat ${TURBOFILE} | grep -i Turbolinux`
        if [ -n "${keyword}" ]; then
            OS="UbuOrTur"
        fi
    fi
fi

## define the commands
if [ ${OS} = 'Linux' ]; then
    RM=`which --skip-alias rm`
    PS=`which --skip-alias ps`
    GREP=`which --skip-alias grep`
    KILL=`which --skip-alias kill`
    AWK=`which --skip-alias awk`
    SED=`which --skip-alias sed`
    DIRNAME=`which --skip-alias dirname`
    MV=`which --skip-alias mv`
elif [ ${OS} = 'UbuOrTur' ]; then
    RM=`which -a rm`
    PS=`which -a ps`
    GREP=`which -a grep`
    KILL=`which -a kill | head -1`
    AWK=`which -a awk | head -1`
    SED=`which -a sed`
    DIRNAME=`which -a dirname`
    MV=`which -a mv`
elif [ ${OS} = 'SunOS' ]; then
    RM=/usr/bin/rm
    PS=/usr/bin/ps
    GREP=/usr/xpg4/bin/grep
    KILL=/usr/bin/kill
    AWK=/usr/bin/awk
    SED=/usr/bin/sed
    PARGS=/usr/bin/pargs
    DIRNAME=/usr/bin/dirname
    MV=/usr/bin/mv
fi
JRA_BIN=`${DIRNAME} $0`
JRA_HOME=`cd ${JRA_BIN}; cd ..; pwd`
CLP_HOME=`cd ${JRA_HOME}; cd ../..; pwd`
LOG_FILE=${CLP_HOME}/log/ha/jra/std_main.log

MONF=${JRA_HOME}/tmp/*_mon
RUNF=${JRA_HOME}/tmp/*_run
CONFFILEPATH=${JRA_HOME}/conf

# messages
msg_Usage="Usage : clpjra_main.sh {start | stop}."
msg_notFound="clpjrasvc is not running."
msg_kill()
{
  echo "kill clpjrasvc PID(${jvmsaver_pid})."
}
####
# launch_jvmsaver
####
launch_jvmsaver()
{
  # delete monitor file & running file
  ${RM} -f ${MONF}
  ${RM} -f ${RUNF}

  OPTIONS=

  OPT_XMX=`${JRA_HOME}/bin/clpjra_getenv /root/jra/javaopt/xmx`
  OPT_EX=`${JRA_HOME}/bin/clpjra_getenv /root/jra/javaopt/javaoptex`
  OPT_EX=`echo ${OPT_EX} | ${SED} 's/-Xmx[^ ]*//g'`
  if [ ${OPT_XMX} -lt 1 -o ${OPT_XMX} -gt 4096 ]; then
    OPT_XMX=16
  fi

if [ ${OS} = 'SunOS' ]; then
    OPTIONS="${OPTIONS} -Xss256K -Xmx${OPT_XMX}M -XX:-UseVMInterruptibleIO"
    if [ -f ${JRA_HOME}/lib/libhajvmagent_32.so ];then
		if [ -d `${JRA_HOME}/bin/clpjra_getenv`/jre/lib/i386/server ];then
        	LD_LIBRARY_PATH=`${JRA_HOME}/bin/clpjra_getenv`/jre/lib/i386/server:${LD_LIBRARY_PATH}
		elif [ -d `${JRA_HOME}/bin/clpjra_getenv`/lib/i386/server ];then
        	LD_LIBRARY_PATH=`${JRA_HOME}/bin/clpjra_getenv`/lib/i386/server:${LD_LIBRARY_PATH}
		fi
    fi
else
	if [ `echo ${OPT_EX} | ${GREP} -ce "-Xss"` -eq 0 ]; then
		OPTIONS="${OPTIONS} -Xss256K"
	fi
    OPTIONS="${OPTIONS} -Xmx${OPT_XMX}M ${OPT_EX}"
fi

if [ ${OS} = 'HP-UX' ]; then
    OPTIONS="${OPTIONS} -XX:+UseGetTimeOfDay"
fi

if [ -s "${LOG_FILE}" ]; then
  test -f "${LOG_FILE}.8" && ${MV} -f ${LOG_FILE}.8 ${LOG_FILE}.9
  test -f "${LOG_FILE}.7" && ${MV} -f ${LOG_FILE}.7 ${LOG_FILE}.8
  test -f "${LOG_FILE}.6" && ${MV} -f ${LOG_FILE}.6 ${LOG_FILE}.7
  test -f "${LOG_FILE}.5" && ${MV} -f ${LOG_FILE}.5 ${LOG_FILE}.6
  test -f "${LOG_FILE}.4" && ${MV} -f ${LOG_FILE}.4 ${LOG_FILE}.5
  test -f "${LOG_FILE}.3" && ${MV} -f ${LOG_FILE}.3 ${LOG_FILE}.4
  test -f "${LOG_FILE}.2" && ${MV} -f ${LOG_FILE}.2 ${LOG_FILE}.3
  test -f "${LOG_FILE}.1" && ${MV} -f ${LOG_FILE}.1 ${LOG_FILE}.2
  test -f "${LOG_FILE}" && ${MV} -f ${LOG_FILE} ${LOG_FILE}.1
fi
date +"%Y/%m/%d %k:%M:%S" >> ${LOG_FILE}
JAVA_HOME=`${JRA_HOME}/bin/clpjra_getenv`; export JAVA_HOME
echo JAVA_HOME=${JAVA_HOME} >> ${LOG_FILE}

  /bin/sh -x <<EOF
     cd ${JRA_HOME}/bin
     export JAVA_HOME
     export LD_LIBRARY_PATH
     ${JRA_HOME}/bin/${CLPJRASVC} ${OPTIONS} >> ${LOG_FILE} 2>&1 < /dev/null &
EOF
}



####
# main
####

case $1 in
'start')
LD_LIBRARY_PATH=${JRA_HOME}/lib:${LD_LIBRARY_PATH}; export LD_LIBRARY_PATH
launch_jvmsaver
;;

'stop')
#kill startup script
jvmsaver_pid=`${PS} -ef | ${GREP} "${CLPJRASVC}" | ${GREP} -v "${GREP}" | ${AWK} '{print $2}'`
if [ -n "${jvmsaver_pid}" ]; then
    msg_kill
    ${KILL} -TERM ${jvmsaver_pid}
else
    echo ${msg_notFound}
fi
;;

*)
  echo ${msg_Usage} ;;
esac
exit 0
