#!/bin/sh
#

msg_001()
{
  echo "Usage: clpjra_lbsetup.sh -e Enabled -i JVMSaverCheckInterval -t ActionTimeout"
  echo "Enabled              : APServer load balancer ON/OFF  (0:OFF,1:ON)"
  echo "JVMSaverCheckInterval: APServer load balancer time interval sec"
  echo "ActionTimeout        : APServer load balancer timeout sec"
}
msg_002()
{
  echo "Please install iplb4wd"
}
msg_003()
{
  echo "Failed to make ${CONFFILE}"
}
msg_004()
{
  echo "Failed to make ${CONFFILETMP}"
}
msg_005()
{
  echo "Write error in ${CONFFILE}"
}
msg_006()
{
  echo "Finish clpjra_lbsetup.sh"
}
msg_007()
{
  echo "uname command error"
}
msg_008()
{
  echo "Invalid conf file syntax"
}
msg_009()
{
  echo "OS not supported"
}
msg_010()
{
  echo "which command error"
}

OS=`uname -s`
if [ $? -ne 0 ]; then
   msg_007
   exit 1;
fi

which which  > /dev/null
if [ $? -ne 0 ]; then
   msg_010
   exit 1;
fi

## define the commands
if [ ${OS} = 'Linux' ]; then
   CP=`which --skip-alias cp`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
   RM=`which --skip-alias rm`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
   MV=`which --skip-alias mv`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
   SED=`which --skip-alias sed`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
   GREP=`which --skip-alias grep`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
   TOUCH=`which --skip-alias touch`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
   EXPR=`which --skip-alias expr`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
   DIRNAME=`which --skip-alias dirname`
   if [ $? -ne 0 ]; then
     msg_010
     exit 1;
   fi
elif [ ${OS} = 'SunOS' ]; then
   CP=/usr/bin/cp
   RM=/usr/bin/rm
   MV=/usr/bin/mv
   SED=/usr/bin/sed
   GREP=/usr/xpg4/bin/grep
   TOUCH=/usr/bin/touch
   EXPR=/usr/bin/expr
   DIRNAME=/usr/bin/dirname
else
   msg_009
   exit 1;
fi

JRA_HOME=$(cd `${DIRNAME} $0`; cd ..; pwd)
DDIR=/etc/ha4.d
SERVICEFILE=/etc/rc.d/init.d/lbhost4d
CONFFILE=${DDIR}/lbadmin.conf
CONFFILETMP=${DDIR}/lbadmin_tmp.conf
LBADMIN=${JRA_HOME}/bin/clpjra_lbadmin.sh


E_FLG=0
I_FLG=0
T_FLG=0


create_file_check()
{
  if [ $? -ne 0 ]; then
     msg_005
     exit 1;
  fi
}

change_file_check()
{
  if [ $? -ne 0 ]; then
     msg_005
     ${RM} -rf ${CONFFILE}
     ${MV} ${CONFFILETMP} ${CONFFILE}
     exit 1;
  fi
}

create_file()
{
  if [ -d ${CONFFILE} ]; then
     ${RM} -rf ${CONFFILE}
  fi
  ${TOUCH} ${CONFFILE}
  if [ $? -ne 0 ]; then
     return 1
  fi
  echo "Enabled=0" >> ${CONFFILE}
  create_file_check
  echo "JVMSaverCheckInterval=120" >> ${CONFFILE}
  create_file_check
  echo "ActionTimeout=1800" >> ${CONFFILE}
  create_file_check
  echo "CommandPath=" >> ${CONFFILE}
  create_file_check
  echo "" >> ${CONFFILE}
  create_file_check
  return 0
}

# install check
if [ ! -f ${SERVICEFILE} ]; then
    msg_002
    exit 1;
fi
# option check
if [ $# -ne 6 ]; then
    msg_001
    exit 1;
fi
# option analize
while getopts e:i:t: opt
do
    case ${opt} in
    e)
      NUMERIC_CHECK=`echo "${OPTARG}" | awk '/[^0-9]/ {print}'`
      if [ -z ${NUMERIC_CHECK} ]; then
          if [ ${OPTARG} -ge 0 -a ${OPTARG} -le 1 ]; then
              ENABLED=${OPTARG}
              E_FLG=`${EXPR} ${E_FLG} + 1`
          fi
      fi
      ;;
    i)
      NUMERIC_CHECK=`echo "${OPTARG}" | awk '/[^0-9]/ {print}'`
      if [ -z ${NUMERIC_CHECK} ]; then
          if [ ${OPTARG} -ge 1 -a ${OPTARG} -le 2147483646 ]; then
              INTERVAL=${OPTARG}
              I_FLG=`${EXPR} ${I_FLG} + 1`
          fi
      fi
      ;;
    t)
      NUMERIC_CHECK=`echo "${OPTARG}" | awk '/[^0-9]/ {print}'`
      if [ -z ${NUMERIC_CHECK} ]; then
          if [ ${OPTARG} -ge 0 -a ${OPTARG} -le 2147483646 ]; then
              TIMEOUT=${OPTARG}
              T_FLG=`${EXPR} ${T_FLG} + 1`
          fi
      fi
      ;;
    \?)
      msg_001
      exit 1;;
    esac
done
if [ ${E_FLG} -ne 1 -o ${I_FLG} -ne 1 -o ${T_FLG} -ne 1 ]; then
    msg_001
    exit 1;
fi

if [ ! -f ${CONFFILE} ]; then
    create_file
    if [ $? -ne 0 ]; then
         msg_003
         exit 1;
    fi
else
    ${GREP} Enabled ${CONFFILE} > /dev/null && ${GREP} ActionTimeout ${CONFFILE} > /dev/null && ${GREP} JVMSaverCheckInterval ${CONFFILE} > /dev/null && ${GREP} CommandPath ${CONFFILE} > /dev/null
    if [ $? -ne 0 ];then
         msg_008
         exit 1;
    fi
fi

${CP} ${CONFFILE} ${CONFFILETMP}
if [ $? -ne 0 ]; then
    msg_004
    exit 1;
fi

# set trap for SIGHUP, SIGINT and SIGTERM
trap '${RM} -rf ${CONFFILE}; ${MV} ${CONFFILETMP} ${CONFFILE}; exit 1' 1 2 15

${SED} -i "s[Enabled.*=.*[Enabled=${ENABLED}[g" ${CONFFILE}
change_file_check
${SED} -i "s[JVMSaverCheckInterval.*=.*[JVMSaverCheckInterval=${INTERVAL}[g" ${CONFFILE}
change_file_check
${SED} -i "s[ActionTimeout.*=.*[ActionTimeout=${TIMEOUT}[g" ${CONFFILE}
change_file_check
${SED} -i "s[CommandPath.*=.*[CommandPath=${LBADMIN} weight[g" ${CONFFILE}
change_file_check

trap 1 2 15

${RM} -rf ${CONFFILETMP}

msg_006

exit 0
