#!/bin/sh
#
MSG_WRONG_JAVA_HOME="Please set correct JAVA_HOME."
MSG_NO_JAVA_HOME="JAVA_HOME must be define.Please run setup.sh"

JRA_BIN=`dirname $0`
JRA_HOME=`cd ${JRA_BIN}; cd ..; pwd`

CONF_DIR=${JRA_HOME}/conf
BIN_DIR=${JRA_HOME}/bin
LB_JAR_FILE=${BIN_DIR}/lbadmin.jar
JVM_JAR_FILE=${BIN_DIR}/clpjramain.jar

JAVA_HOME=`${JRA_HOME}/bin/clpjra_getenv`

if [ "${JAVA_HOME}" = "" ] ; then
    echo ${MSG_NO_JAVA_HOME}
    exit 1
fi

if [ ! -f ${JAVA_HOME}/bin/java ] ; then
    echo ${MSG_WRONG_JAVA_HOME}
    exit 1
fi

export LD_LIBRARY_PATH=${JRA_HOME}/lib

${JAVA_HOME}/bin/java -cp ${LB_JAR_FILE}:${JVM_JAR_FILE} com.nec.jp.ha.jvmsaver.lbadmin.LbAdminMain ${JRA_HOME} $*

exit $?

