#!/bin/sh

##
#	Log Collect Script
##

#export  MALLOC_CHECK_=0

##	internal functions
##
#	get file size of default collection
##
logc_get_default_size ()
{
	##	shared memory dump
	clpstat -d >/dev/null 2>&1

	if [ "${os}" = "SunOS" ]; then
		##	modules log and shared memory dump
		for flsz in `find ${logpath} -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done

		##	alert log
		for flsz in `find /opt/nec/clusterpro/alert/log -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	else
		##	modules log and shared memory dump
		for flsz in `find ${logpath} -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done

		##	alert log
		for flsz in `find /opt/nec/clusterpro/alert/log -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	fi

	##	other file's margin (1MB)
	flsz_tt=`expr "${flsz_tt}" + "1000000"`

	#echo ${flsz_tt}

	return
}

##
#	get file size of syslog collection 
##
logc_get_syslog_size ()
{
	inx=0

	if [ "${os}" = "SunOS" ]; then
		##	decide rotate
		if [ $rotate -eq 0 ];
		then
			##	all
			for flsz in `find ${mesgpath}* -type f -ls | awk '{print $7}' 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			done
		elif [ $rotate -eq 1 ];
		then
			##	current
			for flsz in `find ${mesgpath} -type f -ls | awk '{print $7}' 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			done
		else
			##	current
			for flsz in `find ${mesgpath} -type f -ls | awk '{print $7}' 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			done

			##	specified rotate
			for flname in `ls -t ${mesgpath}* 2>&-`
			do
				if [ ${flname} = ${mesgpath} ]
				then
					continue;
				fi
				
				inx=`expr "${inx}" + 1`
				[ ${inx} -gt `expr $rotate - 1` ] && { return; }
				for flsz in `find ${flname} -type f -ls | awk '{print $7}' 2>&-`
				do
					flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
				done
			done
		fi
	else
		##	decide rotate
		if [ $rotate -eq 0 ];
		then
			##	all
			for flsz in `find ${mesgpath}* -type f -printf "%s\n" 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			done
		elif [ $rotate -eq 1 ];
		then
			##	current
			for flsz in `find ${mesgpath} -type f -printf "%s\n" 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			done
		else
			##	current
			for flsz in `find ${mesgpath} -type f -printf "%s\n" 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			done

			##	specified rotate
			for flname in `ls -t ${mesgpath}* 2>&-`
			do
				if [ ${flname} = ${mesgpath} ]
				then
					continue;
				fi
				
				inx=`expr "${inx}" + 1`
				[ ${inx} -gt `expr $rotate - 1` ] && { return; }
				for flsz in `find ${flname} -type f -printf "%s\n" 2>&-`
				do
					flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
				done
			done
		fi

		##	journal log
		if [ -e ${journalnpath} ]
		then
			flsz=`find ${journalnpath} -type f -ls | awk '{print $7}' 2>&-`
			if [ $flsz -lt 30000000 ]
			then
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			else
				flsz_tt=`expr "${flsz_tt}" + "1000000"`
			fi
		elif [ -e ${journalpath} ]
		then
			flsz=`find ${journalpath} -type f -ls | awk '{print $7}' 2>&-`
			if [ $flsz  -lt 30000000 ]
			then
				flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
			else
				flsz_tt=`expr "${flsz_tt}" + "1000000"`
			fi
		fi
	fi
	#echo ${flsz_tt}

	return
}

##
#	get file size of core collection 
##
logc_get_core_size ()
{
	if [ "${os}" = "SunOS" ]; then
		##	cluster module core
		for flsz in `find /opt/nec/clusterpro/bin/core* -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}" / 10`
		done

		##	alert module core
		if [ -d /opt/nec/clusterpro/alert/bin ];then
			for flsz in `find /opt/nec/clusterpro/alert/bin/core* -type f -ls | awk '{print $7}' 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}" / 10`
			done
		fi

		##	webmgr module core
		if [ -d /opt/nec/clusterpro/webmgr/bin ];then
			for flsz in `find /opt/nec/clusterpro/webmgr/bin/core* -type f -ls | awk '{print $7}' 2>&-`
			do
				flsz_tt=`expr "${flsz_tt}" + "${flsz}" / 10`
			done
		fi
	else
		##	cluster module core
		for flsz in `find /opt/nec/clusterpro/bin/core* -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}" / 10`
		done

		##	alert module core
		for flsz in `find /opt/nec/clusterpro/alert/bin/core* -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}" / 10`
		done

		##	webmgr module core
		for flsz in `find /opt/nec/clusterpro/webmgr/bin/core* -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}" / 10`
		done
	fi

	#echo ${flsz_tt}

	return
}

##
#	get file size of os collection
##
logc_get_os_size ()
{
	##	file margin (1MB)
	flsz_tt=`expr "${flsz_tt}" + 1000000`
	#echo ${flsz_tt}

	return
}

##
#	get file size of scripts collection
##
logc_get_scripts_size ()
{
	if [ "${os}" = "SunOS" ]; then
		## scripts
		for flsz in `find /opt/nec/clusterpro/scripts -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	else
		## scripts
		for flsz in `find /opt/nec/clusterpro/scripts -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	fi

	#echo ${flsz_tt}

	return
}

##
#	get file size of esmpro/ac collection
##
logc_get_esmpro_size ()
{
	##	file margin (5MB)
	flsz_tt=`expr "${flsz_tt}" + "5000000"`
	#echo ${flsz_tt}

	return
}

##
#	get file size of ha information
##
logc_get_ha_size ()
{
	if [ "${os}" = "SunOS" ]; then
		## sra info
		for flsz in `find /opt/nec/clusterpro/ha/sra/ -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
		## jra info
		for flsz in `find /opt/nec/clusterpro/ha/jra/bin/core* -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	else
		## sra info
		for flsz in `find /opt/nec/clusterpro/ha/sra/ -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
		## jra info
		for flsz in `find /opt/nec/clusterpro/ha/jra/bin/core* -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	fi

	#echo ${flsz_tt}

	return
}

##
#	get file size of mirror statistics information
##
logc_get_mirrorstatsinfo_size ()
{
	if [ "${os}" = "SunOS" ]; then
		## mirror stats info
		for flsz in `find /opt/nec/clusterpro/perf/disk/ -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	else
		## mirror stats info
		for flsz in `find /opt/nec/clusterpro/perf/disk/ -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	fi

	#echo ${flsz_tt}

	return
}

##
#	get file size of cluster statistics information
##
logc_get_clusterstatsinfo_size ()
{
	if [ "${os}" = "SunOS" ]; then
		## cluster stats info
		for flsz in `find /opt/nec/clusterpro/perf/cluster/ -type f -ls | awk '{print $7}' 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	else
		## cluster stats info
		for flsz in `find /opt/nec/clusterpro/perf/cluster/ -type f -printf "%s\n" 2>&-`
		do
			flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
		done
	fi

	#echo ${flsz_tt}

	return
}

##
#	get file size of system statistics information
##
logc_get_systemstatsinfo_size ()
{
	
	## system stats info
	for flsz in `find /opt/nec/clusterpro/perf/system/ -type f -printf "%s\n" 2>&-`
	do
		flsz_tt=`expr "${flsz_tt}" + "${flsz}"`
	done
	
	#echo ${flsz_tt}

	return
}


##
#	get file size of archive
##
logc_get_archive_size ()
{
	##	file margin (1/10)
	[ ${flsz_tt} -gt 0 ] && { flsz_tt=`expr "${flsz_tt}" + "${flsz_tt}" / 10`; }
	#echo ${flsz_tt}

	return
}

##
#	collect default information
##
logc_collect_default ()
{
	echo -e "collecting default information......"

	[ ! -d log ] && { mkdir -m 0777 log >/dev/null 2>&1; }

	##	shared memory dump
	clpstat -d >/dev/null 2>&1

	##	date info
	clpstat --date >date.stat 2>&1

	##	local server info
	clpstat --local >stat.stat 2>&1

	##	modules log
	if [ "${os}" = "SunOS" ]; then
		cp -fp ${logpath}/* log >/dev/null 2>&1
		rm -f ${logpath}/dmp.cm ${logpath}/dmp.nm ${logpath}/dmp.rm ${logpath}/dmp.evt ${logpath}/dmp.osm ${logpath}/dmp.lcns ${logpath}/dmp.ibsv >/dev/null 2>&1
		##	module attribute
		ls -lt /opt/nec/clusterpro/bin >module.ls 2>&1

		##	alert module attribute
		ls -lt /opt/nec/clusterpro/alert/bin >>module.ls 2>&1

		##	webmgr module attribute
		ls -lt /opt/nec/clusterpro/webmgr/bin >>module.ls 2>&1

		##	mirror module attribute
		ls -lt /opt/nec/clusterpro/mirror/current/bin >>module.ls 2>&1

		##	ha(jra) module attribute
		ls -lt /opt/nec/clusterpro/ha/jra/bin >>module.ls 2>&1

		##	ha(sra) module attribute
		ls -lt /opt/nec/clusterpro/ha/sra/bin >>module.ls 2>&1

		##	cloud module attribute
		ls -ltR /opt/nec/clusterpro/cloud >>module.ls 2>&1

		##	library module attribute
		find /opt/nec/clusterpro/lib -type f -exec ls -l {} \; | sort -k 6 >module_lib.ls 2>&1
		find /opt/nec/clusterpro/mirror/current/lib -type f -exec ls -l {} \; | sort -k 6 >>module_lib.ls 2>&1
		ls -lt /opt/nec/clusterpro/ha/jra/lib >>module_lib.ls 2>&1
		ls -lt /opt/nec/clusterpro/ha/sra/lib >>module_lib.ls 2>&1
	else
		cp -afp ${logpath}/* log >/dev/null 2>&1
		rm -f ${logpath}/dmp.cm ${logpath}/dmp.nm ${logpath}/dmp.rm ${logpath}/dmp.evt ${logpath}/dmp.osm ${logpath}/dmp.lcns ${logpath}/dmp.ibsv >/dev/null 2>&1
		##	module attribute
		ls -lt --full-time /opt/nec/clusterpro/bin >module.ls 2>&1

		##	alert module attribute
		ls -lt --full-time /opt/nec/clusterpro/alert/bin >>module.ls 2>&1

		##	webmgr module attribute
		ls -lt --full-time /opt/nec/clusterpro/webmgr/bin >>module.ls 2>&1

		##	mirror module attribute
		ls -lt --full-time /opt/nec/clusterpro/mirror/current/bin >>module.ls 2>&1

		##	ha(jra) module attribute
		ls -lt --full-time /opt/nec/clusterpro/ha/jra/bin >>module.ls 2>&1

		##	ha(sra) module attribute
		ls -lt --full-time /opt/nec/clusterpro/ha/sra/bin >>module.ls 2>&1

		##	cloud module attribute
		ls -ltR --full-time /opt/nec/clusterpro/cloud >>module.ls 2>&1

		##	library module attribute
		#find /opt/nec/clusterpro/lib -type f -printf "0%m\t%1\t%u %g\t%s\t%t\t%p\t%F\n">./module_lib.ls 2>&1
		find /opt/nec/clusterpro/lib -type f -exec ls -l --full-time {} \; | sort -k 6 >module_lib.ls 2>&1
		find /opt/nec/clusterpro/mirror/current/lib -type f -exec ls -l --full-time {} \; | sort -k 6 >>module_lib.ls 2>&1
		ls -l --full-time /opt/nec/clusterpro/ha/jra/lib >>module_lib.ls 2>&1
		ls -l --full-time /opt/nec/clusterpro/ha/sra/lib >>module_lib.ls 2>&1
	fi

	##	drivers attribute
	### liscal 
	[ -d /opt/nec/clusterpro/drivers/md ] && { find /opt/nec/clusterpro/drivers/md \( -type l -o -type f \) -exec ls -l {} \; >mddrv.ls 2>&1; }
	### ka/khb
	if [ "${os}" = "SunOS" ]; then
		### ka/khb 
		[ -d /opt/nec/clusterpro/drivers/ka ] && {  ls -l /opt/nec/clusterpro/drivers/ka/distribution/current/ >kadrv.ls 2>&1; }
		[ -d /opt/nec/clusterpro/drivers/khb ] && {  ls -l /opt/nec/clusterpro/drivers/khb/distribution/current/ >khbdrv.ls 2>&1; }

		##	/usr/kernel/drv/
		ls -l /usr/kernel/drv/clp* >clpdrv.result 2>&1
		ls -l /usr/kernel/drv/amd64/clp* >>clpdrv.result 2>&1
	else
		### ka/khb 
		[ -d /opt/nec/clusterpro/drivers/ka ] && {  ls -l --full-time /opt/nec/clusterpro/drivers/ka/distribution/current/ >kadrv.ls 2>&1; }
		[ -d /opt/nec/clusterpro/drivers/khb ] && {  ls -l --full-time /opt/nec/clusterpro/drivers/khb/distribution/current/ >khbdrv.ls 2>&1; }
	fi

	##	version
	if [ "${os}" = "SunOS" ]; then
		pkginfo >pkg.ver 2>&1
		pkginfo -l NECclusterprosss >clp.ver 2>&1
		pkginfo -l SUNWGlib >glibc.ver 2>&1
		pkginfo -l SUNWlxml >libxml.ver 2>&1
	else
		rpm -qa >rpm.ver 2>&1
		dpkg -l >>rpm.ver 2>&1
		rpm -qi clusterprosss >clp.ver 2>&1
		rpm --verify clusterprosss >>clp.ver 2>&1
		dpkg -s clusterprosss >>clp.ver 2>&1
		rpm -qi glibc >glibc.ver 2>&1
		dpkg -s libc-bin >>glibc.ver 2>&1
		rpm -qi libxml2 >libxml2.ver 2>&1
		dpkg -s libxml2 >>libxml2.ver 2>&1
	fi

	##	update log
	if [ "${os}" = "SunOS" ]; then
		##	distributor
		cp -fp /etc/release . >/dev/null 2>&1
		cp -fp /etc/name_to_major . >/dev/null 2>&1
	else
		##	distributor
		cp -fp /etc/*-release . >/dev/null 2>&1

		##	loadable modules setting
		cp -fp /etc/modules.conf . >/dev/null 2>&1
		cp -fp /etc/modprobe.conf . >/dev/null 2>&1
	fi

	##	license
	cp -frp /opt/nec/clusterpro/license . >/dev/null 2>&1

	##	rcX.d
	if [ "${os}" != "SunOS" ]; then
		ls -l /etc/rc*.d/ >rc_list 2>&1
	fi

	##	config
	cp -frpL /opt/nec/clusterpro/etc . >/dev/null 2>&1
	cp -fp /opt/nec/clusterpro/webmgr/check_result.txt . >/dev/null  2>&1
	cp -fp /opt/nec/clusterpro/webmgr/check_result.txt.old . >/dev/null  2>&1

	##	cloud
	cp -frp /opt/nec/clusterpro/cloud cloud >/dev/null  2>&1

	##	alert
	if [ ! -d log/alt ];
	then
		mkdir -m 0777 -p log/alt >/dev/null 2>&1
		[ $? -ne 0 ] && { return 251; }
	fi
	cp -frp /opt/nec/clusterpro/alert/log/* log/alt >/dev/null 2>&1

	if [ "${os}" = "SunOS" ]; then
		##	core config
		coreadm >coreadm.result 2>&1

		##	process status
		ps -eao user,pid,ppid,pcpu,pmem,vsz,rss,tty,s,stime,time,pri,nice,args | sort | grep -v grep >ps.result 2>&1
	else
		##	kernel parameters
		sysctl -a >kernel.parm 2>&1

		##	process status
		ps -eaw -ouser,pid,ppid,%cpu,%mem,vsz,rss,tty,stat,stime,cputime,priority,nice,cmd --sort pid | grep -v grep >ps.result 2>&1
	fi

	##	thread status
	ps -eLf >ps_th.result 2>&1
	ps -eL auxww >>ps_th.result 2>&1

	##	IPC resource
	ipcs -a >ipcs 2>&1
	ipcs -t >>ipcs 2>&1
	ipcs -p >>ipcs 2>&1
	ipcs -c >>ipcs 2>&1
	if [ "${os}" != "SunOS" ]; then
		ipcs -l >>ipcs 2>&1
	fi

	##	network statistics
	netstat -in >netstat.if 2>&1
	netstat -apn >netstat.v4 2>&1
	netstat -gn >>netstat.v4 2>&1
	netstat -rn >>netstat.v4 2>&1
	if [ "${os}" != "SunOS" ]; then
		netstat --inet6 -apn >netstat.v6 2>&1
		netstat --inet6 -gn >>netstat.v6 2>&1
		netstat --inet6 -rn >>netstat.v6 2>&1
	fi
	##	network info
	if [ $? -ne 0 ]; then
		ss >ss 2>&1
		ss -nap >ss_nap 2>&1
	fi
	ip -s l >ip_opt_sl 2>&1

	if [ "${os}" = "SunOS" ]; then
		##	service for solaris
		svcs -pl clusterpro_evt > svcs.evt  2>&1
		svcs -pl clusterpro_trn > svcs.trn  2>&1
		svcs -pl clusterpro     > svcs.main 2>&1
		## svcs -pl clusterpro_md  > svcs.md 2>&1
		svcs -pl clusterpro_webmgr > svcs.webmgr 2>&1
		svcs -pl clusterpro_alertsync > svcs.alertsync 2>&1
		svcs -a > svcs.all  2>&1
	else
		##	pci device information
		lspci >lspci 2>&1

		##	chkconfig(clp)
		chkconfig --list | grep clusterpro >chkconfig.list 2>&1
		ls -l --full-time /etc/rc?.d/*clusterpro* >>chkconfig.list 2>&1
		ls -l --full-time /etc/init.d/rc?.d/*clusterpro* >>chkconfig.list 2>&1
		ls -l --full-time /etc/rc.d/rc?.d/*clusterpro* >>chkconfig.list 2>&1

		##	chkconfig(all)
		chkconfig --list >chkconfig-all.list 2>&1
		ls -l /etc/rc*/ >>chkconfig-all.list 2>&1
		initctl list >>chkconfig-all.list 2>&1

		##	systemctl(clp)
		ls -l --full-time /lib/systemd/system/*clusterpro* >unit.list 2>&1
		ls -l --full-time /usr/lib/systemd/system/*clusterpro* >>unit.list 2>&1

		##	systemctl(all)
		systemctl -t service >systemctl_svcstat 2>&1
		systemctl list-unit-files -t service >systemctl_svcconf 2>&1

		## for ubuntu
		ls /etc/rc*.d/ >chkconfig-allsrv 2>&1
	fi

	##	hosts
	cp -fp /etc/hosts . >/dev/null 2>&1

	if [ "${os}" = "SunOS" ]; then
		##	/etc/netmasks for solaris
		cp -fp /etc/netmasks . >/dev/null  2>&1
		##	/etc/dfs/dfstab for solaris
		cp -fp /etc/dfs/dfstab . >/dev/null 2>&1
	else
		##	exports
		cp -fp /etc/exports . >/dev/null 2>&1
	fi

	##	uname -a
	uname -a >uname 2>&1

	if [ "${os}" != "SunOS" ]; then
		##	ethtool (all network interfaces)
		while true;
		do
			read -r line;
			[ $? -ne 0 ] && { break; }
			[ -z `$(echo ${line} | grep '[^[:space:]]*:')` ] && { continue; }
			ethtool ${line%%:*} >>ethtool 2>&1
		done < /proc/net/dev
	fi

	##	reg
	cp -fpr /opt/nec/clusterpro/work/reg . >/dev/null 2>&1

	##	rm(detail log of monitor)
	cp -fpr ${dlogpath}rm . >/dev/null 2>&1

	##	exportfs -v
	exportfs -v >exportfs 2>&1

	##	terminal environment
	export >export 2>&1

	##	ulimit -a
	ulimit -a >ulimit 2>&1

	##	ZFS
	if [ "${os}" = "SunOS" ]; then
		zpool list >zpool_list 2>&1
		zpool iostat -v >zpool_iostat 2>&1
		zpool status -v >zpool_status 2>&1
		for key in `zpool list -H -o name`; do zpool get all $key; done >zpool_get_all 2>&1

		zfs list -r >zfs_list 2>&1
		zfs get all >zfs_get_all 2>&1
		zfs mount -v >zfs_mount 2>&1
	fi

	##	container
	if [ "${os}" = "SunOS" ]; then
		zoneadm list -civ >zoneadm_list 2>&1
		for key in `zoneadm list -ci`; do zonecfg -z $key info; done >zonecfg_info 2>&1
	fi

	##	OS locale
	locale >locale 2>&1

	if [ "${os}" = "SunOS" ]; then
		##	timezone
		env - date >date.env 2>&1

		##	ls -li work/ipc
		ls -li /opt/nec/clusterpro/work/ipc >ls.ipc 2>&1
	else
		##	language
		cp -fp /etc/sysconfig/i18n . >/dev/null 2>&1

		##	timezone
		env - date >date.env 2>&1
		#ls -la --full-time /etc/localtime >localtime.ls 2>&1
		#cp -aL /etc/localtime . >/dev/null 2>&1
		#ls -la --full-time /usr/share/zoneinfo >zoneinfo.ls 2>&1

		##	ls -li work/ipc
		ls -li --full-time /opt/nec/clusterpro/work/ipc >ls.ipc 2>&1
	fi

	##	work
	cp -frp /opt/nec/clusterpro/work/cfctrl . >/dev/null 2>&1
	cp -frp /opt/nec/clusterpro/work/reg . >/dev/null 2>&1
	cp -frp /opt/nec/clusterpro/work/cfmgr . >/dev/null 2>&1

	##	monitor option
	[ -f /opt/nec/clusterpro/bin/clplogopt.sh ] && { mkdir -m 0777 monopt >/dev/null 2>&1; /opt/nec/clusterpro/bin/clplogopt.sh -o `pwd`/monopt >/dev/null 2>&1; }

	return 0
}

##
#	collect cluster log
##
logc_collect_clslog ()
{
	return
}

##
#	collect syslog
##
logc_collect_syslog ()
{
	echo -e "collecting syslog......"

	inx=0

	##	rotate
	if [ $rotate -eq 0 ];
	then
		##	all rotate
		cp -fp ${mesgpath}* . >/dev/null 2>&1
	elif [ $rotate -eq 1 ];
	then
		##	current
		cp -fp ${mesgpath} . >/dev/null 2>&1
	else
		##	current
		cp -fp ${mesgpath} . >/dev/null 2>&1

		##	specify rotate
		for flname in `ls -t ${mesgpath}* 2>&-`
		do
			if [ ${flname} = ${mesgpath} ]
			then
				continue;
			fi
			
			inx=`expr "${inx}" + 1`
			[ ${inx} -gt `expr $rotate - 1` ] && { break; }
			[ -f ${flname} ] && { cp -fp ${flname} . >/dev/null 2>&1; }
		done
	fi

	if [ "${os}" != "SunOS" ]; then
		##	journal log
		ls -l ${journaldirpath} >journal_ls 2>&1
		cp -fp ${journalconfpath} . >/dev/null 2>&1 
		journalctl -u clusterpro_evt >journal.clp 2>&1

		ls ${journalnpath} > /dev/null 2>&1
		res=$?
		if [ $res -eq 0 ]
		then
			fsize=`find ${journalnpath} -type f -ls | awk '{print $7}' 2>&-`
			if [ $fsize -lt 30000000 ]
			then
				cp -fp ${journalnpath} . >/dev/null 2>&1
			else
				echo $fsize >journal.tail 2>&1
				journalctl -e >>journal.tail 2>&1
			fi
		else
			ls ${journalpath} > /dev/null 2>&1
			res=$?
			if [ $res -eq 0 ]
			then
				fsize=`find ${journalpath} -type f -ls | awk '{print $7}' 2>&-`
				if [ $fsize -lt 30000000 ]
				then
					cp -fp ${journalpath} . >/dev/null 2>&1
				else
					echo $fsize >journal.tail 2>&1
					journalctl -e >>journal.tail 2>&1
				fi
			fi
		fi
	fi

	return
}

##
#	collect core
##
logc_collect_core ()
{
	echo -e "collecting core......"

	seq=0
	arname=""
	taropt=""

	##	archive and replace core files

	if [ "${os}" = "SunOS" ]; then
		findcmd="find core*"
	else
		findcmd="find core* -type f -printf %f\n"
	fi

	echo ${findcmd}

	cd /opt/nec/clusterpro/bin; seq=0
	while true;
	do
		arname=cls`date '+%Y%m%d'`_${seq}
		[ ! -f ${logpath}/${arname}.tar ] && { break; }
		seq=`expr ${seq} + 1`
	done
	for fl in `$findcmd 2>&-`
	do
		taropt="--remove-files"
		if [ "${os}" = "SunOS" ]; then
			[ ! -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls -li core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list >/dev/null 2>&1; rm -f file.list >/dev/null 2>&1; }
			rslt=`file ${fl} | nawk '{ gsub("\x27", "\x20", $NF); print $NF }' | tr -d [:space:] | grep ^clp`
			[ -z "${rslt}" ] && { taropt=""; }
			tar -cf ${fl}.tar ${fl} >/dev/null 2>&1
			rm -f "${fl}"
			[ $? -ne 0 ] && { return 255; }
			gzip -c ${fl}.tar > "${fl}.tar.gz"
			[ $? -ne 0 ] && { return 255; }
			rm -f "${fl}.tar"

			tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz >/dev/null 2>&1
			rm -f ${fl}.tar.gz >/dev/null 2>&1
		else
			! [ -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls --full-time core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list --remove-files >/dev/null 2>&1; }
			rslt=`file ${fl} | gawk '{ gsub("\x27", "\x20", $NF); print $NF }' | tr -d [:space:] | grep ^clp`
			[ -z "${rslt}" ] && { taropt=""; }
			tar -zcf ${fl}.tar.gz ${fl} ${taropt} >/dev/null 2>&1
			tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz --remove-files >/dev/null 2>&1
		fi
	done
	rm -f core* >/dev/null 2>&1
	rm -f file.list >/dev/null 2>&1

	##[ -f ${logpath}/${arname}.tar ] && { gzip ${logpath}/${arname}.tar; }

	if [ -d /opt/nec/clusterpro/alert/bin ];then
		cd /opt/nec/clusterpro/alert/bin; seq=0
		while true;
		do
			arname=alt`date '+%Y%m%d'`_${seq}
			[ ! -f ${logpath}/${arname}.tar ] && { break; }
			seq=`expr ${seq} + 1`
		done
		for fl in `$findcmd 2>&-`
		do
			taropt="--remove-files"
			if [ "${os}" = "SunOS" ]; then
				[ ! -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls -li core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list >/dev/null 2>&1; rm -f file.list >/dev/null 2>&1; }
			else
				! [ -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls --full-time core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list --remove-files >/dev/null 2>&1; }
			fi
			rslt=`file ${fl} | gawk '{ gsub("\x27", "\x20", $NF); print $NF }' | tr -d [:space:] | grep ^clp`
			[ -z "${rslt}" ] && { taropt=""; }
			if [ "${os}" = "SunOS" ]; then
				tar -cf ${fl}.tar ${fl} >/dev/null 2>&1
				rm -f "${fl}"
				[ $? -ne 0 ] && { return 255; }
				gzip -c ${fl}.tar > "${fl}.tar.gz"
				[ $? -ne 0 ] && { return 255; }
				rm -f "${fl}.tar"

				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz >/dev/null 2>&1
				rm -f ${fl}.tar.gz >/dev/null 2>&1
			else
				tar -zcf ${fl}.tar.gz ${fl} ${taropt} >/dev/null 2>&1
				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz --remove-files >/dev/null 2>&1
			fi
		done
		rm -f core* >/dev/null 2>&1
		rm -f file.list >/dev/null 2>&1
		##[ -f ${logpath}/${arname}.tar ] && { gzip ${logpath}/${arname}.tar; }
	fi

	if [ -d /opt/nec/clusterpro/webmgr/bin ];then
		cd /opt/nec/clusterpro/webmgr/bin; seq=0
		while true;
		do
			arname=wm`date '+%Y%m%d'`_${seq}
			[ ! -f ${logpath}/${arname}.tar ] && { break; }
			seq=`expr ${seq} + 1`
		done
		for fl in `$findcmd 2>&-`
		do
			taropt="--remove-files"
			if [ "${os}" = "SunOS" ]; then
				[ ! -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls -li core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list >/dev/null 2>&1; rm -f file.list >/dev/null 2>&1; }
			else
				! [ -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls --full-time core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list --remove-files >/dev/null 2>&1; }
			fi
			rslt=`file ${fl} | gawk '{ gsub("\x27", "\x20", $NF); print $NF }' | tr -d [:space:] | grep ^clp`
			[ -z "${rslt}" ] && { taropt=""; }
			if [ "${os}" = "SunOS" ]; then
				tar -cf ${fl}.tar ${fl} >/dev/null 2>&1
				rm -f "${fl}"
				[ $? -ne 0 ] && { return 255; }
				gzip -c ${fl}.tar > "${fl}.tar.gz"
				[ $? -ne 0 ] && { return 255; }
				rm -f "${fl}.tar"

				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz >/dev/null 2>&1
				rm -f ${fl}.tar.gz >/dev/null 2>&1
			else
				tar -zcf ${fl}.tar.gz ${fl} ${taropt} >/dev/null 2>&1
				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz --remove-files >/dev/null 2>&1
			fi
		done
		rm -f core* >/dev/null 2>&1
		rm -f file.list >/dev/null 2>&1
		##[ -f ${logpath}/${arname}.tar ] && { gzip ${logpath}/${arname}.tar; }
	fi

	if [ -d /opt/nec/clusterpro/ha/sra/bin ];then
		cd /opt/nec/clusterpro/ha/sra/bin; seq=0
		while true;
		do
			arname=sra`date '+%Y%m%d'`_${seq}
			[ ! -f ${logpath}/${arname}.tar ] && { break; }
			seq=`expr ${seq} + 1`
		done
		for fl in `$findcmd 2>&-`
		do
			taropt="--remove-files"
			if [ "${os}" = "SunOS" ]; then
				[ ! -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls -li core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list >/dev/null 2>&1; rm -f file.list >/dev/null 2>&1; }
			else
				! [ -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls --full-time core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list --remove-files >/dev/null 2>&1; }
			fi
			rslt=`file ${fl} | gawk '{ gsub("\x27", "\x20", $NF); print $NF }' | tr -d [:space:] | grep ^clp`
			[ -z "${rslt}" ] && { taropt=""; }
			if [ "${os}" = "SunOS" ]; then
				tar -cf ${fl}.tar ${fl} >/dev/null 2>&1
				rm -f "${fl}"
				[ $? -ne 0 ] && { return 255; }
				gzip -c ${fl}.tar > "${fl}.tar.gz"
				[ $? -ne 0 ] && { return 255; }
				rm -f "${fl}.tar"

				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz >/dev/null 2>&1
				rm -f ${fl}.tar.gz >/dev/null 2>&1
			else
				tar -zcf ${fl}.tar.gz ${fl} ${taropt} >/dev/null 2>&1
				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz --remove-files >/dev/null 2>&1
			fi
		done
		rm -f core* >/dev/null 2>&1
		rm -f file.list >/dev/null 2>&1
		##[ -f ${logpath}/${arname}.tar ] && { gzip ${logpath}/${arname}.tar; }
	fi

	if [ -d /opt/nec/clusterpro/ha/jra/bin ];then
		cd /opt/nec/clusterpro/ha/jra/bin; seq=0
		while true;
		do
			arname=jra`date '+%Y%m%d'`_${seq}
			[ ! -f ${logpath}/${arname}.tar ] && { break; }
			seq=`expr ${seq} + 1`
		done
		for fl in `$findcmd 2>&-`
		do
			taropt="--remove-files"
			if [ "${os}" = "SunOS" ]; then
				[ ! -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls -li core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list >/dev/null 2>&1; rm -f file.list >/dev/null 2>&1; }
			else
				! [ -f ${logpath}/${arname}.tar ] && { file core* >file.list 2>&1; ls --full-time core* >>file.list 2>&1; tar -cf ${logpath}/${arname}.tar file.list --remove-files >/dev/null 2>&1; }
			fi
			rslt=`file ${fl} | gawk '{ gsub("\x27", "\x20", $NF); print $NF }' | tr -d [:space:] | grep ^clp`
			[ -z "${rslt}" ] && { taropt=""; }
			if [ "${os}" = "SunOS" ]; then
				tar -cf ${fl}.tar ${fl} >/dev/null 2>&1
				rm -f "${fl}"
				[ $? -ne 0 ] && { return 255; }
				gzip -c ${fl}.tar > "${fl}.tar.gz"
				[ $? -ne 0 ] && { return 255; }
				rm -f "${fl}.tar"

				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz >/dev/null 2>&1
				rm -f ${fl}.tar.gz >/dev/null 2>&1
			else
				tar -zcf ${fl}.tar.gz ${fl} ${taropt} >/dev/null 2>&1
				tar -rf ${logpath}/${arname}.tar ${fl}.tar.gz --remove-files >/dev/null 2>&1
			fi
		done
		rm -f core* >/dev/null 2>&1
		rm -f file.list >/dev/null 2>&1
		##[ -f ${logpath}/${arname}.tar ] && { gzip ${logpath}/${arname}.tar; }
	fi

	cd ${wopath}

	return
}

##
#	collect os information
##
logc_collect_os ()
{
	echo -e "collecting os information......"

	if [ "${os}" = "SunOS" ]; then
		##	devices
		sysdef -i >sysdef_i 2>&1
		sysdef -d >sysdef_d 2>&1

		##	/dev/dsk & /dev/rdsk
		ls -l /dev/dsk >ls_dsk 2>&1
		ls -l /dev/rdsk >ls_rdsk 2>&1

		##	isainfo
		isainfo -k -v >isainfo 2>&1
		isainfo -n -v >>isainfo 2>&1
		isainfo -v >>isainfo 2>&1

		##	mount
		mount >mounts 2>&1

		##	prtconf
		prtconf >prtconf.result 2>&1

		##	psrinfo
		psrinfo -v >psrinfo 2>&1

		##	dmesg
		dmesg >dmesg 2>&1

		##	hostname
		hostname >hostname  2>&1

		##	modinfo
		modinfo >modinfo 2>&1

		##	ifconfig
		ifconfig -a >ifconfig  2>&1

		##	df
		df >df  2>&1

		##	/etc/vfstab
		cp -fp /etc/vfstab . >/dev/null  2>&1

		##	core conf
		cp -fp /etc/coreadm.conf . >/dev/null 2>&1

		##	syslog.conf
		if [ -s /etc/syslog.conf ];
		then
			cp -a /etc/syslog.conf . >/dev/null 2>&1
		fi

		##	syslog-ng.conf
		if [ -s /etc/syslog-ng/syslog-ng.conf ];
		then
			cp -a /etc/syslog-ng/syslog-ng.conf . >/dev/null 2>&1
		fi
		##	multipath.conf
		if [ -s /etc/multipath.conf ];
		then
			cp -a /etc/multipath.conf . >/dev/null 2>&1
		fi
		##	multipath command
		multipath -l >multipath 2>&1

		##	prtdiag
		prtdiag >prtdiag 2>&1

		##	uptime
		uptime >uptime 2>&1

		##	rpcinfo
		rpcinfo -p >rpcinfo 2>&1

		##	snmpd version
		/usr/sfw/sbin/snmpd -v >snmp.ver 2>&1

		##	snmpd config
		cp -fp /etc/sma/snmp/snmpd.conf . 2>&1

		##	virt-what
		virt-what >virt-what 2>&1
	else
		##	devices
		cp -fp --parents /proc/devices . >/dev/null 2>&1

		##	mdstat
		cp -fp --parents /proc/mdstat . >/dev/null 2>&1

		##	modules
		cp -fp --parents /proc/modules . >/dev/null 2>&1

		##	lvm
		vgdisplay -v >vgdisplay  2>&1 &
		pid=$!
		i=0
		while [ "$i" -lt "60" ]
		do
			if ps ${pid} >/dev/null 2>&1;
			then
				sleep 1
				i=`expr "$i" + 1`
			else
				break
			fi
		done

		##	mounts
		cp -fp --parents /proc/mounts . >/dev/null 2>&1

		##	meminfo
		cp -fp --parents /proc/meminfo . >/dev/null 2>&1

		##	cpuinfo
		cp -fp --parents /proc/cpuinfo . >/dev/null 2>&1

		##	version
		cp -fp --parents /proc/version . >/dev/null 2>&1

		##	scsi/*
		cp -frp --parents /proc/scsi . >/dev/null 2>&1

		##	ide/*
		cp -frp --parents /proc/ide . >/dev/null 2>&1

		##	liscal
		#cp -fp --parents /proc/liscalinner . >/dev/null 2>&1
		#cp -fp --parents /proc/liscalstat . >/dev/null 2>&1

		##	ka/khb
		cp -fp --parents /proc/ka_moninfo . >/dev/null 2>&1
		cp -fp --parents /proc/khb_moninfo . >/dev/null 2>&1

		##	ksyms
		cp -fp --parents /proc/ksyms . >/dev/null 2>&1

		##	partitions
		cp -fp --parents /proc/partitions . >/dev/null 2>&1

		##	pci
		cp -fp --parents /proc/pci . >/dev/null 2>&1

		##	dmesg
		dmesg >dmesg 2>&1

		##	bonding
		cp -frp --parents /proc/net/bond* . >/dev/null 2>&1

		##	core conf
		cp -fp /proc/sys/kernel/core_pattern . >/dev/null 2>&1
		cp -fp /proc/sys/kernel/core_uses_pid . >/dev/null 2>&1

		##	hostname
		hostname >hostname  2>&1

		##	domainname
		hostname -d >domainname  2>&1

		##	lsmod
		lsmod >lsmod  2>&1

		##	ifconfig
		ifconfig >ifconfig  2>&1

		##	ip
		ip addr show >ip_addr  2>&1
		ip link show >ip_link  2>&1
		ip maddr show >ip_maddr  2>&1
		ip route show >ip_route  2>&1

		##	rpcinfo
		##rpcinfo -p >rpcinfo  2>&1
		if grep -i "SUSE Linux" /proc/version >/dev/null 2>&1;
		then
			rpcinfo -p >rpcinfo 2>&1
		else
			if service rpcbind status >/dev/null 2>&1;
			then
				rpcinfo -p >rpcinfo 2>&1
			fi
		fi

		##	iptables -L
		#iptables -L >iptables  2>&1
		if grep -i "SUSE Linux" /proc/version >/dev/null 2>&1;
		then
			iptables -L >iptables  2>&1
		else
			if service iptables status >/dev/null 2>&1;
			then
				iptables -L >iptables  2>&1
			else
				echo `service iptables status` >iptables  2>&1
			fi
		fi
		ufw status >>iptables 2>&1

		## firewalld status
		service firewalld status >firewalld  2>&1

		##	ipchains -L
		ipchains -L >ipchains  2>&1

		##	df
		df >df  2>&1

		##	raw device information
		raw -qa >raw  2>&1

		##	/etc/fstab
		cp -fp /etc/fstab . >/dev/null  2>&1

		##	syslog.conf
	#	if [ -e /etc/syslog.conf ];
		if [ -s /etc/syslog.conf ];
		then
			cp -a /etc/syslog.conf . >/dev/null 2>&1
		fi

		##	syslog-ng.conf
	#	if [ -e /etc/syslog-ng/syslog-ng.conf ];
		if [ -s /etc/syslog-ng/syslog-ng.conf ];
		then
			cp -a /etc/syslog-ng/syslog-ng.conf . >/dev/null 2>&1
		fi

		##	rsyslog.conf
		if [ -s /etc/rsyslog.conf ];
		then
			cp -a /etc/rsyslog.conf . >/dev/null 2>&1
		fi

		##	sysctl.conf
		if [ -s /etc/sysctl.conf ];
		then
			cp -a /etc/sysctl.conf . >/dev/null 2>&1
		fi

		##	multipath.conf
		if [ -s /etc/multipath.conf ];
		then
			cp -a /etc/multipath.conf . >/dev/null 2>&1
		fi
		##	multipath command
		multipath -l >multipath 2>&1

		##	dmidecode
		dmidecode >dmidecode 2>&1

		##	uptime
		uptime >uptime 2>&1

		##	snmpd version
		snmpd -v >snmp.ver 2>&1

		##	snmpd config
		cp -fp /etc/snmp/snmpd.conf . 2>&1

		##	virt-what
		virt-what >virt-what 2>&1
		systemd-detect-virt >>virt-what 2>&1

		##	blockdev
		blockdev --report >blockdev 2>&1

		##	tune2fs(dppath)
		grep dppath /opt/nec/clusterpro/etc/clp.conf | sed -e "s/<dppath>\(.*\)<\/dppath>/\1/" | xargs -n1 tune2fs -l >tune2fs_md.txt 2>&1

		##	ethtool(-k)
		ls /etc/sysconfig/network-scripts/ifcfg-* | sed -e "s/\/etc\/sysconfig\/network-scripts\/ifcfg-//" | xargs -n1 ethtool -k >ethtool_k 2>&1

		##	nmcli
		nmcli device show >nmcli 2>&1
		nmcli connection show >>nmcli 2>&1

	fi

	return
}

##
#	collect script
##
logc_collect_script ()
{
	echo -e "collecting scripts......"

	## scripts
	cp -frp /opt/nec/clusterpro/scripts . >/dev/null 2>&1
	return
}

##
#	collect esmpro / ac
##
logc_collect_esmproac ()
{
	echo -e "collecting ESMPRO/AC logs......"

	## ESMPRO/AC log
	[ ! -f ${esmpro} ] && { return; }
	[ ! -d autorc ] && { mkdir -m 0777 autorc >/dev/null 2>&1; }
	${esmpro} `pwd`/autorc >/dev/null  2>&1

	return
}

##
#	make archive
##
logc_make_archive ()
{
	echo -e "creating archive......\n"

	cd ${opath}
	rm -f ${opath}/${fname} >/dev/null 2>&1

	if [ "${os}" = "SunOS" ]; then
		tar -cf "${opath}/tmp.tar" *>/dev/null 2>&1
		gzip -c "${opath}/tmp.tar" > "${opath}/${fname}"
		rm -f "${opath}/tmp.tar"
	else
		tar -zcf ${opath}/${fname} *>/dev/null 2>&1
	fi

	return $?
}

##
#	get ha information
##
logc_collect_ha ()
{
	echo -e "collecting ha information......"

	##	check exist HA info
	if [ ! -d "/opt/nec/clusterpro/ha" ]; then
		return 0
	fi

	##	make ha directroy
	if [ ! -d ha ]
	then
		mkdir -m 0777 -p ha >/dev/null 2>&1
	fi
	if [ ! -d ha/sra ]
	then
		mkdir -m 0777 -p ha/sra >/dev/null 2>&1
	fi

	if [ "${os}" = "SunOS" ]; then
		## get sra information
		cp -r /opt/nec/clusterpro/ha/sra/* ha/sra/ >/dev/null 2>&1
	else
		## get sra information
		cp -a /opt/nec/clusterpro/ha/sra/* ha/sra/ >/dev/null 2>&1
	fi

	return $?
}

##
#	get mirror statistics information
##
logc_collect_mirrorstatsinfo ()
{
	echo -e "collecting mirror statistics information......"

	##	check exist mirror statistics info
	if [ ! -d "/opt/nec/clusterpro/perf" ]; then
		return 0
	fi

	##	make perf directroy
	if [ ! -d perf ]
	then
		mkdir -m 0777 -p perf >/dev/null 2>&1
	fi
	if [ ! -d perf/disk ]
	then
		mkdir -m 0777 -p perf/disk >/dev/null 2>&1
	fi

	if [ "${os}" = "SunOS" ]; then
		## get mirror statistics information
		cp -r /opt/nec/clusterpro/perf/disk/* perf/disk/ >/dev/null 2>&1
	else
		## get mirror statistics information
		cp -a /opt/nec/clusterpro/perf/disk/* perf/disk/ >/dev/null 2>&1
	fi

	return $?
}


##
#	get cluster statistics information
##
logc_collect_clusterstatsinfo ()
{
	echo -e "collecting cluster statistics information......"

	##	check exist cluster statistics info
	if [ ! -d "/opt/nec/clusterpro/perf" ]; then
		return 0
	fi

	##	make perf directroy
	if [ ! -d perf ]
	then
		mkdir -m 0777 -p perf >/dev/null 2>&1
	fi
	if [ ! -d perf/cluster ]
	then
		mkdir -m 0777 -p perf/cluster >/dev/null 2>&1
	fi

	if [ "${os}" = "SunOS" ]; then
		## get cluster statistics information
		cp -r /opt/nec/clusterpro/perf/cluster/* perf/cluster/ >/dev/null 2>&1
	else
		## get cluster statistics information
		cp -a /opt/nec/clusterpro/perf/cluster/* perf/cluster/ >/dev/null 2>&1
	fi

	return $?
}


##
#	get system statistics information
##
logc_collect_systemstatsinfo ()
{
	echo -e "collecting system statistics information......"

	##	check exist system statistics info
	if [ ! -d "/opt/nec/clusterpro/perf" ]; then
		return 0
	fi

	##	make perf directroy
	if [ ! -d perf ]
	then
		mkdir -m 0777 -p perf >/dev/null 2>&1
	fi
	if [ ! -d perf/system ]
	then
		mkdir -m 0777 -p perf/system >/dev/null 2>&1
	fi

	## get system statistics information
	cp -a /opt/nec/clusterpro/perf/system/* perf/system/ >/dev/null 2>&1

	return $?
}


##
#	main
##

proc=""
opath=""
ipath=""
vpath=""
rotate=""
pattern=""
fname=""
esmpro=""
mesgpath=""
flsz_tt=0
journalpath="/var/run/log/journal/*/system.journal"
journalnpath="/var/log/journal/*/system.journal"
journaldirpath="/var/log/journal"
journalconfpath="/etc/systemd/journald.conf"

os=`uname -s`
logpath=`/opt/nec/clusterpro/bin/clplogcf -p`
if [ $? -ne 0 ]; then
	logpath="/opt/nec/clusterpro/log/"
fi
dlogpath=`/opt/nec/clusterpro/bin/clplogcf -d`
if [ $? -ne 0 ]; then
	dlogpath="/opt/nec/clusterpro/work/"
fi


while getopts ":czf:i:o:r:t:v:e:s:" opt;
do
	case $opt in
	c )
		proc='c'
		;;
	z )
		proc='z'
		;;
	t )
		pattern=$OPTARG
		;;
	r )
		rotate=$OPTARG
		;;
	f )
		fname=$OPTARG
		;;
	i )
		ipath=$OPTARG
		;;
	o )
		opath=$OPTARG
		;;
	v )
		##	variable dir path for license
		vpath=$OPTARG
		;;
	e )
		esmpro=$OPTARG
		;;
	s )
		mesgpath=$OPTARG
		;;
	\? )
		exit 9
		;;
	esac

done

shift `expr $OPTIND - 1`

##	parameter check
[ -z ${proc} ] && { exit 9; }

if [ ${proc} = 'c' ];
then
	[ -z ${pattern} ] && { exit 9; }
	[ -z ${rotate} ] && { exit 9; }
	[ -z ${fname} ] && { exit 9; }
	[ -z ${opath} ] && { exit 9; }
	[ -z ${mesgpath} ] && { exit 9; }
	wopath=${opath}/`basename ${fname} -log.tar.gz`
	if [ -d ${wopath} ];
	then
		rm -fr ${wopath} >/dev/null 2>&1
		[ $? -ne 0 ] && { exit 252; }
	fi
	mkdir -m 0777 -p ${wopath} >/dev/null 2>&1
	[ $? -ne 0 ] && { exit 253; }
	cd ${wopath}
elif [ $proc = 'z' ];
then
	[ -z ${pattern} ] && { exit 9; }
	[ -z ${rotate} ] && { exit 9; }
else
	exit 9;
fi

##	collect core
#if [ ${pattern:28:1} = "1" ];
patternbit=`echo $pattern | cut -c 29-29`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_core
	else
		logc_get_core_size
	fi
fi

##	get default information
#if [ ${pattern:31:1} = "1" ];
patternbit=`echo $pattern | cut -c 32-32`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_default
	else
		logc_get_default_size
	fi
fi

##	collect clusterlog
#[ ${pattern:30:1} = "1" ] && { logc_collect_clslog; }
patternbit=`echo $pattern | cut -c 31-31`
if [ $patternbit = "1" ];
then
	logc_collect_clslog
fi

##	collect syslog
#if [ ${pattern:29:1} = "1" ];
patternbit=`echo $pattern | cut -c 30-30`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_syslog
	else
		logc_get_syslog_size
	fi
fi

##	collect os information
#if [ ${pattern:27:1} = "1" ];
patternbit=`echo $pattern | cut -c 28-28`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_os
	else
		logc_get_os_size
	fi
fi

##	collect group scripts
#if [ ${pattern:26:1} = "1" ];
patternbit=`echo $pattern | cut -c 27-27`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_script
	else
		logc_get_scripts_size
	fi
fi

##	collect ESMPRO/AC log
#if [ ${pattern:25:1} = "1" ];
patternbit=`echo $pattern | cut -c 26-26`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_esmproac
	else
		logc_get_esmpro_size
	fi
fi

##	collect ha information
#if [ ${pattern:24:1} = "1" ];
patternbit=`echo $pattern | cut -c 25-25`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_ha
	else
		logc_get_ha_size
	fi
else
	if [ ${proc} = 'c' ];
	then
		rm -rf ${wopath}/log/ha >/dev/null 2>&1
	fi
fi

##	collect mirror statistics information
#if [ ${pattern:23:1} = "1" ];
patternbit=`echo $pattern | cut -c 24-24`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_mirrorstatsinfo
	else
		logc_get_mirrorstatsinfo_size
	fi
else
	if [ ${proc} = 'c' ];
	then
		rm -rf ${wopath}/log/perf/disk >/dev/null 2>&1
	fi
fi

##	collect cluster statistics information
#if [ ${pattern:22:1} = "1" ];
patternbit=`echo $pattern | cut -c 23-23`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_clusterstatsinfo
	else
		logc_get_clusterstatsinfo_size
	fi
else
	if [ ${proc} = 'c' ];
	then
		rm -rf ${wopath}/log/perf/cluster >/dev/null 2>&1
	fi
fi

##	collect system statistics information
patternbit=`echo $pattern | cut -c 22-22`
if [ $patternbit = "1" ];
then
	if [ ${proc} = 'c' ];
	then
		logc_collect_systemstatsinfo
	else
		logc_get_systemstatsinfo_size
	fi
else
	if [ ${proc} = 'c' ];
	then
		rm -rf ${wopath}/log/perf/system >/dev/null 2>&1
	fi
fi

##	create archive
if [ ${proc} = 'c' ];
then
	logc_make_archive
	[ $? -ne 0 ] && { exit 255; }
else
	logc_get_archive_size
	echo ${flsz_tt}
	exit 0
fi

##	rm workpath
rm -fr ${wopath} >/dev/null 2>&1
[ $? -ne 0 ] && { exit 254; }

echo -e "collect succeeded.\n"

exit 0

