#!/bin/sh

LANG=C;	export	LANG

##
#	log collect script
##

##
#	collect cluster information
##
logc_collect_cluster ()
{
	#echo -e "  collecting cluster information......"

	if [ ! -d log ];
	then
		mkdir -m 0777 log >/dev/null 2>&1
	fi

	##	shared memory dump
	if [ ${clpdmp} = 1 ]
	then
		clpstat -d >/dev/null 2>&1
		if [ "${os}" = "SunOS" ]; then
			cp ${logpath}/dmp.* log/ >/dev/null 2>&1
		else
			cp -a /opt/nec/clusterpro/log/dmp.* log/ >/dev/null 2>&1
		fi
		rm -f ${logpath}/dmp.cm ${logpath}/dmp.nm ${logpath}/dmp.rm >/dev/null 2>&1
	fi

	##	log files
	if [ ${clplog} = 1 ]
	then
		if [ "${os}" = "SunOS" ]; then
			if [ ${mtype} = 'rm' ];
			then
				cp ${logpath}/api*.cur log/ >/dev/null 2>&1
				cp ${logpath}/md* log/ >/dev/null 2>&1
				for pol in `ls /opt/nec/clusterpro/etc/policy/monitor`;
				do
					cp ${logpath}/`basename ${pol} .pol`.*.cur log/ >/dev/null 2>&1
				done
			elif [ ${mtype} = 'rc' ];
			then
				cp ${logpath}/api*.cur log/ >/dev/null 2>&1
				cp ${logpath}/md* log/ >/dev/null 2>&1
			elif [ ${mtype} = 'pm' ];
			then
				cp ${logpath}/api*.cur log/ >/dev/null 2>&1
				cp ${logpath}/md* log/ >/dev/null 2>&1
			else
				cp ${logpath}/*.cur log/ >/dev/null 2>&1
			fi
		else
			if [ ${mtype} = 'rm' ];
			then
				cp -a /opt/nec/clusterpro/log/api*.cur log/ >/dev/null 2>&1
				cp -a /opt/nec/clusterpro/log/md* log/ >/dev/null 2>&1
				cp -a /opt/nec/clusterpro/log/scrpc.log.cur log/ >/dev/null 2>&1
				for pol in `ls /opt/nec/clusterpro/etc/policy/monitor`;
				do
					cp -a /opt/nec/clusterpro/log/`basename ${pol} .pol`.*.cur log/ >/dev/null 2>&1
				done
			elif [ ${mtype} = 'rc' ];
			then
				cp -a /opt/nec/clusterpro/log/api*.cur log/ >/dev/null 2>&1
				cp -a /opt/nec/clusterpro/log/md* log/ >/dev/null 2>&1
				cp -a /opt/nec/clusterpro/log/scrpc.log.cur log/ >/dev/null 2>&1
			elif [ ${mtype} = 'pm' ];
			then
				cp -a /opt/nec/clusterpro/log/api*.cur log/ >/dev/null 2>&1
				cp -a /opt/nec/clusterpro/log/md* log/ >/dev/null 2>&1
			else
				cp -a /opt/nec/clusterpro/log/*.cur log/ >/dev/null 2>&1
			fi
		fi
	fi

	## 	config file
		if [ "${os}" = "SunOS" ]; then
			cp /opt/nec/clusterpro/etc/clp.conf . >/dev/null 2>&1
		else
			cp -a /opt/nec/clusterpro/etc/clp.conf . >/dev/null 2>&1
		fi

	##	core files
	if [ ${clpcore} = 1 ]
	then
		if [ "${os}" = "SunOS" ]; then
			tar -cvf log/clpcore.tar /opt/nec/clusterpro/bin/core* >/dev/null 2>&1
			gzip -c log/clpcore.tar > log/clpcore.tar.gz
			rm -f log/clpcore.tar
			tar -cvf log/mgrcore.tar /opt/nec/clusterpro/webmgr/bin/core* >/dev/null 2>&1
			gzip -c log/mgrcore.tar > log/mgrcore.tar.gz
			rm -f log/mgrcore.tar
			tar -cvf log/altcore.tar /opt/nec/clusterpro/alert/bin/core* >/dev/null 2>&1
			gzip -c log/altcore.tar > log/altcore.tar.gz
			rm -f log/altcore.tar
		else
			tar -zcvf log/clpcore.tar.gz /opt/nec/clusterpro/bin/core* >/dev/null 2>&1
			tar -zcvf log/mgrcore.tar.gz /opt/nec/clusterpro/webmgr/bin/core* >/dev/null 2>&1
			tar -zcvf log/altcore.tar.gz /opt/nec/clusterpro/alert/bin/core* >/dev/null 2>&1
		fi
	fi

	return 0
}

##
#	collect command information
##
logc_collect_command ()
{
	#echo -e "  collecting command information......"

	if [ "${os}" = "SunOS" ]; then
		##	cluster process status
		ps -eao user,pid,ppid,pcpu,pmem,vsz,rss,tty,s,stime,time,pri,nice,args | sort | grep -v grep >ps.result 2>&1

		##	cluster ps(thread) status
		ps -eLf >ps_th 2>&1
		
		##	top
		prstat 1 2 >prstat 2>&1
	else
		##	kernel parameters
		sysctl -a >sysctl 2>&1

		##	cluster process status
		ps -eaw -ouser,pid,ppid,%cpu,%mem,vsz,rss,tty,stat,stime,cputime,priority,nice,cmd --sort pid | grep -v grep >ps 2>&1

		##	cluster ps(thread) status
		ps -eLf >ps_th 2>&1

		##	top
		top -b -n 2 >top 2>&1
	fi

	##	IPC resource
	ipcs -a >ipcs 2>&1
	ipcs -t >>ipcs 2>&1
	ipcs -p >>ipcs 2>&1

	##	open files
	#lsof >lsof 2>&1

	##	lsmod
	#lsmod >lsmod  2>&1

	##	network statistics
	netstat -in >netstat.if 2>&1
	netstat -apn >netstat.v4 2>&1
	netstat -gn >>netstat.v4 2>&1
	netstat -rn >>netstat.v4 2>&1
	if [ "${os}" != "SunOS" ]; then
		netstat --inet6 -apn >netstat.v6 2>&1
		netstat --inet6 -gn >>netstat.v6 2>&1
		netstat --inet6 -rn >>netstat.v6 2>&1
	fi
	
	if [ "${os}" = "SunOS" ]; then
		##	ifconfig
		ifconfig -a >ifconfig  2>&1

		##	df
		df >df  2>&1
		df -h >df.h  2>&1
	else
		##	ifconfig
		ifconfig >ifconfig  2>&1

		##	ip
		ip -s l >ip_opt_sl

		##	df
		df >df  2>&1

		##	raw device information
		raw -qa >raw  2>&1
	fi

	return 0
}

##
#	collect os information
##
logc_collect_os ()
{
	#echo -e "  collecting os information......"

	if [ "${os}" = "SunOS" ]; then
		##	sysdef
		sysdef >sysdef  2>&1

		##	modinfo
		modinfo >modinfo  2>&1

		##	psrinfo
		psrinfo -v >psrinfo  2>&1

		##	prtconf
		prtconf -v >prtconf  2>&1

		##	mnttab
		cp -fp /etc/mnttab . >/dev/null 2>&1

		##	syslog
		tail -500 /var/log/messages >messages.tail 2>&1

		##	uptime
		uptime >uptime 2>&1

	else
		##	devices
		cp -fp --parents /proc/devices . >/dev/null 2>&1

		##	mdstat
		cp -fp --parents /proc/mdstat . >/dev/null 2>&1

		##	modules
		cp -fp --parents /proc/modules . >/dev/null 2>&1

		##	lvm
		#cp -frp --parents /proc/lvm . >/dev/null 2>&1

		##	mounts
		cp -fp --parents /proc/mounts . >/dev/null 2>&1

		##	meminfo
		cp -fp --parents /proc/meminfo . >/dev/null 2>&1

		##	scsi/*
		#cp -frp --parents /proc/scsi . >/dev/null 2>&1

		##	ide/*
		#cp -frp --parents /proc/ide . >/dev/null 2>&1

		##	liscal
		#cp -fp --parents /proc/liscalinner . >/dev/null 2>&1
		#cp -fp --parents /proc/liscalstat . >/dev/null 2>&1

		##	ka/khb
		#cp -fp --parents /proc/ka_moninfo . >/dev/null 2>&1
		#cp -fp --parents /proc/khb_moninfo . >/dev/null 2>&1

		##	partitions
		cp -fp --parents /proc/partitions . >/dev/null 2>&1

		##	bonding
		cp -frp --parents /proc/net/bond* . >/dev/null 2>&1

		##	syslog.conf
		#if [ -e /etc/syslog.conf ];
		#then
		#	 cp -a /etc/syslog.conf . >/dev/null 2>&1
		#fi

		##	syslog-ng.conf
		#if [ -e /etc/syslog-ng/syslog-ng.conf ];
		#then
		#	 cp -a /etc/syslog-ng/syslog-ng.conf . >/dev/null 2>&1
		#fi

		##	syslog
		tail -500 /var/log/messages >messages.tail 2>&1

		##	journal
		journalctl -e >journal.tail 2>&1

		##	uptime
		uptime >uptime 2>&1
	fi

	return
}

##
#	make archive
##
logc_make_archive ()
{
	#echo -e "  creating archive......"

	cd "${opath}"

	# rotation
	count=$rotate
	while [ $count -gt 0 ]
	do
		fcnt=`expr ${count} - 1`
		precnt=`expr ${fcnt} - 1`

		if [ ${count} = 1 ]
		then
			if [ -f ${opath}/elog_${mtype}0${fname} ]
			then
				rm -f "${opath}/elog_${mtype}0${fname}" >/dev/null 2>&1
			fi
		elif [ ${count} = 2 ]
		then
			if [ -f ${opath}/elog_${mtype}0${fname} ]
			then
				mv ${opath}/elog_${mtype}0${fname} ${opath}/elog_${mtype}${fcnt}${fname}
			fi
		else
			if [ -f ${opath}/elog_${mtype}${precnt}${fname} ]
			then
				mv ${opath}/elog_${mtype}${precnt}${fname} ${opath}/elog_${mtype}${fcnt}${fname}
			fi
		fi

		count=`expr ${count} - 1`
	done

	# archive
	if [ "${os}" = "SunOS" ]; then
		tar -cf "${opath}/tmp.tar" ${mtype}>/dev/null 2>&1
		gzip -c "${opath}/tmp.tar" > "${opath}/elog_${mtype}0${fname}"
		rm -f "${opath}/tmp.tar"
	else
		tar -zcf "${opath}/elog_${mtype}0${fname}" ${mtype}>/dev/null 2>&1
	fi
	return $?
}

##
#	main
##

logpath=`/opt/nec/clusterpro/bin/clplogcf -p`
if [ $? -ne 0 ]; then
	logpath="/opt/nec/clusterpro/log/"
fi
opath=${logpath}
rotate=5
mtype="type"
fname=".tar.gz"
clpcore=0
clplog=0
clpdmp=0

os=`uname -s`


while getopts ":cdlo:r:t:" opt;
do
	case $opt in
	c )
		clpcore=1
		;;
	d )
		clpdmp=1
		;;
	l )
		clplog=1
		;;
	r )
		rotate=$OPTARG
		;;
	o )
		opath=$OPTARG
		;;
	t )
		mtype=$OPTARG
		;;
	\? )
		#echo -e "\n  invalid option\n"
		exit 9
		;;
	esac

done

#echo -e "\n>>>>> START COLLECT >>>>>"

shift `expr $OPTIND - 1`

wopath=${opath}/${mtype}

if [ -d "${wopath}" ];
then
	rm -fr "${wopath}" >/dev/null 2>&1
	if [ $? -ne 0 ];
	then
		#echo -e "  collect was wrong for failed deletion of directory. (${wopath})"
		exit 252
	fi
fi

mkdir -m 0777 -p "${wopath}" >/dev/null 2>&1
if [ $? -ne 0 ];
then
	#echo -e "  collect was wrong for failed creation of directory. (${wopath})"
	exit 253
fi

##	change out directory
cd "${wopath}"
##	date
date >date 2>&1

##	get default information
logc_collect_command

##	get os information
logc_collect_os

##	get cluster information
logc_collect_cluster

##	date
date >>date 2>&1

##	archive
logc_make_archive
if [ $? -ne 0 ]
then
	#echo -e "  collect was wrong for failed creation of archive."
	exit 255
fi

cd ${opath}

##	rm workpath
rm -fr "${wopath}" >/dev/null 2>&1
if [ $? -ne 0 ];
then
	#echo -e "  collect was wrong for failed deletion of directory. (${wopath})"
	exit 254
fi

#echo -e "<<<<<< END COLLECT <<<<<<\n"

exit 0
