rem ***************************************
rem * start.bat                           *
rem ***************************************

rem ***************************************
rem Check startup attributes
rem ***************************************
IF "%CLP_EVENT%" == "RECOVER" GOTO RECOVER

set srv1name=cluster-sv1
set srv1job=switch-SV1.bat
set srv2name=cluster-sv2
set srv2job=switch-SV2.bat
set backupsrv_ip=192.168.57.40

for /f "usebackq delims=" %%i in (`hostname`) do set srvname=%%i

if %srvname% == %srv1name% (
    set jobname=%srv1job%
) else if %srvname% == %srv2name% (
    set jobname=%srv2job%
) else (
    exit 1
)

setlocal enabledelayedexpansion
set ret=

for /f "usebackq tokens=*" %%i in (`clprexec --script %jobname% -h %backupsrv_ip%`) do (
    set ret=!ret!%%i
)

echo %ret% | findstr /l "Success"
if %ERRORLEVEL% neq 0 (
    exit 2
)

for /f "usebackq tokens=7 delims= " %%i in (`echo %ret%`) do set retcode=%%i
if %retcode% neq 0 (
    exit %retcode%
)

endlocal

rem ***************************************
rem Recovery process
rem ***************************************
:RECOVER

rem *************
rem Recovery process after return to the cluster
rem *************


exit 0