#!/bin/sh
#

UBUNTUFILE=/etc/os-release
TURBOFILE=/etc/turbolinux-release

OS=`uname -s`
if [ ${OS} = 'Linux' ]; then
    keyword=
    if [ -f ${UBUNTUFILE} ]; then
        keyword=`cat ${UBUNTUFILE} | grep -i Ubuntu`
        if [ -n "${keyword}" ]; then
            OS="UbuOrTur"
        fi
    fi
    keyword=
    if [ -f ${TURBOFILE} ];then
        keyword=`cat ${TURBOFILE} | grep -i Turbolinux`
        if [ -n "${keyword}" ]; then
            OS="UbuOrTur"
        fi
    fi
fi

if [ ${OS} = 'Linux' ]; then
    TOUCH=`which --skip-alias touch`
    RM=`which --skip-alias rm`
    AWK=`which --skip-alias awk`
    GREP=`which --skip-alias grep`
    SED=`which --skip-alias sed`
    MKDIR=`which --skip-alias mkdir`
    CAT=`which --skip-alias cat`
    EXPR=`which --skip-alias expr`
elif [ ${OS} = 'UbuOrTur' ];then
    TOUCH=`which -a touch`
    RM=`which -a rm`
    AWK=`which -a awk`
    GREP=`which -a grep`
    SED=`which -a sed`
    MKDIR=`which -a mkdir`
    CAT=`which -a cat`
    EXPR=`which -a expr`
elif [ ${OS} = 'SunOS' ]; then
    TOUCH=/usr/bin/touch
    RM=/usr/bin/rm
    AWK=/usr/bin/awk
    GREP=/usr/bin/grep
    SED=/usr/bin/sed
    MKDIR=/usr/bin/mkdir
    CAT=/usr/bin/cat
    EXPR=/usr/bin/expr
fi

JRA_BIN=`dirname $0`
JRA_HOME=`cd ${JRA_BIN}; cd ..; pwd`
TMPFILEPATH=${JRA_HOME}/tmp
CONFFILEPATH=${JRA_HOME}/conf/
CONFIG=${CONFFILEPATH}/jvmsaver.conf
FILEDFCOUNT=10

MSG_001="Usage : clpjra_monitor.sh {start jrawname | stop jrawname}."
MSG_002="Monitor object did not start yet:"
MSG_004="Failed to start monitor object:"
MSG_005="Failed to stop monitor object:"
MSG_009="Monitor object already started:"
MSG_011="Start monitor object successfully:"
MSG_012="Stop monitor object successfully:"

####
# get_val_by_key
####
get_val_by_key()
{
  KEY=$1
  CONF_FILE=$2
  if [ "${KEY}" = "" -o  "${CONF_FILE}" = "" ] ; then
    return 1
  fi
  if [ ! -f ${CONF_FILE} ] ; then
    return 1
  fi
  VALUE=`${CAT} ${CONF_FILE} | ${SED} 's/ //g' | ${GREP} "^${KEY}="`
  if [ $? -ne 0 ] ; then
    return 1
  fi
  VALUE=`echo ${VALUE} | ${AWK} -F"=" '{print $2}'`
  return 0
}


####
#get count of config file 
####
get_filecount()
{
    get_val_by_key "jvm.count" ${CONFIG}
    if [ $? -eq 0 ];then
        FILECOUNT=${VALUE}
        ${EXPR} "${FILECOUNT}" : "^[0-9]*$" 2>/dev/null 1>&2
        if [ $? -ne 0 ]
        then
            FILECOUNT=${FILEDFCOUNT}
        else
            if [ ${FILECOUNT} -gt 25 -o ${FILECOUNT} -lt 1 ];then
                FILECOUNT=${FILEDFCOUNT}
            fi  
        fi
    else
        FILECOUNT=${FILEDFCOUNT}
    fi
}

######### main #########

if [ $# -ne 2 ] && [ $# -ne 1 ]
then 
    echo ${MSG_001}
    exit 1
fi

if  [ "$1" != "start"  -a  "$1" != "stop"  -a  "$1" != "show" ]
then
    echo ${MSG_001}
    exit 1
fi

get_filecount

if [ "$1" = "start"  -o  "$1" = "stop" ]
then
    if [ $# -ne 2 ]
    then
        echo ${MSG_001}
        exit 1
    fi
fi

CMDNAME=$1
FILENUMB=$2

case ${CMDNAME} in
'start') 
  if [ ! -d ${TMPFILEPATH} ]
  then
    ${MKDIR} -p ${TMPFILEPATH}  2>/dev/null 1>&2
  fi
 
  if [ ! -f ${TMPFILEPATH}/${FILENUMB}_mon ]
  then
      ${TOUCH}  ${TMPFILEPATH}/${FILENUMB}_mon 2>/dev/null 1>&2
      if [ $? -ne 0 ]
      then
          echo ${MSG_004}${TMPFILEPATH}/${FILENUMB}_mon.
          exit 1
      fi
      echo ${MSG_011}${FILENUMB}.
  else
      echo ${MSG_009}${FILENUMB}.
  fi
  ;;

'stop')
   if [ -f ${TMPFILEPATH}/${FILENUMB}_mon ]
   then
       ${RM} -f  ${TMPFILEPATH}/${FILENUMB}_mon 2>/dev/null 1>&2
       if [ $? -ne 0 ]
       then
           echo ${MSG_005}${TMPFILEPATH}/${FILENUMB}_mon.
           exit 1
       fi
       echo ${MSG_012}${FILENUMB}.
       
  else
      echo ${MSG_002}${FILENUMB}.
  fi
  ;;

*)
# will not run in this section.
  exit 1;;
esac

exit 0
