#!/bin/sh
#
# Startup script for the CLUSTERPRO event
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=2

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_

# See how we were called.
case "$1" in
  start)
	targetos=`/bin/uname`

	clp_filedel "$1" init_evt $targetos
	clp_logwrite "$1" "clusterpro_evt start process start." init_evt

	#
	cd /opt/nec/clusterpro/bin

	#
	if [ "$targetos" = "SunOS" ]
	then
		echo "Starting clusterpro event: \c"
	else
		logging=`clpcfget -g /root/event/container/logging` 
		cfget_ret=$?
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Starting clusterpro event: " > /dev/null 2>&1
		else
			echo -n "Starting clusterpro event: "
		fi
	fi

	#
	clp_logwrite "$1" "clppidof start." init_evt
	pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --event 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_evt

	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "event already exist." init_evt
		clp_logwrite "$1" "clusterpro_evt start process end." init_evt
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success $targetos > /dev/null 2>&1
		else
			clp_success $targetos
		fi
		exit 0
	fi

	# SuSE
	if [ "$targetos" = "Linux" ]
	then
		clp_logwrite "$1" "modprobe start." init_evt
		modprobe raw > /dev/null 2>&1
		clp_logwrite "$1" "modprobe end." init_evt
	fi

	#
	if [ -d "/opt/nec/clusterpro/tmp/scrpc" ]; then
		clp_logwrite "$1" "remove scrpc tmp log." init_evt
		rm -rf /opt/nec/clusterpro/tmp/scrpc
	fi

	#
	clp_logwrite "$1" "clpcfctrl start." init_evt
	./clpcfctrl --startup > /dev/null 2>&1
	clp_logwrite "$1" "clpcfctrl end." init_evt

	# starting clusterpro event
	clp_logwrite "$1" "event start process start." init_evt

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		./clpmonp --event
	else
		./clpmonp --event > /dev/null 2>&1
	fi

	monp_ret=$?
	clp_logwrite "$1" "event start process end.("$monp_ret")" init_evt

	#
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_checkerr "$monp_ret" $targetos > /dev/null 2>&1
	else
		clp_checkerr "$monp_ret" $targetos
	fi
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_evt start process end." init_evt
		exit 0
	fi

	# PIDFile for systemd
	[ ! -d ../work/service ] && { mkdir -m 0755 ../work/service >/dev/null 2>&1; }
	[ -f ../work/service/clusterpro_evt.pid ] && { rm -f ../work/service/clusterpro_evt.pid >/dev/null 2>&1; }

	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --event 2>&1`

	if [ "$pids" != "" ]
	then
		echo $pids > /opt/nec/clusterpro/work/service/clusterpro_evt.pid 2>&1
		clp_logwrite "$1" "create pid file.("$pids")" init_evt
	fi

	#
	if [ "$targetos" = "Linux" ]
	then
		# driver copy for errata kernel"
		clp_logwrite "$1" "clpdrvcp start." init_evt
		clpdrvcp.sh 2>&1
		drvcp_ret=$?
		clp_logwrite "$1" "clpdrvcp end.(ret=${drvcp_ret})" init_evt
	fi

	# SSS
	if [ -f /opt/nec/clusterpro/bin/clpsss ]
	then
		clp_logwrite "$1" "clpsss start." init_evt
		pids=`/opt/nec/clusterpro/bin/clpsss 2>&1`
		clp_logwrite "$1" "clpsss end." init_evt
	fi

	clp_logwrite "$1" "clusterpro_evt start process end." init_evt
	;;
  stop)
	targetos=`/bin/uname`

	clp_filedel "$1" init_evt $targetos
	clp_logwrite "$1" "clusterpro_evt stop process start." init_evt

	#
	if [ "$targetos" = "SunOS" ]
	then
		echo "Shutting down clusterpro event: \c"
	else
		logging=`clpcfget -g /root/event/container/logging` 
		cfget_ret=$?
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Shutting down clusterpro event: " > /dev/null 2>&1
		else
			echo -n "Shutting down clusterpro event: "
		fi
	fi

	#
	cd /opt/nec/clusterpro/bin

	# PIDFile for systemd
	[ -f ../work/service/clusterpro_evt.pid ] && { rm -f ../work/service/clusterpro_evt.pid >/dev/null 2>&1; }
	clp_logwrite "$1" "rm pid file." init_evt

	#
	clp_logwrite "$1" "clppidof start." init_evt
	pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --event 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_evt

	if [ "$pids" != "" ]
	then
		# shutting down clusterpro event
		clp_logwrite "$1" "event stop process start." init_evt
		if [ "$targetos" = "SunOS" ]
		then
			kill -17 "$pids" 2>/dev/null
			kill_ret=$?
		else
			kill -12 "$pids" 2>/dev/null
			kill_ret=$?
		fi
		clp_logwrite "$1" "event stop process end.("$kill_ret")" init_evt

		i=0
		while [ "$i" -lt "10" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_evt
			pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --event 2>&1`
			clp_logwrite "$1" "clppidof2 end.(pids=${pids})" init_evt

			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "event stop success." init_evt
				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_success $targetos > /dev/null 2>&1
				else
					clp_success $targetos
				fi

				clp_logwrite "$1" "clusterpro_evt stop process end." init_evt
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done
		clp_logwrite "$1" "event stop timeout." init_evt
	else
		clp_logwrite "$1" "event not exist." init_evt
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success $targetos > /dev/null 2>&1
		else
			clp_success $targetos
		fi

		clp_logwrite "$1" "clusterpro_evt stop process end." init_evt
		exit 0
	fi

	clp_logwrite "$1" "clusterpro_evt stop process end." init_evt
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success $targetos > /dev/null 2>&1
	else
		clp_success $targetos
	fi
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	targetos=`/bin/uname`
	if [ "$targetos" = "SunOS" ]
	then
		clp_status_s clpevent
	else
		clp_status clpevent
	fi
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
