#!/bin/sh
#
# Startup script for the CLUSTERPRO daemon
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=2
HALT_TARGET="halt.target"
POWEROFF_TARGET="poweroff.target"
REBOOT_TARGET="reboot.target"

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_

# See how we were called.
case "$1" in
  start)
	targetos=`/bin/uname`

	clp_filedel "$1" init_main $targetos
	clp_logwrite "$1" "clusterpro_main start process start." init_main

	#
	cd /opt/nec/clusterpro/bin

	# export all volmgr resource
	clp_logwrite "$1" "clpvolmgrc start." init_main
	./clpvolmgrc -d > /dev/null 2>&1
	retvolmgrc=$?
	clp_logwrite "$1" "clpvolmgrc end.("$retvolmgrc")" init_main

	# starting clusterpro
	if [ "$targetos" = "SunOS" ]
	then
		echo "Starting clusterpro daemon: \c"
	else
		logging=`clpcfget -g /root/event/container/logging` 
		cfget_ret=$?
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Starting clusterpro daemon: " > /dev/null 2>&1
		else
			echo -n "Starting clusterpro daemon: "
		fi
	fi

	#
	clp_logwrite "$1" "clpcl -s start." init_main
	./clpcl -s --type init > /dev/null 2>&1
	clrets=$?
	clp_logwrite "$1" "clpcl -s end.("$clrets")" init_main

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_checkerr "$clrets" $targetos > /dev/null 2>&1
	else
		clp_checkerr "$clrets" $targetos
	fi

	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_main start process end." init_main
		exit 0
	fi

	clp_logwrite "$1" "clusterpro_main start process end." init_main
	;;
  stop)
	targetos=`/bin/uname`

	clp_filedel "$1" init_main $targetos
	clp_logwrite "$1" "clusterpro_main stop process start." init_main

	# check running clppm
	clp_logwrite "$1" "clppidof start." init_main
	pid=`clppidof /opt/nec/clusterpro/bin/clppm 2>&1`
	clp_logwrite "$1" "clppidof end.(pid=${pid})" init_main

	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?

	if [ "$pid" = "" ]
	then
		clp_logwrite "$1" "clusterpro_main is not exist." init_main
		clp_logwrite "$1" "clusterpro_main stop process end." init_main
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success $targetos > /dev/null 2>&1
		else
			clp_success $targetos
		fi
		exit 0
	fi

	# stoping clusterpro
	if [ "$targetos" = "SunOS" ]
	then
		echo "Shutting down clusterpro daemon: \c"
	else
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Shutting down clusterpro daemon: " > /dev/null 2>&1
		else
			echo -n "Shutting down clusterpro daemon: "
		fi
	fi

	#
	cd /opt/nec/clusterpro/bin

	# shutting down clusterpro
	clp_logwrite "$1" "systemctl list-units --type target start." init_main
	tgtlst=`systemctl list-units --type target`
	clp_logwrite "$1" "systemctl list-units --type target end.(tgtlst=${tgtlst})" init_main

	forcestop_env=$(clpcfget -g /root/forcestop/env)
	forcestop_ret=$?
	clp_logwrite "$1" "forcestop(cfget_ret=${forcestop_ret}, env=${forcestop_env})" init_main

	if echo $tgtlst | grep -sqE "$HALT_TARGET|$POWEROFF_TARGET"
	then
		clp_logwrite "$1" "clpdown start." init_main
		if [ "$forcestop_ret" != "0" ] || [ "$forcestop_env" = "disabled" ]
		then
			./clpdown --type init --nochk > /dev/null 2>&1
		else
			./clpdown --type init --nochk --apito 1 > /dev/null 2>&1
		fi
		downret=$?
		clp_logwrite "$1" "clpdown end.("$downret")" init_main

		if [ "$downret" != "0" ]
		then
			clp_logwrite "$1" "clpdown failed." init_main
		fi
	elif echo $tgtlst | grep -sq "$REBOOT_TARGET"
	then
		clp_logwrite "$1" "clpdown -r start." init_main
		if [ "$forcestop_ret" != "0" ] || [ "$forcestop_env" = "disabled" ]
		then
			./clpdown -r --type init --nochk > /dev/null 2>&1
		else
			./clpdown -r --type init --nochk --apito 1 > /dev/null 2>&1
		fi
		downretr=$?
		clp_logwrite "$1" "clpdown -r end.("$downretr")" init_main

		if [ "$downretr" != "0" ]
		then
			clp_logwrite "$1" "clpdown -r failed." init_main
		fi
	else
		clp_logwrite "$1" "clpcl -t start." init_main
		./clpcl -t --type init --nochk > /dev/null 2>&1
		clrett=$?
		clp_logwrite "$1" "clpcl -t end.("$clrett")" init_main

		if [ "$clrett" != "0" ]
		then
			clp_logwrite "$1" "clpcl -t failed." init_main
		fi
	fi

	#
	clp_logwrite "$1" "clppidof start." init_main
	pid=`clppidof /opt/nec/clusterpro/bin/clppm 2>&1`
	clp_logwrite "$1" "clppidof end.(pid=${pid})" init_main

	if [ "$pid" = "" ]
	then
		clp_logwrite "$1" "cluster stop success." init_main
		clp_logwrite "$1" "clusterpro_main stop process end." init_main
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success $targetos > /dev/null 2>&1
		else
			clp_success $targetos
		fi
		exit 0
	fi

	if [ "$forcestop_ret" != "0" ] || [ "$forcestop_env" = "disabled" ]
	then
		i=0
		while [ "$i" -lt "30" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_main
			pid=`clppidof /opt/nec/clusterpro/bin/clppm 2>&1`
			clp_logwrite "$1" "clppidof2 end.(pid=${pid})" init_main

			if [ "$pid" = "" ]
			then
				clp_logwrite "$1" "cluster stop success." init_main
				clp_logwrite "$1" "clusterpro_main stop process end." init_main
				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_success $targetos > /dev/null 2>&1
				else
					clp_success $targetos
				fi
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done
	fi

	clp_logwrite "$1" "haltp start." init_main
	if echo $tgtlst | grep -sqE "$HALT_TARGET|$POWEROFF_TARGET"
	then
		./clpuserw --halt & 2>&1
	elif echo $tgtlst | grep -sq "$REBOOT_TARGET"
	then
		./clpuserw --halt & 2>&1
	else
		clp_logwrite "$1" "haltp not execute." init_main
	fi
	clp_logwrite "$1" "haltp end." init_main

	clp_logwrite "$1" "clusterpro_main stop process end." init_main
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success $targetos > /dev/null 2>&1
	else
		clp_success $targetos
	fi
	exit 0
	;;
  restart)
	targetos=`/bin/uname`
	clp_filedel "$1" init_main $targetos
	# restarting clusterpro

	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		echo -n "Restarting clusterpro daemon: " > /dev/null 2>&1
	else
		echo -n "Restarting clusterpro daemon: "
	fi

	#
	cd /opt/nec/clusterpro/bin

	clp_logwrite "$1" "clpcl -r start." init_main
	#
	./clpcl -r --type init > /dev/null 2>&1
	clret=$?
	clp_logwrite "$1" "clpcl -r end.("$clret")" init_main

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_checkerr "$clret" $targetos > /dev/null 2>&1
	else
		clp_checkerr "$clret" $targetos
	fi
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_main restart process end." init_main
		exit 1
	fi

	;;
  status)
	targetos=`/bin/uname`
	if [ "$targetos" = "SunOS" ]
	then
		clp_status_s clppm
	else
		clp_status clppm
	fi
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
