/* &1: executing flag (0- begin; -1 end) */
/* &2: log file */
/* &3: oraclew pid */

/* settings */
define spoolfile = &2
spool &spoolfile
/* comment the line below to get output in plain text */
set markup html on entmap on preformat off
set term off
set wrap on
set trimspool on trimout on
set pagesize 1000 linesize 2000 numwidth 10
set verify off
set heading on feedback off serveroutput on
set echo off
alter session set nls_date_format = 'YYYY-MM-DD HH24:MI:SS';
alter session set timed_statistics = true;
alter session set max_dump_file_size = UNLIMITED;
select to_char(sysdate) start_time from dual;
column host_name format a20 tru
column name format a20 tru
column value format a60 tru
column error format 999999999999999999

/* get oracle settings and set 10046/ERRORSTACK events */
declare
    type intarray is table of number index by binary_integer;
    v_oravernum intarray;
    v_sid integer;
    v_sidcount integer;
    v_serial# integer;
    v_spid integer;
    v_cursor integer:=0;
    v_host varchar2(1024);
    v_udump varchar2(1024);
    v_bdump varchar2(1024);
begin
    if &1 = 0 then
        select
            distinct i.host_name, p.value into v_host,v_udump
        from v$instance i, v$parameter p
        where p.name like 'user_dump_dest';
        dbms_output.put_line('@@udump='||v_udump);
        select
            distinct i.host_name, p.value into v_host,v_bdump
        from v$instance i, v$parameter p
        where p.name like 'background_dump_dest';
        dbms_output.put_line('@@bdump='||v_bdump);
      
        -- 10046/errorstack
        select count(s.sid) into v_sidcount from v$session s,v$process p
        where process like '&3' and s.paddr=p.addr;
        if v_sidcount != 0 then
            select
                s.sid, s.serial#,p.spid into v_sid, v_serial#,v_spid
            from v$session s,v$process p where process like '&3' and s.paddr=p.addr;
            dbms_output.put_line('@@spid='||v_spid);
            dbms_output.put_line('sid='|| v_sid ||',serial#=' || v_serial#);
            v_cursor := dbms_sql.open_cursor;
            dbms_system.set_ev(v_sid, v_serial#,10046,8,'');
            dbms_system.set_ev(v_sid, v_serial#,65535,3,'ERRORSTACK');
            dbms_sql.close_cursor(v_cursor);
        else
            dbms_output.put_line('spid not found: '||v_sidcount);
        end if;
      
        dbms_output.put_line(chr(10));
    end if;
exception
    when no_data_found then
     dbms_output.put_line('No data found.');
end;
/

set echo on

/* get staus*/
select instance_name, host_name, version, status, startup_time from v$instance;
select * from v$session;
select * from v$process;
select * from v$bgprocess;
select * from v$lock;
select * from v$locked_object;
select * from v$session_wait;
select * from v$latch;
select * from v$latchholder;
select * from v$rowcache;
/* the following if for MTS */
select * from v$dispatcher;
select * from v$shared_server;
select * from v$circuit;
select * from v$queue;
select * from v$dispatcher_rate;

set echo off

/* killsession */
declare
    v_sid integer;
    v_serial# integer;
    v_cursor_id integer;
    ret integer;
begin
    if &1 = -1 then -- -1: end session
        select
            sid, serial# into v_sid, v_serial#
        from v$session where process like '&3';
    
        v_cursor_id := dbms_sql.open_cursor;
        dbms_sql.parse(v_cursor_id,
            'alter system kill session ''' ||
                v_sid || ',' ||
                v_serial# ||
                ''' immediate', DBMS_SQL.NATIVE);
        ret := dbms_sql.execute(v_cursor_id);
        dbms_sql.close_cursor(v_cursor_id);
    end if;
exception
    when no_data_found then
     dbms_output.put_line('No data found.');
end;
/

select to_char(sysdate) end_time from dual;
spool off
exit
