#!/bin/sh

LANG=C;	export	LANG

##
#	log collect script
##

##
#	collect cluster information
##
logc_collect_cluster ()
{
	#echo -e "  collecting cluster information......"

	if [ ! -d log ];
	then
		mkdir -m 0777 log >/dev/null 2>&1
	fi

	##	shared memory dump
	if [ ${clpdmp} = 1 ]
	then
		clpstat -d >/dev/null 2>&1
		cp -a /opt/nec/clusterpro/log/dmp.* log/ >/dev/null 2>&1
		rm -f ${logpath}/dmp.cm ${logpath}/dmp.nm ${logpath}/dmp.rm >/dev/null 2>&1
	fi

	##	log files
	if [ ${clplog} = 1 ]
	then
		cp -a /opt/nec/clusterpro/log/*.cur log/ >/dev/null 2>&1
		cp -a /opt/nec/clusterpro/log/*.log log/ >/dev/null 2>&1
	fi

	## 	config file
	cp -a /opt/nec/clusterpro/etc/clp.conf . >/dev/null 2>&1

	return 0
}

##
#	collect command information
##
logc_collect_command ()
{
	#echo -e "  collecting command information......"

	##	kernel parameters
	sysctl -a >sysctl 2>&1

	##	cluster process status
	ps -eaw -ouser,pid,ppid,%cpu,%mem,vsz,rss,tty,stat,stime,cputime,priority,nice,cmd,wchan=WIDE-WCHAN-COLUMN --sort pid | grep -v grep >ps 2>&1

	##	cluster ps(thread) status
	ps -eLf >ps_th 2>&1

	##	top
	top -b -n 2 >top 2>&1

	##	IPC resource
	ipcs -a >ipcs 2>&1
	ipcs -t >>ipcs 2>&1
	ipcs -p >>ipcs 2>&1

	##	open files
	#lsof >lsof 2>&1

	##	lsmod
	#lsmod >lsmod  2>&1

	##	network statistics
	netstat -in >netstat.if 2>&1
	netstat -apn >netstat.v4 2>&1
	netstat -gn >>netstat.v4 2>&1
	netstat -rn >>netstat.v4 2>&1
	netstat --inet6 -apn >netstat.v6 2>&1
	netstat --inet6 -gn >>netstat.v6 2>&1
	netstat --inet6 -rn >>netstat.v6 2>&1
	
	##	ifconfig
	ifconfig >ifconfig  2>&1

	##	ip
	ip -s l >ip_opt_sl

	##	df
	df >df  2>&1
	df -i >>df  2>&1

	##	raw device information
	raw -qa >raw  2>&1
	
	## systemctl_svcstat
	systemctl -t service >systemctl_svcstat  2>&1

	return 0
}

##
#	collect os information
##
logc_collect_os ()
{
	#echo -e "  collecting os information......"

	##	devices
	cp -fp --parents /proc/devices . >/dev/null 2>&1

	##	mdstat
	cp -fp --parents /proc/mdstat . >/dev/null 2>&1

	##	modules
	cp -fp --parents /proc/modules . >/dev/null 2>&1

	##	lvm
	#cp -frp --parents /proc/lvm . >/dev/null 2>&1

	##	mounts
	cp -fp --parents /proc/mounts . >/dev/null 2>&1

	##	meminfo
	cp -fp --parents /proc/meminfo . >/dev/null 2>&1

	##	scsi/*
	#cp -frp --parents /proc/scsi . >/dev/null 2>&1

	##	ide/*
	#cp -frp --parents /proc/ide . >/dev/null 2>&1

	##	liscal
	#cp -fp --parents /proc/liscalinner . >/dev/null 2>&1
	#cp -fp --parents /proc/liscalstat . >/dev/null 2>&1

	##	ka/khb
	#cp -fp --parents /proc/ka_moninfo . >/dev/null 2>&1
	#cp -fp --parents /proc/khb_moninfo . >/dev/null 2>&1

	##	partitions
	cp -fp --parents /proc/partitions . >/dev/null 2>&1

	##	bonding
	cp -frp --parents /proc/net/bond* . >/dev/null 2>&1

	##	syslog.conf
	#if [ -e /etc/syslog.conf ];
	#then
	#	 cp -a /etc/syslog.conf . >/dev/null 2>&1
	#fi

	##	syslog-ng.conf
	#if [ -e /etc/syslog-ng/syslog-ng.conf ];
	#then
	#	 cp -a /etc/syslog-ng/syslog-ng.conf . >/dev/null 2>&1
	#fi

	##	syslog
	tail -500 /var/log/messages >messages.tail 2>&1

	##	journal
	journalctl -e >journal.tail 2>&1

	##	uptime
	uptime >uptime 2>&1

	return
}

##
#	make archive
##
logc_make_archive ()
{
	#echo -e "  creating archive......"

	cd "${opath}"

	# rotation
	count=$rotate
	while [ $count -gt 0 ]
	do
		fcnt=`expr ${count} - 1`
		precnt=`expr ${fcnt} - 1`

		if [ ${count} = 1 ]
		then
			if [ -f ${opath}/elog_${mtype}0${fname} ]
			then
				rm -f "${opath}/elog_${mtype}0${fname}" >/dev/null 2>&1
			fi
		elif [ ${count} = 2 ]
		then
			if [ -f ${opath}/elog_${mtype}0${fname} ]
			then
				mv ${opath}/elog_${mtype}0${fname} ${opath}/elog_${mtype}${fcnt}${fname}
			fi
		else
			if [ -f ${opath}/elog_${mtype}${precnt}${fname} ]
			then
				mv ${opath}/elog_${mtype}${precnt}${fname} ${opath}/elog_${mtype}${fcnt}${fname}
			fi
		fi

		count=`expr ${count} - 1`
	done

	# archive
	tar -zcf "${opath}/elog_${mtype}0${fname}" ${mtype}>/dev/null 2>&1

	return $?
}

##
#	main
##

logpath=`/opt/nec/clusterpro/bin/clplogcf -p`
if [ $? -ne 0 ]; then
	logpath="/opt/nec/clusterpro/log/"
fi
opath=${logpath}
rotate=5
mtype="type"
fname=".tar.gz"
clplog=0
clpdmp=0

while getopts ":dlo:r:t:" opt;
do
	case $opt in
	d )
		clpdmp=1
		;;
	l )
		clplog=1
		;;
	r )
		rotate=$OPTARG
		;;
	o )
		opath=$OPTARG
		;;
	t )
		mtype=$OPTARG
		;;
	\? )
		#echo -e "\n  invalid option\n"
		exit 9
		;;
	esac

done

#echo -e "\n>>>>> START COLLECT >>>>>"

shift `expr $OPTIND - 1`

wopath=${opath}/${mtype}

if [ -d "${wopath}" ];
then
	rm -fr "${wopath}" >/dev/null 2>&1
	if [ $? -ne 0 ];
	then
		#echo -e "  collect was wrong for failed deletion of directory. (${wopath})"
		exit 252
	fi
fi

mkdir -m 0777 -p "${wopath}" >/dev/null 2>&1
if [ $? -ne 0 ];
then
	#echo -e "  collect was wrong for failed creation of directory. (${wopath})"
	exit 253
fi

##	change out directory
cd "${wopath}"
##	date
date >date 2>&1

##	get default information
logc_collect_command

##	get os information
logc_collect_os

##	get cluster information
logc_collect_cluster

##	date
date >>date 2>&1

##	archive
logc_make_archive
if [ $? -ne 0 ]
then
	#echo -e "  collect was wrong for failed creation of archive."
	exit 255
fi

cd ${opath}

##	rm workpath
rm -fr "${wopath}" >/dev/null 2>&1
if [ $? -ne 0 ];
then
	#echo -e "  collect was wrong for failed deletion of directory. (${wopath})"
	exit 254
fi

#echo -e "<<<<<< END COLLECT <<<<<<\n"

exit 0
