#! /bin/sh 

#------- static variables -------#

readonly OPT_WEBMGR_USE="webmgr-use"
readonly OPT_WEBMGR_SECR="webmgr-security"

readonly TAG_WEBMGR_USE="webmgr/use"
readonly TAG_WEBMGR_ADMINPWD="webmgr/security/adminpwd"
readonly TAG_WEBMGR_USERPWD="webmgr/security/userpwd"
readonly TAG_WEBMGR_LOGINUSER_USE="webmgr/security/loginuser/use"
readonly TAG_WEBMGR_LOGINUSER_GRPLIST="webmgr/security/loginuser/grouplist"
readonly TAG_OPE="/ope"

readonly MSG_CMD_SUCCESS="Command succeeded."
readonly MSG_CMD_FAILED="Command failed."
readonly MSG_CMD_CFSET_FAILED="clpcfset : Command failed."
readonly MSG_ERR_DIR="Not available in this directory."

readonly RET_CMD_SUCCESS=0
readonly RET_CMD_FAILED=1

readonly OPT_CFGET_VALUE="-g"
readonly OPT_CFGET_ENUM="-e"

readonly RET_CFGET_DEFINED=0
readonly RET_CFGET_NOT_FOUND=11

#------- variables -------#

opt_cnt=0
opt_nam=""

ret_execute=${RET_CMD_SUCCESS}


# goto MAIN_ROUTINE



####################################################################
#                                                                  #
# Common Functions                                                 #
#                                                                  #
####################################################################


####################################################################
# name   : PRINT_USAGE
# args   : (none)
# local  : (none)
# in     : (none)
# out    : (none)
# return : (only 0)
# 
# description:
#  Prints usage.
####################################################################
PRINT_USAGE()
{
	echo ""
	echo "Usage:"
	echo "  clpcfreset.sh --webmgr-use             : Enable WebManager"
	echo "  clpcfreset.sh --webmgr-security        : Password Settings"
	echo ""
	return 0
}

#####################################################################
# name   : EXECUTE_CFSET
# arg#1  : Tag name.
# arg#2  : Parameter.
# local  : ret_cfset, cmd_cfset
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Execute the cfset command to reset the setting items.
####################################################################
EXECUTE_CFSET()
{
	local tag_nam=$1
	local param=$2

	local readonly CMD_CFSET="clpcfset"

	local ret_cmd=0
	local ret_cfset=""

	local cmd_cfset="${CMD_CFSET} --internal-use add clsparam ${tag_nam}"
	
	#------- execute clpcfset -------
	if [ "${param}" = "" ]; then
		ret_cfset=`${cmd_cfset} "" 2>&1`
	else
		ret_cfset=`${cmd_cfset} ${param} 2>&1`
	fi

	ret_cmd=$?
	
	#------- check exit code -------
	case ${ret_cmd} in
	0 )
		return ${RET_CMD_SUCCESS}
		;;
	* )
		echo "${MSG_CMD_FAILED}" 1>&2
		echo "${CMD_CFSET} : ${ret_cfset}" 1>&2
		;;
	esac
	
	return ${RET_CMD_FAILED}
}

#####################################################################
# name   : EXECUTE_CFSGET
# arg#1  : Command option (-g or -e).
# arg#2  : Tag name.
# arg#3  : Element.(Specified when -e is specified as an option. Specify "" for -g.)
# local  : CMD_CFGET, ret_cfget, cmd_cfget
# in     : (none)
# out    : (none)
# return : 
#  RET_CFGET_DEFINED   : Resource of the specified type exists.
#  RET_CFGET_NOT_FOUND : Resource of the specified type is not found.
#  RET_CMD_FAILED      : Failed.
# 
# description:
#  Checks if resources of the specified type exist or not,
####################################################################
EXECUTE_CFSGET()
{
	local option=$1
	local tag_nam=$2
	local elem=$3

	local readonly CMD_CFGET="clpcfget"
	local ret_cmd=0
	local ret_cfget=""
	
	local cmd_cfget="${CMD_CFGET} ${option} /root/${tag_nam}${elem} -i ${current}/clp.conf"

	#------- get only exit code of clpcfget command -------
	ret_cfget=`${cmd_cfget} 2>&1`
	ret_cmd=$?

	#------- check exit code -------
	case ${ret_cmd} in
	${RET_CFGET_DEFINED} | ${RET_CFGET_NOT_FOUND} )
		return ${ret_cmd}
		;;
	* )
		echo "${MSG_CMD_FAILED}" 1>&2
		echo "${CMD_CFGET} : ${ret_cfget}" 1>&2
		;;
	esac
	return ${RET_CMD_FAILED}
}

#####################################################################
# name   : RESET_PARAM
# arg#1  : Command option (-g or -e).
# arg#2  : Tag name.
# arg#3  : Element.(Specified when -e is specified as an option. Specify "" for -g.)
# arg#4  : Parameter.
# local  : ret_cfget
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Checks if resources of the specified type exist or not,
####################################################################
RESET_PARAM()
{
	local option="$1"
	local tag_nam="$2"
	local elem="$3"
	local param="$4"

	local ret_cfget=0

	EXECUTE_CFSGET "${option}" "${tag_nam}" "${elem}"
	ret_cfget=$?

	#------- check exit code -------
	case ${ret_cfget} in
	${RET_CFGET_DEFINED})
		EXECUTE_CFSET "${tag_nam}" "${param}"
		return $?
		;;
	${RET_CFGET_NOT_FOUND} )
		return ${RET_CMD_SUCCESS}
		;;
	esac
	return ${RET_CMD_FAILED}
}

####################################################################
#                                                                  #
# Main Routine                                                     #
#                                                                  #
####################################################################
#:MAIN_ROUTINE

#------- directory check -------#

current=`pwd`
etcpath="/opt/nec/clusterpro/etc"
if [ "${current}" = "${etcpath}" ]; then
	echo "${MSG_ERR_DIR}" 1>&2
	exit ${RET_CMD_FAILED}
fi

#------- option check -------#

opt_cnt=0

for i in $@
do
	case "$i" in
	"--${OPT_WEBMGR_USE}" )
		opt_nam=${OPT_WEBMGR_USE}
		opt_cnt=`expr ${opt_cnt} + 1`
		;;
	"--${OPT_WEBMGR_SECR}" )
		opt_nam=${OPT_WEBMGR_SECR}
		opt_cnt=`expr ${opt_cnt} + 1`
		;;
	* )
		PRINT_USAGE
		exit ${RET_CMD_FAILED}
		;;
	esac
done

if [ ${opt_cnt} -ne 1 ]
then
	PRINT_USAGE
	exit ${RET_CMD_FAILED}
fi

#------- execute cfreset -------#
if [ "${opt_nam}" = "${OPT_WEBMGR_USE}" ]
then
	RESET_PARAM "${OPT_CFGET_VALUE}" "${TAG_WEBMGR_USE}" "" "1"
	ret_execute=$?
	if [ "${ret_execute}" -eq "${RET_CMD_SUCCESS}" ]; then
		echo "${MSG_CMD_SUCCESS}"
	fi
	exit ${ret_execute}
elif [ "${opt_nam}" = "${OPT_WEBMGR_SECR}" ]
then
	RESET_PARAM "${OPT_CFGET_VALUE}" "${TAG_WEBMGR_ADMINPWD}" "" ""
	ret_execute=$?
	if [ "${ret_execute}" -ne "${RET_CMD_SUCCESS}" ]; then
		exit ${ret_execute}
	fi
	RESET_PARAM "${OPT_CFGET_VALUE}" "${TAG_WEBMGR_USERPWD}" "" ""
	ret_execute=$?
	if [ "${ret_execute}" -ne "${RET_CMD_SUCCESS}" ]; then
		exit ${ret_execute}
	fi
	RESET_PARAM "${OPT_CFGET_VALUE}" "${TAG_WEBMGR_LOGINUSER_USE}" "" ""
	ret_execute=$?
	if [ "${ret_execute}" -ne "${RET_CMD_SUCCESS}" ]; then
		exit ${ret_execute}
	fi
	RESET_PARAM "${OPT_CFGET_ENUM}" "${TAG_WEBMGR_LOGINUSER_GRPLIST}" "${TAG_OPE}" ""
	ret_execute=$?
	if [ "${ret_execute}" -eq "${RET_CMD_SUCCESS}" ]; then
		echo "${MSG_CMD_SUCCESS}"
	fi
	exit ${ret_execute}
fi

PRINT_USAGE
exit ${RET_CMD_FAILED}
