#!/bin/sh
#
# Startup script for the CLUSTERPRO node manager
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=0
LANG=C

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_
export LANG
# See how we were called.
case "$1" in
  start)
	targetos=`/bin/uname`
	clp_filedel "$1" init_nm $targetos
	clp_logwrite "$1" "clusterpro_node manager start process start." init_nm
	
	#
	cd /opt/nec/clusterpro/bin

	#
	if [ "$targetos" = "SunOS" ]
	then
		echo "Starting clusterpro node manager: \c"
	else
		logging=`clpcfget -g /root/event/container/logging` 
		cfget_ret=$?
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Starting clusterpro node manager: " > /dev/null 2>&1
		else
			echo -n "Starting clusterpro node manager: "
		fi
	fi

	#
	clp_logwrite "$1" "clppidof start." init_nm
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --nm 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_nm

	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "node manager already exist." init_nm
		clp_logwrite "$1" "clusterpro_nm start process end." init_nm
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success $targetos > /dev/null 2>&1
		else
			clp_success $targetos
		fi
		exit 0
	fi

	# starting clusterpro node manager
	clp_logwrite "$1" "node manager start process start." init_nm
	./clpmonp --nm > /dev/null 2>&1
	monp_ret=$?
	clp_logwrite "$1" "node manager start process end.("$monp_ret")" init_nm

	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_checkerr "$monp_ret" $targetos > /dev/null 2>&1
	else
		clp_checkerr "$monp_ret" $targetos
	fi
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		clp_logwrite "$1" "clusterpro_nm start process end." init_nm
		exit 0
	fi

	# PIDFile for systemd
	[ ! -d ../work/service ] && { mkdir -m 0755 ../work/service >/dev/null 2>&1; }
	[ -f ../work/service/clusterpro_nm.pid ] && { rm -f ../work/service/clusterpro_nm.pid >/dev/null 2>&1; }

	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --nm 2>&1`

	if [ "$pids" != "" ]
	then
		echo $pids > /opt/nec/clusterpro/work/service/clusterpro_nm.pid 2>&1
		clp_logwrite "$1" "create pid file.("$pids")" init_nm
	fi

	clp_logwrite "$1" "clusterpro_nm start process end." init_nm
	;;
  stop)
	targetos=`/bin/uname`

	clp_filedel "$1" init_nm $targetos
	clp_logwrite "$1" "clusterpro_nm stop process start." init_nm

	#
	if [ "$targetos" = "SunOS" ]
	then
		echo "Shutting down clusterpro node manager: \c"
	else
		logging=`clpcfget -g /root/event/container/logging` 
		cfget_ret=$?
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			echo -n "Shutting down clusterpro node manager: " > /dev/null 2>&1
		else
			echo -n "Shutting down clusterpro node manager: "
		fi
	fi

	#
	cd /opt/nec/clusterpro/bin

	# PIDFile for systemd
	[ -f ../work/service/clusterpro_nm.pid ] && { rm -f ../work/service/clusterpro_nm.pid >/dev/null 2>&1; }
	clp_logwrite "$1" "rm pid file." init_nm

	#
	clp_logwrite "$1" "clppidof start." init_nm
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --nm 2>&1`
	clp_logwrite "$1" "clppidof end.(pids=${pids})" init_nm
	
	if [ "$pids" != "" ]
	then
		# shutting down clusterpro node manager
		clp_logwrite "$1" "node manager stop process start." init_nm
		if [ "$targetos" = "SunOS" ]
		then
			kill -17 "$pids" 2>/dev/null
			kill_ret=$?
		else
			kill -12 "$pids" 2>/dev/null
			kill_ret=$?
		fi
		clp_logwrite "$1" "node manager stop process end.("$kill_ret")" init_nm

		i=0
		while [ "$i" -lt "270" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_nm
			pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --nm 2>&1`
			clp_logwrite "$1" "clppidof2 end.(pids=${pids})" init_nm
			
			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "node manager stop success." init_nm
				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_success $targetos > /dev/null 2>&1
				else
					clp_success $targetos
				fi

				clp_logwrite "$1" "clusterpro_nm stop process end." init_nm
				exit 0
			fi

			sleep 1
			i=`expr "$i" + 1`
		done
		
		clp_logwrite "$1" "node manager stop timeout." init_nm
	else
		clp_logwrite "$1" "node manager not exist." init_nm
	fi
	
	clp_logwrite "$1" "clusterpro_nm stop process end." init_nm
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success $targetos > /dev/null 2>&1
	else
		clp_success $targetos
	fi
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi

	sleep 1
	$0 start
	;;
  status)
	targetos=`/bin/uname`
	if [ "$targetos" = "SunOS" ]
	then
		clp_status_s clpnm
	else
		clp_status clpnm
	fi
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
