#!/bin/sh
#
# Startup script for the CLUSTERPRO mirror
#

#
# main()
#

# Source function library.
if [ -f /etc/rc.d/init.d/functions ]
then
	. /etc/rc.d/init.d/functions
elif [ -f /etc/rc.status ]
then
	. /etc/rc.status
fi

. /opt/nec/clusterpro/bin/clpfunctions

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/opt/nec/clusterpro/bin
LD_LIBRARY_PATH=/opt/nec/clusterpro/lib
MALLOC_CHECK_=2
HALT_TARGET="halt.target"
POWEROFF_TARGET="poweroff.target"
REBOOT_TARGET="reboot.target"
LANG=C

export PATH
export LD_LIBRARY_PATH
export MALLOC_CHECK_
export LANG

BIN_PATH=/opt/nec/clusterpro/bin

module="/opt/nec/clusterpro/drivers/md/liscal"
drv_dir="/opt/nec/clusterpro/drivers/md/distribution/current/"
SCRIPT_LOG="/opt/nec/clusterpro/log/init_md.start.log"
INIT_MD_PATH="/opt/nec/clusterpro/work/service/init_md"

# See how we were called.
case "$1" in
  start)
	clp_filedel "$1" init_md
	clp_logwrite "$1" "clusterpro_md start process start." init_md
	errornum=0

	clp_checkarch "$1" init_md
	arch_ret=$?
	if [ "$arch_ret" -eq "1" ]
	then
		clp_logwrite "$1" "arch is ia64 or ppc64." init_md
		errornum=1
	fi
	
	#
	cd $BIN_PATH
	
	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		echo -n "Starting clusterpro mirror: " > /dev/null 2>&1
	else
		echo -n "Starting clusterpro mirror: "
	fi
	
	#
	clp_logwrite "$1" "clppidof monp start." init_md
	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --mdagent 2>&1`
	clp_logwrite "$1" "clppidof monp end.(pids=${pids})" init_md
	
	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "monp(mdagent) already exist." init_md
		clp_logwrite "$1" "clusterpro_md start process end." init_md
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success > /dev/null 2>&1
		else
			clp_success
		fi
		exit 0
	fi

	#
	clp_logwrite "$1" "clppidof mdagent start." init_md
	pids=`clppidof /opt/nec/clusterpro/bin/clpmdagent 2>&1`
	clp_logwrite "$1" "clppidof mdagent end.(pids=${pids})" init_md
	
	if [ "$pids" != "" ]
	then
		clp_logwrite "$1" "mdagent already exist. ignore." init_md
		errornum=100
	fi
	
	#create link of driver
	if [ "$errornum" = "0" ]
	then
		clp_logwrite "$1" "uname -a start." init_md
		kern_ver=`uname -a | gawk '{print $3}'`
		clp_logwrite "$1" "uname -a end." init_md
		
		if [ -z $kern_ver ]
		then
			if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
			then
				clp_success > /dev/null 2>&1
			else
				clp_success
			fi
			clp_logwrite "$1" "uname -a failed." init_md
			errornum=2
		fi
	fi
	
	#get kernel version
	if [ "$errornum" = "0" ]
	then
		clp_logwrite "$1" "uname -r start." init_md
		kern=`uname -r | grep "^2.4"`
		kern_ret=$?
		clp_logwrite "$1" "uname -r end." init_md
		
		if [ "$kern_ret" = "0" ]
		then
			kern_rel=".o"
		else
			kern_rel=".ko"
		fi
		
		module="${module}${kern_rel}"
		
		rm -f $module > /dev/null 2>&1
		
		drv_file="${drv_dir}liscal-${kern_ver}${kern_rel}"
		
		clp_logwrite "$1" "module="$module"" init_md
		clp_logwrite "$1" "drv_file="$drv_file"" init_md
		
		if [ -f ${drv_file} ]
		then
			clp_logwrite "$1" "ln -s start." init_md
			ln -s $drv_file $module
			clp_logwrite "$1" "ln -s end." init_md
		else
			if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
			then
				clp_success > /dev/null 2>&1
			else
				clp_success
			fi
			clp_logwrite "$1" "driver file not exist." init_md
			errornum=3
		fi
	fi
	
	#initialize NMP
	if [ "$errornum" = "0" ]
	then
		clp_logwrite "$1" "clpmdinit start." init_md
		./clpmdinit --create normal > $SCRIPT_LOG 2>&1
		init_ret=$?
		clp_logwrite "$1" "clpmdinit end.("$init_ret")" init_md
		
		if [ "$init_ret" = "100" ]
		then
			if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
			then
				clp_success > /dev/null 2>&1
			else
				clp_success
			fi
			errornum=4
		elif [ "$init_ret" != "0" ]
		then
			if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
			then
				clp_success > /dev/null 2>&1
			else
				clp_success
			fi
			clp_logwrite "$1" "clpmdinit failed." init_md
			errornum=4
		fi
	fi
	
	if [ "$errornum" = "0" ]
	then
		clp_logwrite "$1" "clphdinit start." init_md
		./clphdinit --create normal >> $SCRIPT_LOG 2>&1
		init_ret=$?
		clp_logwrite "$1" "clphdinit end.("$init_ret")" init_md
		
		if [ "$init_ret" = "100" ]
		then
			if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
			then
				clp_success > /dev/null 2>&1
			else
				clp_success
			fi
			errornum=5
		elif [ "$init_ret" != "0" ]
		then
			if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
			then
				clp_success > /dev/null 2>&1
			else
				clp_success
			fi
			clp_logwrite "$1" "clphdinit failed." init_md
			errornum=5
		fi
	fi
	
	#delete init_md file
	clp_logwrite  "$1" "delete init_md file." init_md
	rm $INIT_MD_PATH -f

	# starting clusterpro mirror
	clp_logwrite "$1" "mdagent start process start." init_md
	if [ "$errornum" = "0" ] || [ "$errornum" = "100" ]
	then
		./clpmonp --mdagent > /dev/null 2>&1
	else
		./clpmonp --mdagent -n > /dev/null 2>&1
	fi
	monp_ret=$?
	clp_logwrite "$1" "mdagent start process end.("$monp_ret")" init_md
	
	clp_logwrite "$1" "start to wait $INIT_MD_PATH file to be created ." init_md
	TIME=0
	while [ "$TIME" -lt "60" ]
	do
		sleep 1
		if [ -e $INIT_MD_PATH ]
		then
			clp_logwrite "$1" "`ls -l $INIT_MD_PATH`" init_md
			break;
		fi
		TIME=`expr "$TIME" + 1`
	done
	if [ $TIME -eq 60 ]
	then
		clp_logwrite "$1" "timeout occurred when waiting init_md file created." init_md
	else
		clp_logwrite "$1" "init_md file be created successfully." init_md
	fi
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_checkerr "$monp_ret" > /dev/null 2>&1
	else
		clp_checkerr "$monp_ret"
	fi
	chk_ret=$?
	if [ "$chk_ret" = "1" ]
	then
		errornum=6
	fi

	# PIDFile for systemd
	[ ! -d ../work/service ] && { mkdir -m 0755 ../work/service >/dev/null 2>&1; }
	[ -f ../work/service/clusterpro_md.pid ] && { rm -f ../work/service/clusterpro_md.pid >/dev/null 2>&1; }

	pids=`/opt/nec/clusterpro/bin/clppidof /opt/nec/clusterpro/bin/clpmonp --mdagent 2>&1`

	if [ "$pids" != "" ]
	then
		echo $pids > /opt/nec/clusterpro/work/service/clusterpro_md.pid 2>&1
		clp_logwrite "$1" "create pid file.("$pids")" init_md
	fi

	clp_logwrite "$1" "clusterpro_md start process end." init_md
	;;
  stop)
	clp_filedel "$1" init_md
	clp_logwrite "$1" "clusterpro_md stop process start." init_md
	errornum=0

	clp_checkarch "$1" init_md
	arch_ret=$?
	if [ "$arch_ret" = "1" ]
	then
		clp_logwrite "$1" "arch is ia64 or ppc64." init_md
		errornum=1
	fi
	
	#
	logging=`clpcfget -g /root/event/container/logging` 
	cfget_ret=$?
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		echo -n "Shutting down clusterpro mirror : " > /dev/null 2>&1
	else
		echo -n "Shutting down clusterpro mirror : "
	fi
	
	#
	cd $BIN_PATH

	# PIDFile for systemd
	[ -f ../work/service/clusterpro_md.pid ] && { rm -f ../work/service/clusterpro_md.pid >/dev/null 2>&1; }
	clp_logwrite "$1" "rm pid file." init_md

	#
	targetos=`/bin/uname`

	clp_logwrite "$1" "systemctl list-units --type target start." init_md
	tgtlst=`systemctl list-units --type target`
	clp_logwrite "$1" "systemctl list-units --type target end.(tgtlst=${tgtlst})" init_md

	if echo $tgtlst | grep -sqE "$HALT_TARGET|$POWEROFF_TARGET"
	then
		:
	elif echo $tgtlst | grep -sq "$REBOOT_TARGET"
	then
		:
	else
		clpcl --nodestat > /dev/null 2>&1
		clnode=$?
		if [ ${clnode} != 0 ]
		then
			clp_logwrite "$1" "Failed to stop mdagent.(clnode="${clnode}".) Check the cluster status." init_md
			if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
			then
				clp_success > /dev/null 2>&1
			else
				clp_success
			fi
			exit 0
		fi
	fi
	
	#
	clp_logwrite "$1" "clppidof start." init_md
	pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --mdagent 2>&1`
	clp_logwrite "$1" "clppidof end." init_md
	
	if [ "$pids" != "" ]
	then
		# shutting down /opt/nec/clusterpro/bin/clpmdagent
		clp_logwrite "$1" "mdagent stop process start." init_md
		kill -12 "$pids" 2>/dev/null
		kill_ret=$?
		clp_logwrite "$1" "mdagent stop process end.("$kill_ret")" init_md
		
		i=0
		while [ "$i" -lt "65" ]
		do
			clp_logwrite "$1" "clppidof2 start." init_md
			pids=`clppidof /opt/nec/clusterpro/bin/clpmonp --mdagent 2>&1`
			clp_logwrite "$1" "clppidof2 end." init_md
			
			if [ "$pids" = "" ]
			then
				clp_logwrite "$1" "mdagent stop success." init_md
				if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
				then
					clp_success > /dev/null 2>&1
				else
					clp_success
				fi
				
				# Terminating the remaining grandchildren of clpmdagent that did not finish on a SIGTERM
				pid_lst=`ps aux | grep '[c]lpmdagent' | awk '{print $2}'`
				pid_cnt=`echo $pid_lst | wc -w`
				clp_logwrite "$1" "remaining pid count=$pid_cnt, clpmdagent pid list=$pid_lst." init_md
				if [ "$pid_cnt" != "0" ]
				then
					kill -9 $pid_lst > /dev/null 2>&1
					pid_lst=`ps aux | grep '[c]lpmdagent' | awk '{print $2}'`
					pid_cnt=`echo $pid_lst | wc -w`
					clp_logwrite "$1" "remaining pid count=$pid_cnt, clpmdagent pid list=$pid_lst." init_md
				fi
				
				clp_logwrite "$1" "clusterpro_md stop process end." init_md
				exit 0
			fi
			
			sleep 1
			i=`expr "$i" + 1`
		done
		
		clp_logwrite "$1" "mdagent stop timeout." init_md
	else
		clp_logwrite "$1" "mdagent not exist." init_md
		if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
		then
			clp_success $targetos > /dev/null 2>&1
		else
			clp_success $targetos
		fi
		
		if [ "$targetos" = "Linux" ]
		then
			rm -f /var/lock/subsys/clusterpro_md
		fi
		clp_logwrite "$1" "clusterpro_md stop process end." init_md
		exit 0
	fi
	
	if [ "$cfget_ret" = "0" -a "$logging" = "1" ]
	then
		clp_success > /dev/null 2>&1
	else
		clp_success
	fi
	
	clp_logwrite "$1" "clusterpro_md stop process end." init_md
	exit 0
	;;
  restart)
	$0 stop
	if [ "$?" != "0" ]
	then
		exit 1
	fi
	
	sleep 5
	$0 start
	;;
  status)
	clp_status clpmdagent
	;;
  *)
	echo "Usage: $0 {start|stop|restart|status}"
	exit 1
	;;
esac

exit 0
