#!/bin/bash

##	date
date >date 2>&1

##	devices
cp -fp --parents /proc/devices . >/dev/null 2>&1

##	mdstat
cp -fp --parents /proc/mdstat . >/dev/null 2>&1

##	modules
cp -fp --parents /proc/modules . >/dev/null 2>&1

##	mounts
cp -fp --parents /proc/mounts . >/dev/null 2>&1

##	meminfo
cp -fp --parents /proc/meminfo . >/dev/null 2>&1

##	partitions
cp -fp --parents /proc/partitions . >/dev/null 2>&1

##	bonding
cp -frp --parents /proc/net/bond* . >/dev/null 2>&1

##	kernel parameters
sysctl -a >sysctl 2>&1

##	cluster process status
ps -eaw -ouser,pid,ppid,%cpu,%mem,vsz,rss,tty,stat,stime,cputime,priority,nice,cmd,wchan=WIDE-WCHAN-COLUMN --sort pid | grep -v grep >ps 2>&1

##	cluster ps(thread) status
ps -eLf >ps_th 2>&1

##	top
top -b -n 2 >top 2>&1

##	IPC resource
ipcs -a >ipcs 2>&1
ipcs -t >>ipcs 2>&1
ipcs -p >>ipcs 2>&1

##	network statistics
netstat -in >netstat.if 2>&1
netstat -apn >netstat.v4 2>&1
netstat -gn >>netstat.v4 2>&1
netstat -rn >>netstat.v4 2>&1

##	ifconfig
ifconfig >ifconfig  2>&1

##	ip
ip -s l >ip_opt_sl

##	df
df >df  2>&1
df -i >>df  2>&1

##	raw device information
raw -qa >raw  2>&1

## systemctl_svcstat
systemctl -t service >systemctl_svcstat  2>&1

##	syslog
tail -500 /var/log/messages >messages.tail 2>&1

##	journal
journalctl -e >journal.tail 2>&1

##	uptime
uptime >uptime 2>&1