#! /bin/sh 

#
#  usage : clpvcenterforcestop.sh <sub-command>
# 
#  sub-command :
#         stop
#         check-stop
#         monitor
#

#------- static variables -------#

readonly OPT_MODE_MONITOR="monitor"
readonly OPT_MODE_STOPSRV="stop"
readonly OPT_MODE_CHECKSTOP="check-stop"

readonly MSG_CMD_FAILED="Command failed."
readonly MSG_ERR_INVALID_OPTION="Invalid option."
readonly MSG_ERR_INVALID_PARAM="Invalid parameter."

readonly VMINFO_SUCCESS="Information of Virtual Machine "

readonly POEWEROFF_SUCCESS="powered off"
readonly RESET_SUCCESS="reset successfully"

readonly RET_CMD_SUCCESS=0
readonly RET_CMD_FAILED=1

#------- variables -------#

opt_cnt=0
opt_nam=""

ret_execute=${RET_CMD_SUCCESS}


# goto MAIN_ROUTINE


####################################################################
#                                                                  #
# Common Functions                                                 #
#                                                                  #
####################################################################


#####################################################################
# name   : DO_MONITOR
# arg#1  : (none)
# local  : ret_cmd, ret_vcli, cmd_line
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Get server power status.
####################################################################
DO_MONITOR()
{
	ret_cmd=0
	ret_vcli=""

	cmd_line="${CLP_VCLI_PATH}/apps/vm/vminfo.pl --server ${CLP_VCENTER_HOST} --username ${CLP_VCENTER_USER} --password ${CLP_VCENTER_PASSWORD} --datacenter ${CLP_DATACENTER_NAME} --vmname ${CLP_VMNAME}"
	
	#------- execute vminfo -------
	ret_vcli=$(${cmd_line} 2>&1)

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -ne ${RET_CMD_SUCCESS} ]
	then
		echo "${MSG_CMD_FAILED} [DO_MONITOR() failed]" 1>&2
		return ${RET_CMD_FAILED}
	fi

	#------- check vmname -------
	if echo "$ret_vcli" | grep -q "\b$VMINFO_SUCCESS$CLP_VMNAME\b"; then
		return ${RET_CMD_SUCCESS}
	fi

	echo "${CLP_VMNAME} not found." 1>&2
	echo "${ret_vcli}" 1>&2

	return ${RET_CMD_FAILED}

}

#####################################################################
# name   : FORCE_STOP_SRV
# arg#1  : (none)
# local  : ret_cmd, ret_vcli, cmd_line
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Performing a forced stop action.
####################################################################
FORCE_STOP_SRV()
{
	ret_cmd=0
	ret_vcli=""

	cmd_line="${CLP_VCLI_PATH}/apps/vm/vmcontrol.pl --server ${CLP_VCENTER_HOST} --username ${CLP_VCENTER_USER} --password ${CLP_VCENTER_PASSWORD} --datacenter ${CLP_DATACENTER_NAME} --vmname ${CLP_VMNAME} --operation ${CLP_VCENTER_ACTION}"
	
	#------- execute vmcontrol -------
	ret_vcli=$(${cmd_line} 2>&1)

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -ne ${RET_CMD_SUCCESS} ]
	then
		echo "${MSG_CMD_FAILED} [FORCE_STOP_SRV() failed]" 1>&2
		return ${RET_CMD_FAILED}
	fi
	
	#------- check message -------
	if echo "$ret_vcli" | grep -q "\b$POEWEROFF_SUCCESS\b"; then
		return ${RET_CMD_SUCCESS}
	fi
	if echo "$ret_vcli" | grep -q "\b$RESET_SUCCESS\b"; then
		return ${RET_CMD_SUCCESS}
	fi

	echo "${MSG_CMD_FAILED} [FORCE_STOP_SRV() failed]" 1>&2
	echo "${ret_vcli}" 1>&2

	return ${RET_CMD_FAILED}
}

#####################################################################
# name   : CHECK_STOP
# arg#1  : (none)
# local  : ret_cmd, ret_vcli, cmd_line
# in     : (none)
# out    : (none)
# return : 
#  RET_CMD_SUCCESS : Succeeded.
#  RET_CMD_FAILED  : Failed.
# 
# description:
#  Check server power.
####################################################################
CHECK_STOP()
{
	ret_cmd=0
	ret_vcli=""

	cmd_line="${CLP_VCLI_PATH}/apps/vm/vminfo.pl --server ${CLP_VCENTER_HOST} --username ${CLP_VCENTER_USER} --password ${CLP_VCENTER_PASSWORD} --datacenter ${CLP_DATACENTER_NAME} --vmname ${CLP_VMNAME} --powerstatus "poweredOff""
	
	#------- execute vminfo -------
	ret_vcli=$(${cmd_line} 2>&1)

	ret_cmd=$?
	
	#------- check exit code -------
	if [ ${ret_cmd} -ne ${RET_CMD_SUCCESS} ]
	then
		echo "${MSG_CMD_FAILED} [CHECK_STOP() failed]" 1>&2
		return ${RET_CMD_FAILED}
	fi

	#------- check vmname -------
	if echo "$ret_vcli" | grep -q "\b$VMINFO_SUCCESS$CLP_VMNAME\b"; then
		return ${RET_CMD_SUCCESS}
	fi

	echo "${MSG_CMD_FAILED} [CHECK_STOP() failed]" 1>&2
	echo "${ret_vcli}" 1>&2

	return ${RET_CMD_FAILED}
}

####################################################################
#                                                                  #
# Main Routine                                                     #
#                                                                  #
####################################################################
#:MAIN_ROUTINE

#------- option check -------#

opt_cnt=0

for i in "$@"
do
	case "$i" in
	"${OPT_MODE_MONITOR}" )
		opt_nam=${OPT_MODE_MONITOR}
		opt_cnt=$((opt_cnt + 1))
		;;
	"${OPT_MODE_STOPSRV}" )
		opt_nam=${OPT_MODE_STOPSRV}
		opt_cnt=$((opt_cnt + 1))
		;;
	"${OPT_MODE_CHECKSTOP}" )
		opt_nam=${OPT_MODE_CHECKSTOP}
		opt_cnt=$((opt_cnt + 1))
		;;
	* )
		echo "${MSG_ERR_INVALID_OPTION}" 1>&2
		exit ${RET_CMD_FAILED}
		;;
	esac
done

if [ ${opt_cnt} -ne 1 ]
then
	echo "${MSG_ERR_INVALID_OPTION}" 1>&2
	exit ${RET_CMD_FAILED}
fi

#------- environmental variables check -------#
if [ "${opt_nam}" = "${OPT_MODE_STOPSRV}" ]; then
	if [ -z "$CLP_VCENTER_ACTION" ]; then
		echo "${MSG_ERR_INVALID_PARAM} [CLP_VCENTER_ACTION]" 1>&2
		exit ${RET_CMD_FAILED}
	fi
fi
if [ -z "$CLP_VCLI_PATH" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_VCLI_PATH]" 1>&2
	exit ${RET_CMD_FAILED}
elif [ -z "$CLP_VCENTER_USER" ]; then
 	echo "${CLP_VCENTER_HOST} [CLP_VCENTER_HOST]" 1>&2
	exit ${RET_CMD_FAILED}
elif [ -z "$CLP_VCENTER_USER" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_VCENTER_USER]" 1>&2
	exit ${RET_CMD_FAILED}
elif [ -z "$CLP_VCENTER_PASSWORD" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_VCENTER_PASSWORD]" 1>&2
	exit ${RET_CMD_FAILED}
elif [ -z "$CLP_VMNAME" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_VMNAME]" 1>&2
	exit ${RET_CMD_FAILED}
elif [ -z "$CLP_DATACENTER_NAME" ]; then
 	echo "${MSG_ERR_INVALID_PARAM} [CLP_DATACENTER_NAME]" 1>&2
	exit ${RET_CMD_FAILED}
fi

#------- execute -------#
case "${opt_nam}" in
"${OPT_MODE_MONITOR}" )
	DO_MONITOR
	;;
"${OPT_MODE_STOPSRV}" )
	FORCE_STOP_SRV
	;;
"${OPT_MODE_CHECKSTOP}" )
	CHECK_STOP
	;;
* )
	echo "${MSG_ERR_INVALID_OPTION}" 1>&2
	exit ${RET_CMD_FAILED}
	;;
esac

ret_execute=$?

exit ${ret_execute}