#! /bin/sh

####################################################################
#
# PRINT_LIST	--list
#

PRINT_LIST()
{
	echo ""
	if [ -e /bin/systemctl ]	# systemctl
	then
		systemctl list-unit-files | grep clusterpro | awk '{printf "%-50s %s\n", $1, $2}'

	elif [ -e /usr/bin/systemctl ]	# systemctl
	then
		systemctl list-unit-files | grep clusterpro | awk '{printf "%-50s %s\n", $1, $2}'

	fi

	echo ""
}

####################################################################
#
# PRINT_USAGE	--help -h
#

PRINT_USAGE()
{
	echo ""
	echo "Usage:"
	echo "  clpsvcctrl.sh --enable <service name>  : enable"
	echo "  clpsvcctrl.sh --enable -a              : enable"
	echo "  clpsvcctrl.sh --disable <service name> : disable"
	echo "  clpsvcctrl.sh --disable -a             : disable"
	echo "  clpsvcctrl.sh --list                   : list"
	echo ""
}

####################################################################
#
# MAIN_EVT	clusterpro_evt
#

MAIN_EVT()
{
	eval $CMD_STRING clusterpro_evt > /dev/null 2>&1
}

####################################################################
#
# MAIN_NM	clusterpro_nm
#

MAIN_NM()
{
	eval $CMD_STRING clusterpro_nm > /dev/null 2>&1
}

####################################################################
#
# MAIN_TRN	clusterpro_trn
#

MAIN_TRN()
{
	eval $CMD_STRING clusterpro_trn > /dev/null 2>&1
}

####################################################################
#
# MAIN_IB	clusterpro_ib
#

MAIN_IB()
{
	eval $CMD_STRING clusterpro_ib > /dev/null 2>&1
}

####################################################################
#
# MAIN_API	clusterpro_api
#

MAIN_API()
{
	eval $CMD_STRING clusterpro_api > /dev/null 2>&1
}

####################################################################
#
# MAIN_MD	clusterpro_md
#

MAIN_MD()
{
	eval $CMD_STRING clusterpro_md > /dev/null 2>&1
}

####################################################################
#
# MAIN_MAIN	clusterpro
#

MAIN_MAIN()
{
	eval $CMD_STRING clusterpro > /dev/null 2>&1
}

####################################################################
#
# MAIN_WEB	clusterpro_webmgr
#

MAIN_WEB()
{
	eval $CMD_STRING clusterpro_webmgr > /dev/null 2>&1
}

####################################################################
#
# MAIN_ALERT	clusterpro_alertsync
#

MAIN_ALERT()
{
	eval $CMD_STRING clusterpro_alertsync > /dev/null 2>&1
}

#************************************************************************************
#************************************************************************************

addflg=0
delflg=0

evtflg=0
nmflg=0
trnflg=0
ibflg=0
apiflg=0
mdflg=0
mainflg=0
webflg=0
alertflg=0

SuSEflg=0

CMD_STRING=""

if [ "$1" = "--enable" ]
then
	addflg=1

elif [ "$1" = "--disable" ]
then
	delflg=1

elif [ "$1" = "--list" ]
then
	PRINT_LIST
	exit 0

elif [ "$1" = "--help" -o "$1" = "-h" ]
then
	PRINT_USAGE
	exit 0

else
	echo "Invalid option."
	exit 1

fi


if [ "$#" -le 1 ]
then
	echo "Invalid option."
	exit 1
fi

for i in $@
do
	case $i in
	--enable | --disable)
		;;
	clusterpro_evt)
		evtflg=1
		;;
	clusterpro_nm)
		nmflg=1
		;;
	clusterpro_trn)
		trnflg=1
		;;
	clusterpro_ib)
		ibflg=1
		;;
	clusterpro_api)
		apiflg=1
		;;
	clusterpro_md)
		mdflg=1
		;;
	clusterpro)
		mainflg=1
		;;
	clusterpro_webmgr)
		webflg=1
		;;
	clusterpro_alertsync)
		alertflg=1
		;;
	base)
		evtflg=1
		nmflg=1
		trnflg=1
		ibflg=1
		;;
	core)
		mdflg=1
		mainflg=1
		;;
	mgr)
		webflg=1
		alertflg=1
		;;
	-a)
		evtflg=1
		nmflg=1
		trnflg=1
		ibflg=1
		apiflg=1
		mdflg=1
		mdflg=1
		mainflg=1
		webflg=1
		alertflg=1
		;;
	*)
		echo "Invalid option."
		exit 1
		;;
	esac
done


if [ -e /etc/SuSE-release ]
then
	SuSEflg=1
fi

if [ $addflg -eq 1 ]
then
	CMD_STRING="systemctl enable"
elif [ $delflg -eq 1 ]
then
	CMD_STRING="systemctl disable"
fi

if [ $SuSEflg -eq 1 ]
then
	CMD_STRING="$CMD_STRING --force"
fi

if [ "$evtflg" -eq 1 ]
then
	MAIN_EVT
fi
	
if [ "$nmflg" -eq 1 ]
then
	MAIN_NM
fi
	
if [ "$trnflg" -eq 1 ]
then
	MAIN_TRN
fi
	
if [ "$ibflg" -eq 1 ]
then
	MAIN_IB
fi
	
if [ "$apiflg" -eq 1 ]
then
	MAIN_API
fi
	
if [ "$mdflg" -eq 1 ]
then
	MAIN_MD
fi
	
if [ "$mainflg" -eq 1 ]
then
	MAIN_MAIN
fi
	
if [ "$webflg" -eq 1 ]
then
	MAIN_WEB
fi
	
if [ "$alertflg" -eq 1 ]
then
	MAIN_ALERT
fi

exit 0

